/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.config.ConfigStylePolicy;
import com.kumbasoft.core.beans.config.ConfigXMLManager;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.SSLFrontSide;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigWebTokenService
extends ConfigConfigBase {
    private String userSummary;
    private String priority;
    private ObjectReference<ConfigXMLManager> xMLManager;
    private String requestType;
    private ArrayList<SSLFrontSide> frontSide;
    private ObjectReference<ConfigStylePolicy> stylePolicy;
    private String rewriteErrors;
    private String delayErrors;
    private long delayErrorsDuration;
    private long frontTimeout;
    private long frontPersistentTimeout;
    private String frontHTTPVersion;
    private String hTTPClientIPLabel;
    private String hTTPLogCorIDLabel;
    private String debugMode;
    private long debugHistory;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="Priority", elementOrder=2, dataPowerType="dmSchedulerPriority", subType="", benign=false, isPassword=false, cliAlias="priority", refType="", isEnumeration=true, javaName="priority", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="normal", displayOrder=0, displayValue="Service priority", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getPriority() {
        return this.priority;
    }

    @XMLInfo(elementType="element", elementName="Priority", elementOrder=2, dataPowerType="dmSchedulerPriority", subType="", benign=false, isPassword=false, cliAlias="priority", refType="", isEnumeration=true, javaName="priority", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="normal", displayValue="Service priority", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPriority(String priority) {
        if (priority == null || Comparison.isIn(priority, DPEnumerations.SCHEDULER_PRIORITY)) {
            this.priority = priority;
        }
    }

    @XMLInfo(elementType="element", elementName="XMLManager", elementOrder=3, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="xml-manager", refType="XMLManager", isEnumeration=false, javaName="xMLManager", javaType="ObjectReference<ConfigXMLManager>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="default", displayOrder=0, displayValue="XML manager", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigXMLManager> getXMLManager() {
        return this.xMLManager;
    }

    @XMLInfo(elementType="element", elementName="XMLManager", elementOrder=3, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="xml-manager", refType="XMLManager", isEnumeration=false, javaName="xMLManager", javaType="ObjectReference<ConfigXMLManager>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="default", displayValue="XML manager", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setXMLManager(ObjectReference<ConfigXMLManager> xMLManager) {
        this.xMLManager = xMLManager;
    }

    @XMLInfo(elementType="element", elementName="RequestType", elementOrder=4, dataPowerType="dmXMLReqRespType", subType="", benign=false, isPassword=false, cliAlias="request-type", refType="", isEnumeration=true, javaName="requestType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="preprocessed", displayOrder=0, displayValue="Request type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getRequestType() {
        return this.requestType;
    }

    @XMLInfo(elementType="element", elementName="RequestType", elementOrder=4, dataPowerType="dmXMLReqRespType", subType="", benign=false, isPassword=false, cliAlias="request-type", refType="", isEnumeration=true, javaName="requestType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="preprocessed", displayValue="Request type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRequestType(String requestType) {
        if (requestType == null || Comparison.isIn(requestType, DPEnumerations.XMLREQ_RESP_TYPE)) {
            this.requestType = requestType;
        }
    }

    public void addFrontSide(SSLFrontSide element) {
        if (element == null) {
            return;
        }
        if (this.frontSide == null) {
            this.frontSide = new ArrayList();
        }
        this.frontSide.add(element);
    }

    public boolean removeFrontSide(SSLFrontSide element) {
        if (element == null || this.frontSide == null) {
            return false;
        }
        return this.frontSide.remove(element);
    }

    @XMLInfo(elementType="element", elementName="FrontSide", elementOrder=5, dataPowerType="dmSSLFrontSide", subType="", benign=false, isPassword=false, cliAlias="listen-on", refType="", isEnumeration=false, javaName="frontSide", javaType="SSLFrontSide", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Source addresses", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<SSLFrontSide> getFrontSide() {
        return this.frontSide;
    }

    @XMLInfo(elementType="element", elementName="FrontSide", elementOrder=5, dataPowerType="dmSSLFrontSide", subType="", benign=false, isPassword=false, cliAlias="listen-on", refType="", isEnumeration=false, javaName="frontSide", javaType="SSLFrontSide", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Source addresses", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFrontSide(ArrayList<SSLFrontSide> frontSide) {
        this.frontSide = frontSide;
    }

    @XMLInfo(elementType="element", elementName="StylePolicy", elementOrder=6, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="stylepolicy", refType="StylePolicy", isEnumeration=false, javaName="stylePolicy", javaType="ObjectReference<ConfigStylePolicy>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="default", displayOrder=0, displayValue="Processing policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigStylePolicy> getStylePolicy() {
        return this.stylePolicy;
    }

    @XMLInfo(elementType="element", elementName="StylePolicy", elementOrder=6, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="stylepolicy", refType="StylePolicy", isEnumeration=false, javaName="stylePolicy", javaType="ObjectReference<ConfigStylePolicy>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="default", displayValue="Processing policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setStylePolicy(ObjectReference<ConfigStylePolicy> stylePolicy) {
        this.stylePolicy = stylePolicy;
    }

    @XMLInfo(elementType="element", elementName="RewriteErrors", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="rewrite-errors", refType="", isEnumeration=true, javaName="rewriteErrors", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Rewrite error messages", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getRewriteErrors() {
        return this.rewriteErrors;
    }

    @XMLInfo(elementType="element", elementName="RewriteErrors", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="rewrite-errors", refType="", isEnumeration=true, javaName="rewriteErrors", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Rewrite error messages", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRewriteErrors(String rewriteErrors) {
        if (rewriteErrors == null || Comparison.isIn(rewriteErrors, DPEnumerations.TOGGLE)) {
            this.rewriteErrors = rewriteErrors;
        }
    }

    @XMLInfo(elementType="element", elementName="DelayErrors", elementOrder=8, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="delay-errors", refType="", isEnumeration=true, javaName="delayErrors", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Delay error messages", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDelayErrors() {
        return this.delayErrors;
    }

    @XMLInfo(elementType="element", elementName="DelayErrors", elementOrder=8, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="delay-errors", refType="", isEnumeration=true, javaName="delayErrors", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Delay error messages", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDelayErrors(String delayErrors) {
        if (delayErrors == null || Comparison.isIn(delayErrors, DPEnumerations.TOGGLE)) {
            this.delayErrors = delayErrors;
        }
    }

    @XMLInfo(elementType="element", elementName="DelayErrorsDuration", elementOrder=9, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="delay-errors-duration", refType="", isEnumeration=false, javaName="delayErrorsDuration", javaType="long", isRequired=false, squelchNull=false, minimum=250, maximum=300000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="1000", displayOrder=0, displayValue="Duration to delay error messages", units="ms", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getDelayErrorsDuration() {
        return this.delayErrorsDuration;
    }

    @XMLInfo(elementType="element", elementName="DelayErrorsDuration", elementOrder=9, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="delay-errors-duration", refType="", isEnumeration=false, javaName="delayErrorsDuration", javaType="long", isRequired=false, squelchNull=false, minimum=250, maximum=300000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="1000", displayValue="Duration to delay error messages", units="ms", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDelayErrorsDuration(long delayErrorsDuration) {
        this.delayErrorsDuration = delayErrorsDuration;
    }

    @XMLInfo(elementType="element", elementName="FrontTimeout", elementOrder=10, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="front-timeout", refType="", isEnumeration=false, javaName="frontTimeout", javaType="long", isRequired=true, squelchNull=false, minimum=1, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="120", displayOrder=0, displayValue="Front side timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getFrontTimeout() {
        return this.frontTimeout;
    }

    @XMLInfo(elementType="element", elementName="FrontTimeout", elementOrder=10, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="front-timeout", refType="", isEnumeration=false, javaName="frontTimeout", javaType="long", isRequired=true, squelchNull=false, minimum=1, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="120", displayValue="Front side timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFrontTimeout(long frontTimeout) {
        this.frontTimeout = frontTimeout;
    }

    @XMLInfo(elementType="element", elementName="FrontPersistentTimeout", elementOrder=11, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="front-persistent-timeout", refType="", isEnumeration=false, javaName="frontPersistentTimeout", javaType="long", isRequired=true, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="180", displayOrder=0, displayValue="Front persistent timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getFrontPersistentTimeout() {
        return this.frontPersistentTimeout;
    }

    @XMLInfo(elementType="element", elementName="FrontPersistentTimeout", elementOrder=11, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="front-persistent-timeout", refType="", isEnumeration=false, javaName="frontPersistentTimeout", javaType="long", isRequired=true, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="180", displayValue="Front persistent timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFrontPersistentTimeout(long frontPersistentTimeout) {
        this.frontPersistentTimeout = frontPersistentTimeout;
    }

    @XMLInfo(elementType="element", elementName="FrontHTTPVersion", elementOrder=12, dataPowerType="dmHTTPVersion", subType="", benign=false, isPassword=false, cliAlias="http-front-version", refType="", isEnumeration=true, javaName="frontHTTPVersion", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="HTTP/1.1", displayOrder=0, displayValue="HTTP version to client", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getFrontHTTPVersion() {
        return this.frontHTTPVersion;
    }

    @XMLInfo(elementType="element", elementName="FrontHTTPVersion", elementOrder=12, dataPowerType="dmHTTPVersion", subType="", benign=false, isPassword=false, cliAlias="http-front-version", refType="", isEnumeration=true, javaName="frontHTTPVersion", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="HTTP/1.1", displayValue="HTTP version to client", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFrontHTTPVersion(String frontHTTPVersion) {
        if (frontHTTPVersion == null || Comparison.isIn(frontHTTPVersion, DPEnumerations.HTTPVERSION)) {
            this.frontHTTPVersion = frontHTTPVersion;
        }
    }

    @XMLInfo(elementType="element", elementName="HTTPClientIPLabel", elementOrder=13, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="http-client-ip-label", refType="", isEnumeration=false, javaName="hTTPClientIPLabel", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="X-Client-IP", displayOrder=0, displayValue="HTTP client IP label", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getHTTPClientIPLabel() {
        return this.hTTPClientIPLabel;
    }

    @XMLInfo(elementType="element", elementName="HTTPClientIPLabel", elementOrder=13, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="http-client-ip-label", refType="", isEnumeration=false, javaName="hTTPClientIPLabel", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="X-Client-IP", displayValue="HTTP client IP label", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHTTPClientIPLabel(String hTTPClientIPLabel) {
        this.hTTPClientIPLabel = hTTPClientIPLabel;
    }

    @XMLInfo(elementType="element", elementName="HTTPLogCorIDLabel", elementOrder=14, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="http-global-tranID-label", refType="", isEnumeration=false, javaName="hTTPLogCorIDLabel", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="X-Global-Transaction-ID", displayOrder=0, displayValue="HTTP global transaction ID label", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getHTTPLogCorIDLabel() {
        return this.hTTPLogCorIDLabel;
    }

    @XMLInfo(elementType="element", elementName="HTTPLogCorIDLabel", elementOrder=14, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="http-global-tranID-label", refType="", isEnumeration=false, javaName="hTTPLogCorIDLabel", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="X-Global-Transaction-ID", displayValue="HTTP global transaction ID label", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHTTPLogCorIDLabel(String hTTPLogCorIDLabel) {
        this.hTTPLogCorIDLabel = hTTPLogCorIDLabel;
    }

    @XMLInfo(elementType="element", elementName="DebugMode", elementOrder=15, dataPowerType="dmDebugMode", subType="", benign=false, isPassword=false, cliAlias="debug-mode", refType="", isEnumeration=true, javaName="debugMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Probe setting", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDebugMode() {
        return this.debugMode;
    }

    @XMLInfo(elementType="element", elementName="DebugMode", elementOrder=15, dataPowerType="dmDebugMode", subType="", benign=false, isPassword=false, cliAlias="debug-mode", refType="", isEnumeration=true, javaName="debugMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Probe setting", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDebugMode(String debugMode) {
        if (debugMode == null || Comparison.isIn(debugMode, DPEnumerations.DEBUG_MODE)) {
            this.debugMode = debugMode;
        }
    }

    @XMLInfo(elementType="element", elementName="DebugHistory", elementOrder=16, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="debug-history", refType="", isEnumeration=false, javaName="debugHistory", javaType="long", isRequired=false, squelchNull=false, minimum=10, maximum=250L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="25", displayOrder=0, displayValue="Transaction history", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getDebugHistory() {
        return this.debugHistory;
    }

    @XMLInfo(elementType="element", elementName="DebugHistory", elementOrder=16, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="debug-history", refType="", isEnumeration=false, javaName="debugHistory", javaType="long", isRequired=false, squelchNull=false, minimum=10, maximum=250L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="25", displayValue="Transaction history", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDebugHistory(long debugHistory) {
        this.debugHistory = debugHistory;
    }

    @Override
    public int compareTo(ConfigWebTokenService that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "priority", "xMLManager", "requestType", "frontSide", "stylePolicy", "rewriteErrors", "delayErrors", "delayErrorsDuration", "frontTimeout", "frontPersistentTimeout", "frontHTTPVersion", "hTTPClientIPLabel", "hTTPLogCorIDLabel", "debugMode", "debugHistory");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.priority, this.xMLManager, this.requestType, this.frontSide, this.stylePolicy, this.rewriteErrors, this.delayErrors, this.delayErrorsDuration, this.frontTimeout, this.frontPersistentTimeout, this.frontHTTPVersion, this.hTTPClientIPLabel, this.hTTPLogCorIDLabel, this.debugMode, this.debugHistory);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "priority", "xMLManager", "requestType", "frontSide", "stylePolicy", "rewriteErrors", "delayErrors", "delayErrorsDuration", "frontTimeout", "frontPersistentTimeout", "frontHTTPVersion", "hTTPClientIPLabel", "hTTPLogCorIDLabel", "debugMode", "debugHistory");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "priority", "xMLManager", "requestType", "frontSide", "stylePolicy", "rewriteErrors", "delayErrors", "delayErrorsDuration", "frontTimeout", "frontPersistentTimeout", "frontHTTPVersion", "hTTPClientIPLabel", "hTTPLogCorIDLabel", "debugMode", "debugHistory"));
    }
}

