/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.modify;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.modify.ModifySourceProtocolHandler;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.SourceAS2FeatureType;
import java.util.Objects;

public class ModifyAS2ProxySourceProtocolHandler
extends ModifySourceProtocolHandler {
    private String userSummary;
    private String localAddress;
    private int localPort;
    private String hTTPVersion;
    private SourceAS2FeatureType allowedFeatures;
    private String persistentConnections;
    private long maxPersistentConnectionsReuse;
    private String allowCompression;
    private long maxURLLen;
    private long maxTotalHdrLen;
    private int maxHdrCount;
    private int maxNameHdrLen;
    private int maxValueHdrLen;
    private ObjectReference aCL;
    private String credentialCharset;
    private ObjectReference sSLProxy;
    private String remoteAddress;
    private int remotePort;
    private ObjectReference remoteSSLProxy;
    private long remoteConnectionTimeout;
    private ObjectReference xMLManager;
    private String enablePassthrough;
    private String enableVisibilityEvent;
    private String visibilityEventEndpoint;
    private String enableHmacAuthentication;
    private String hmacPassphrase;
    private ObjectReference hmacPassphraseAlias;
    private String sSLServerConfigType;
    private ObjectReference sSLServer;
    private ObjectReference sSLSNIServer;
    private String sSLClientConfigType;
    private ObjectReference sSLClient;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="LocalAddress", elementOrder=2, dataPowerType="dmLocalIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="localAddress", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLocalAddress() {
        return this.localAddress;
    }

    @XMLInfo(elementType="element", elementName="LocalAddress", elementOrder=2, dataPowerType="dmLocalIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="localAddress", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    @XMLInfo(elementType="element", elementName="LocalPort", elementOrder=3, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="localPort", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getLocalPort() {
        return this.localPort;
    }

    @XMLInfo(elementType="element", elementName="LocalPort", elementOrder=3, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="localPort", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    @XMLInfo(elementType="element", elementName="HTTPVersion", elementOrder=4, dataPowerType="dmHTTPVersion", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="hTTPVersion", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getHTTPVersion() {
        return this.hTTPVersion;
    }

    @XMLInfo(elementType="element", elementName="HTTPVersion", elementOrder=4, dataPowerType="dmHTTPVersion", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="hTTPVersion", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHTTPVersion(String hTTPVersion) {
        if (hTTPVersion == null || Comparison.isIn(hTTPVersion, DPEnumerations.HTTPVERSION)) {
            this.hTTPVersion = hTTPVersion;
        }
    }

    @XMLInfo(elementType="element", elementName="AllowedFeatures", elementOrder=5, dataPowerType="dmSourceAS2FeatureType", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="allowedFeatures", javaType="SourceAS2FeatureType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public SourceAS2FeatureType getAllowedFeatures() {
        return this.allowedFeatures;
    }

    @XMLInfo(elementType="element", elementName="AllowedFeatures", elementOrder=5, dataPowerType="dmSourceAS2FeatureType", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="allowedFeatures", javaType="SourceAS2FeatureType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAllowedFeatures(SourceAS2FeatureType allowedFeatures) {
        this.allowedFeatures = allowedFeatures;
    }

    @XMLInfo(elementType="element", elementName="PersistentConnections", elementOrder=6, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="persistentConnections", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getPersistentConnections() {
        return this.persistentConnections;
    }

    @XMLInfo(elementType="element", elementName="PersistentConnections", elementOrder=6, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="persistentConnections", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPersistentConnections(String persistentConnections) {
        if (persistentConnections == null || Comparison.isIn(persistentConnections, DPEnumerations.TOGGLE)) {
            this.persistentConnections = persistentConnections;
        }
    }

    @XMLInfo(elementType="element", elementName="MaxPersistentConnectionsReuse", elementOrder=7, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="maxPersistentConnectionsReuse", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMaxPersistentConnectionsReuse() {
        return this.maxPersistentConnectionsReuse;
    }

    @XMLInfo(elementType="element", elementName="MaxPersistentConnectionsReuse", elementOrder=7, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="maxPersistentConnectionsReuse", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxPersistentConnectionsReuse(long maxPersistentConnectionsReuse) {
        this.maxPersistentConnectionsReuse = maxPersistentConnectionsReuse;
    }

    @XMLInfo(elementType="element", elementName="AllowCompression", elementOrder=8, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="allowCompression", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAllowCompression() {
        return this.allowCompression;
    }

    @XMLInfo(elementType="element", elementName="AllowCompression", elementOrder=8, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="allowCompression", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAllowCompression(String allowCompression) {
        if (allowCompression == null || Comparison.isIn(allowCompression, DPEnumerations.TOGGLE)) {
            this.allowCompression = allowCompression;
        }
    }

    @XMLInfo(elementType="element", elementName="MaxURLLen", elementOrder=9, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="maxURLLen", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMaxURLLen() {
        return this.maxURLLen;
    }

    @XMLInfo(elementType="element", elementName="MaxURLLen", elementOrder=9, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="maxURLLen", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxURLLen(long maxURLLen) {
        this.maxURLLen = maxURLLen;
    }

    @XMLInfo(elementType="element", elementName="MaxTotalHdrLen", elementOrder=10, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="maxTotalHdrLen", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMaxTotalHdrLen() {
        return this.maxTotalHdrLen;
    }

    @XMLInfo(elementType="element", elementName="MaxTotalHdrLen", elementOrder=10, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="maxTotalHdrLen", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxTotalHdrLen(long maxTotalHdrLen) {
        this.maxTotalHdrLen = maxTotalHdrLen;
    }

    @XMLInfo(elementType="element", elementName="MaxHdrCount", elementOrder=11, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="maxHdrCount", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getMaxHdrCount() {
        return this.maxHdrCount;
    }

    @XMLInfo(elementType="element", elementName="MaxHdrCount", elementOrder=11, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="maxHdrCount", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxHdrCount(int maxHdrCount) {
        this.maxHdrCount = maxHdrCount;
    }

    @XMLInfo(elementType="element", elementName="MaxNameHdrLen", elementOrder=12, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="maxNameHdrLen", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getMaxNameHdrLen() {
        return this.maxNameHdrLen;
    }

    @XMLInfo(elementType="element", elementName="MaxNameHdrLen", elementOrder=12, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="maxNameHdrLen", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxNameHdrLen(int maxNameHdrLen) {
        this.maxNameHdrLen = maxNameHdrLen;
    }

    @XMLInfo(elementType="element", elementName="MaxValueHdrLen", elementOrder=13, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="maxValueHdrLen", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getMaxValueHdrLen() {
        return this.maxValueHdrLen;
    }

    @XMLInfo(elementType="element", elementName="MaxValueHdrLen", elementOrder=13, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="maxValueHdrLen", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxValueHdrLen(int maxValueHdrLen) {
        this.maxValueHdrLen = maxValueHdrLen;
    }

    @XMLInfo(elementType="element", elementName="ACL", elementOrder=14, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="aCL", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference getACL() {
        return this.aCL;
    }

    @XMLInfo(elementType="element", elementName="ACL", elementOrder=14, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="aCL", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setACL(ObjectReference aCL) {
        this.aCL = aCL;
    }

    @XMLInfo(elementType="element", elementName="CredentialCharset", elementOrder=15, dataPowerType="dmCredentialCharset", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="credentialCharset", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getCredentialCharset() {
        return this.credentialCharset;
    }

    @XMLInfo(elementType="element", elementName="CredentialCharset", elementOrder=15, dataPowerType="dmCredentialCharset", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="credentialCharset", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCredentialCharset(String credentialCharset) {
        if (credentialCharset == null || Comparison.isIn(credentialCharset, DPEnumerations.CREDENTIAL_CHARSET)) {
            this.credentialCharset = credentialCharset;
        }
    }

    @XMLInfo(elementType="element", elementName="SSLProxy", elementOrder=16, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="sSLProxy", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference getSSLProxy() {
        return this.sSLProxy;
    }

    @XMLInfo(elementType="element", elementName="SSLProxy", elementOrder=16, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="sSLProxy", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLProxy(ObjectReference sSLProxy) {
        this.sSLProxy = sSLProxy;
    }

    @XMLInfo(elementType="element", elementName="RemoteAddress", elementOrder=17, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="remoteAddress", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @XMLInfo(elementType="element", elementName="RemoteAddress", elementOrder=17, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="remoteAddress", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @XMLInfo(elementType="element", elementName="RemotePort", elementOrder=18, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="remotePort", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getRemotePort() {
        return this.remotePort;
    }

    @XMLInfo(elementType="element", elementName="RemotePort", elementOrder=18, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="remotePort", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    @XMLInfo(elementType="element", elementName="RemoteSSLProxy", elementOrder=19, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="remoteSSLProxy", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference getRemoteSSLProxy() {
        return this.remoteSSLProxy;
    }

    @XMLInfo(elementType="element", elementName="RemoteSSLProxy", elementOrder=19, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="remoteSSLProxy", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRemoteSSLProxy(ObjectReference remoteSSLProxy) {
        this.remoteSSLProxy = remoteSSLProxy;
    }

    @XMLInfo(elementType="element", elementName="RemoteConnectionTimeout", elementOrder=20, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="remoteConnectionTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getRemoteConnectionTimeout() {
        return this.remoteConnectionTimeout;
    }

    @XMLInfo(elementType="element", elementName="RemoteConnectionTimeout", elementOrder=20, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="remoteConnectionTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRemoteConnectionTimeout(long remoteConnectionTimeout) {
        this.remoteConnectionTimeout = remoteConnectionTimeout;
    }

    @XMLInfo(elementType="element", elementName="XMLManager", elementOrder=21, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="xMLManager", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference getXMLManager() {
        return this.xMLManager;
    }

    @XMLInfo(elementType="element", elementName="XMLManager", elementOrder=21, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="xMLManager", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setXMLManager(ObjectReference xMLManager) {
        this.xMLManager = xMLManager;
    }

    @XMLInfo(elementType="element", elementName="EnablePassthrough", elementOrder=22, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="enablePassthrough", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEnablePassthrough() {
        return this.enablePassthrough;
    }

    @XMLInfo(elementType="element", elementName="EnablePassthrough", elementOrder=22, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="enablePassthrough", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEnablePassthrough(String enablePassthrough) {
        if (enablePassthrough == null || Comparison.isIn(enablePassthrough, DPEnumerations.TOGGLE)) {
            this.enablePassthrough = enablePassthrough;
        }
    }

    @XMLInfo(elementType="element", elementName="EnableVisibilityEvent", elementOrder=23, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="enableVisibilityEvent", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEnableVisibilityEvent() {
        return this.enableVisibilityEvent;
    }

    @XMLInfo(elementType="element", elementName="EnableVisibilityEvent", elementOrder=23, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="enableVisibilityEvent", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEnableVisibilityEvent(String enableVisibilityEvent) {
        if (enableVisibilityEvent == null || Comparison.isIn(enableVisibilityEvent, DPEnumerations.TOGGLE)) {
            this.enableVisibilityEvent = enableVisibilityEvent;
        }
    }

    @XMLInfo(elementType="element", elementName="VisibilityEventEndpoint", elementOrder=24, dataPowerType="dmURL", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="visibilityEventEndpoint", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getVisibilityEventEndpoint() {
        return this.visibilityEventEndpoint;
    }

    @XMLInfo(elementType="element", elementName="VisibilityEventEndpoint", elementOrder=24, dataPowerType="dmURL", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="visibilityEventEndpoint", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setVisibilityEventEndpoint(String visibilityEventEndpoint) {
        this.visibilityEventEndpoint = visibilityEventEndpoint;
    }

    @XMLInfo(elementType="element", elementName="EnableHmacAuthentication", elementOrder=25, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="enableHmacAuthentication", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEnableHmacAuthentication() {
        return this.enableHmacAuthentication;
    }

    @XMLInfo(elementType="element", elementName="EnableHmacAuthentication", elementOrder=25, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="enableHmacAuthentication", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEnableHmacAuthentication(String enableHmacAuthentication) {
        if (enableHmacAuthentication == null || Comparison.isIn(enableHmacAuthentication, DPEnumerations.TOGGLE)) {
            this.enableHmacAuthentication = enableHmacAuthentication;
        }
    }

    @XMLInfo(elementType="element", elementName="HmacPassphrase", elementOrder=26, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="hmacPassphrase", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getHmacPassphrase() {
        return this.hmacPassphrase;
    }

    @XMLInfo(elementType="element", elementName="HmacPassphrase", elementOrder=26, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="hmacPassphrase", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHmacPassphrase(String hmacPassphrase) {
        this.hmacPassphrase = hmacPassphrase;
    }

    @XMLInfo(elementType="element", elementName="HmacPassphraseAlias", elementOrder=27, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="hmacPassphraseAlias", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference getHmacPassphraseAlias() {
        return this.hmacPassphraseAlias;
    }

    @XMLInfo(elementType="element", elementName="HmacPassphraseAlias", elementOrder=27, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="hmacPassphraseAlias", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHmacPassphraseAlias(ObjectReference hmacPassphraseAlias) {
        this.hmacPassphraseAlias = hmacPassphraseAlias;
    }

    @XMLInfo(elementType="element", elementName="SSLServerConfigType", elementOrder=28, dataPowerType="dmSSLConfigType", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="sSLServerConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSSLServerConfigType() {
        return this.sSLServerConfigType;
    }

    @XMLInfo(elementType="element", elementName="SSLServerConfigType", elementOrder=28, dataPowerType="dmSSLConfigType", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="sSLServerConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLServerConfigType(String sSLServerConfigType) {
        if (sSLServerConfigType == null || Comparison.isIn(sSLServerConfigType, DPEnumerations.SSLCONFIG_TYPE)) {
            this.sSLServerConfigType = sSLServerConfigType;
        }
    }

    @XMLInfo(elementType="element", elementName="SSLServer", elementOrder=29, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="sSLServer", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference getSSLServer() {
        return this.sSLServer;
    }

    @XMLInfo(elementType="element", elementName="SSLServer", elementOrder=29, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="sSLServer", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLServer(ObjectReference sSLServer) {
        this.sSLServer = sSLServer;
    }

    @XMLInfo(elementType="element", elementName="SSLSNIServer", elementOrder=30, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="sSLSNIServer", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference getSSLSNIServer() {
        return this.sSLSNIServer;
    }

    @XMLInfo(elementType="element", elementName="SSLSNIServer", elementOrder=30, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="sSLSNIServer", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLSNIServer(ObjectReference sSLSNIServer) {
        this.sSLSNIServer = sSLSNIServer;
    }

    @XMLInfo(elementType="element", elementName="SSLClientConfigType", elementOrder=31, dataPowerType="dmSSLClientConfigType", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="sSLClientConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSSLClientConfigType() {
        return this.sSLClientConfigType;
    }

    @XMLInfo(elementType="element", elementName="SSLClientConfigType", elementOrder=31, dataPowerType="dmSSLClientConfigType", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="sSLClientConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLClientConfigType(String sSLClientConfigType) {
        if (sSLClientConfigType == null || Comparison.isIn(sSLClientConfigType, DPEnumerations.SSLCLIENT_CONFIG_TYPE)) {
            this.sSLClientConfigType = sSLClientConfigType;
        }
    }

    @XMLInfo(elementType="element", elementName="SSLClient", elementOrder=32, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="sSLClient", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference getSSLClient() {
        return this.sSLClient;
    }

    @XMLInfo(elementType="element", elementName="SSLClient", elementOrder=32, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="sSLClient", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLClient(ObjectReference sSLClient) {
        this.sSLClient = sSLClient;
    }

    @Override
    public int compareTo(ModifyAS2ProxySourceProtocolHandler that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "localAddress", "localPort", "hTTPVersion", "allowedFeatures", "persistentConnections", "maxPersistentConnectionsReuse", "allowCompression", "maxURLLen", "maxTotalHdrLen", "maxHdrCount", "maxNameHdrLen", "maxValueHdrLen", "aCL", "credentialCharset", "sSLProxy", "remoteAddress", "remotePort", "remoteSSLProxy", "remoteConnectionTimeout", "xMLManager", "enablePassthrough", "enableVisibilityEvent", "visibilityEventEndpoint", "enableHmacAuthentication", "hmacPassphrase", "hmacPassphraseAlias", "sSLServerConfigType", "sSLServer", "sSLSNIServer", "sSLClientConfigType", "sSLClient");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.localAddress, this.localPort, this.hTTPVersion, this.allowedFeatures, this.persistentConnections, this.maxPersistentConnectionsReuse, this.allowCompression, this.maxURLLen, this.maxTotalHdrLen, this.maxHdrCount, this.maxNameHdrLen, this.maxValueHdrLen, this.aCL, this.credentialCharset, this.sSLProxy, this.remoteAddress, this.remotePort, this.remoteSSLProxy, this.remoteConnectionTimeout, this.xMLManager, this.enablePassthrough, this.enableVisibilityEvent, this.visibilityEventEndpoint, this.enableHmacAuthentication, this.hmacPassphrase, this.hmacPassphraseAlias, this.sSLServerConfigType, this.sSLServer, this.sSLSNIServer, this.sSLClientConfigType, this.sSLClient);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "localAddress", "localPort", "hTTPVersion", "allowedFeatures", "persistentConnections", "maxPersistentConnectionsReuse", "allowCompression", "maxURLLen", "maxTotalHdrLen", "maxHdrCount", "maxNameHdrLen", "maxValueHdrLen", "aCL", "credentialCharset", "sSLProxy", "remoteAddress", "remotePort", "remoteSSLProxy", "remoteConnectionTimeout", "xMLManager", "enablePassthrough", "enableVisibilityEvent", "visibilityEventEndpoint", "enableHmacAuthentication", "hmacPassphrase", "hmacPassphraseAlias", "sSLServerConfigType", "sSLServer", "sSLSNIServer", "sSLClientConfigType", "sSLClient");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "localAddress", "localPort", "hTTPVersion", "allowedFeatures", "persistentConnections", "maxPersistentConnectionsReuse", "allowCompression", "maxURLLen", "maxTotalHdrLen", "maxHdrCount", "maxNameHdrLen", "maxValueHdrLen", "aCL", "credentialCharset", "sSLProxy", "remoteAddress", "remotePort", "remoteSSLProxy", "remoteConnectionTimeout", "xMLManager", "enablePassthrough", "enableVisibilityEvent", "visibilityEventEndpoint", "enableHmacAuthentication", "hmacPassphrase", "hmacPassphraseAlias", "sSLServerConfigType", "sSLServer", "sSLSNIServer", "sSLClientConfigType", "sSLClient"));
    }
}

