/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.modify;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.modify.ModifyCrypto;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.JOSEHeader;
import java.util.ArrayList;
import java.util.Objects;

public class ModifyJWERecipient
extends ModifyCrypto {
    private String userSummary;
    private String algorithm;
    private ObjectReference sSKey;
    private ObjectReference certificate;
    private ArrayList<JOSEHeader> unprotectedHeader;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="Algorithm", elementOrder=2, dataPowerType="dmJWEKeyAlgorithm", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="algorithm", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAlgorithm() {
        return this.algorithm;
    }

    @XMLInfo(elementType="element", elementName="Algorithm", elementOrder=2, dataPowerType="dmJWEKeyAlgorithm", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="algorithm", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAlgorithm(String algorithm) {
        if (algorithm == null || Comparison.isIn(algorithm, DPEnumerations.JWEKEY_ALGORITHM)) {
            this.algorithm = algorithm;
        }
    }

    @XMLInfo(elementType="element", elementName="SSKey", elementOrder=3, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="sSKey", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference getSSKey() {
        return this.sSKey;
    }

    @XMLInfo(elementType="element", elementName="SSKey", elementOrder=3, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="sSKey", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSKey(ObjectReference sSKey) {
        this.sSKey = sSKey;
    }

    @XMLInfo(elementType="element", elementName="Certificate", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="certificate", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference getCertificate() {
        return this.certificate;
    }

    @XMLInfo(elementType="element", elementName="Certificate", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="certificate", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCertificate(ObjectReference certificate) {
        this.certificate = certificate;
    }

    public void addUnprotectedHeader(JOSEHeader element) {
        if (element == null) {
            return;
        }
        if (this.unprotectedHeader == null) {
            this.unprotectedHeader = new ArrayList();
        }
        this.unprotectedHeader.add(element);
    }

    public boolean removeUnprotectedHeader(JOSEHeader element) {
        if (element == null || this.unprotectedHeader == null) {
            return false;
        }
        return this.unprotectedHeader.remove(element);
    }

    @XMLInfo(elementType="element", elementName="UnprotectedHeader", elementOrder=5, dataPowerType="dmJOSEHeader", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="unprotectedHeader", javaType="JOSEHeader", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<JOSEHeader> getUnprotectedHeader() {
        return this.unprotectedHeader;
    }

    @XMLInfo(elementType="element", elementName="UnprotectedHeader", elementOrder=5, dataPowerType="dmJOSEHeader", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="unprotectedHeader", javaType="JOSEHeader", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUnprotectedHeader(ArrayList<JOSEHeader> unprotectedHeader) {
        this.unprotectedHeader = unprotectedHeader;
    }

    @Override
    public int compareTo(ModifyJWERecipient that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "algorithm", "sSKey", "certificate", "unprotectedHeader");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.algorithm, this.sSKey, this.certificate, this.unprotectedHeader);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "algorithm", "sSKey", "certificate", "unprotectedHeader");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "algorithm", "sSKey", "certificate", "unprotectedHeader"));
    }
}

