/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.probe;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.io.FileOutputStreamHelper;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.tools.AbstractTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ProbeCaptureProcessor
extends AbstractTool {
    private File probeCaptureFile;
    private AsynchMethodInvoker<Boolean> processThread;
    private String outputDirectoryName;
    private File outputBaseDirectory;

    public ProbeCaptureProcessor(File probeCaptureFile) {
        this.setProbeCaptureFile(probeCaptureFile);
        AbstractTool.logger.finer(() -> LMG.log("(probeCaptureFile=%s).  Starting thread to read as zip file.", () -> probeCaptureFile.getAbsolutePath()));
        this.processThread = new AsynchMethodInvoker((Object)this, "readAsZipFile", (Object)probeCaptureFile);
    }

    public File getProbeCaptureFile() {
        return this.probeCaptureFile;
    }

    public void setProbeCaptureFile(File probeCaptureFile) {
        this.probeCaptureFile = probeCaptureFile;
        String fileName = probeCaptureFile.getAbsolutePath();
        this.outputDirectoryName = StringUtility.substringBefore(fileName, ".zip");
        this.outputBaseDirectory = new File(this.outputDirectoryName);
        AbstractTool.logger.finer(() -> LMG.log("(probeCaptureFile=%s).  Processing file to %s.", () -> fileName, () -> this.outputBaseDirectory.getAbsolutePath()));
    }

    public String getOutputDirectoryName() {
        return this.outputDirectoryName;
    }

    public void setOutputDirectoryName(String outputDirectoryName) {
        this.outputDirectoryName = outputDirectoryName;
    }

    public File getOutputBaseDirectory() {
        return this.outputBaseDirectory;
    }

    public AsynchMethodInvoker<Boolean> getProcessThread() {
        return this.processThread;
    }

    @Reflected
    private boolean readAsZipFile(File file) {
        ArrayList<File> nestedGZFiles;
        ArrayList<File> nestedZipFiles;
        String loggerPrefix;
        block30: {
            ZipFile zipFile;
            block29: {
                loggerPrefix = String.format("(zipFile=%s)", file.getName());
                AbstractTool.logger.finer(() -> LMG.log("(%s): Starting", () -> loggerPrefix));
                nestedZipFiles = new ArrayList<File>();
                nestedGZFiles = new ArrayList<File>();
                String fileName = file.getAbsolutePath();
                String localOutputDirectoryName = StringUtility.substringBefore(fileName, ".zip");
                File localOutputBaseDirectory = new File(localOutputDirectoryName);
                if (!localOutputBaseDirectory.exists()) {
                    localOutputBaseDirectory.mkdirs();
                }
                zipFile = null;
                try {
                    zipFile = new ZipFile(fileName);
                    AbstractTool.logger.finer(() -> LMG.log("(%s): Zip File Opened Successfully.", () -> loggerPrefix));
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        int readLength;
                        ZipEntry zipEntry = entries.nextElement();
                        String compressedFileName = zipEntry.getName();
                        if (compressedFileName.startsWith("dp-aux/") || compressedFileName.startsWith("webgui/")) {
                            AbstractTool.logger.finer(() -> LMG.log("(%s): Skipping '%s'.", () -> loggerPrefix, () -> compressedFileName));
                            continue;
                        }
                        long size = zipEntry.getSize();
                        long compressedSize = zipEntry.getCompressedSize();
                        AbstractTool.logger.finer(() -> LMG.log("%s: Found %d byte entry named '%s'.  Compressed size is %d", () -> loggerPrefix, () -> size, () -> compressedFileName, () -> compressedSize));
                        if (zipEntry.isDirectory()) {
                            AbstractTool.logger.finer(() -> LMG.log("%s:  Creating directory '%s'", () -> loggerPrefix, () -> compressedFileName));
                            File subDir = new File(localOutputBaseDirectory, compressedFileName);
                            if (subDir.exists()) continue;
                            subDir.mkdirs();
                            continue;
                        }
                        File outputFile = new File(localOutputBaseDirectory, compressedFileName);
                        String outputFileName = outputFile.getAbsolutePath();
                        AbstractTool.logger.finer(() -> LMG.log("%s:  Uncompressing to '%s'", () -> loggerPrefix, () -> outputFileName));
                        InputStream in = zipFile.getInputStream(zipEntry);
                        FileOutputStreamHelper foh = new FileOutputStreamHelper(outputFile);
                        OutputStream out = foh.open();
                        if (out == null) {
                            AbstractTool.logger.warning(() -> LMG.log("%s:  Could not open '%s'", () -> loggerPrefix, () -> outputFileName));
                            continue;
                        }
                        byte[] readBuffer = new byte[8192];
                        while ((readLength = in.read(readBuffer)) >= 0) {
                            out.write(readBuffer, 0, readLength);
                        }
                        foh.close();
                        AbstractTool.logger.finer(() -> LMG.log("%s:  '%s' created successfully.", () -> loggerPrefix, () -> outputFileName));
                        if (outputFileName.endsWith(".zip")) {
                            nestedZipFiles.add(outputFile);
                            continue;
                        }
                        if (!outputFileName.endsWith(".gz")) continue;
                        nestedGZFiles.add(outputFile);
                    }
                }
                catch (NoSuchFileException e) {
                    AbstractTool.logger.warning(() -> LMG.log("%s:  No such file.", () -> loggerPrefix));
                    if (zipFile == null) {
                        AbstractTool.logger.warning(() -> LMG.log("%s:  Zip file reference is null.  Cannot close.", () -> loggerPrefix));
                    } else {
                        try {
                            zipFile.close();
                        }
                        catch (IOException e2) {
                            AbstractTool.logger.info(() -> LMG.log("%s:  Error closing zip file", () -> loggerPrefix));
                            e2.printStackTrace();
                        }
                    }
                    return false;
                }
                catch (IOException e) {
                    block28: {
                        try {
                            AbstractTool.logger.severe(() -> LMG.log("%s:  Failed to successfully process zip file.", () -> loggerPrefix));
                            e.printStackTrace();
                            if (zipFile != null) break block28;
                            AbstractTool.logger.warning(() -> LMG.log("%s:  Zip file reference is null.  Cannot close.", () -> loggerPrefix));
                        }
                        catch (Throwable throwable) {
                            if (zipFile == null) {
                                AbstractTool.logger.warning(() -> LMG.log("%s:  Zip file reference is null.  Cannot close.", () -> loggerPrefix));
                            } else {
                                try {
                                    zipFile.close();
                                }
                                catch (IOException e3) {
                                    AbstractTool.logger.info(() -> LMG.log("%s:  Error closing zip file", () -> loggerPrefix));
                                    e3.printStackTrace();
                                }
                            }
                            throw throwable;
                        }
                    }
                    try {
                        zipFile.close();
                    }
                    catch (IOException e4) {
                        AbstractTool.logger.info(() -> LMG.log("%s:  Error closing zip file", () -> loggerPrefix));
                        e4.printStackTrace();
                    }
                    return false;
                }
                if (zipFile != null) break block29;
                AbstractTool.logger.warning(() -> LMG.log("%s:  Zip file reference is null.  Cannot close.", () -> loggerPrefix));
                break block30;
            }
            try {
                zipFile.close();
            }
            catch (IOException e) {
                AbstractTool.logger.info(() -> LMG.log("%s:  Error closing zip file", () -> loggerPrefix));
                e.printStackTrace();
            }
        }
        for (File nestedZipFile : nestedZipFiles) {
            AbstractTool.logger.finer(() -> LMG.log("%s:  Reading nested ZIP file '%s'.", () -> loggerPrefix, () -> nestedZipFile.getAbsolutePath()));
            if (this.readAsZipFile(nestedZipFile)) continue;
            return false;
        }
        for (File nestedGZFile : nestedGZFiles) {
            AbstractTool.logger.finer(() -> LMG.log("%s:  Reading nested GZIP file '%s'.", () -> loggerPrefix, () -> nestedGZFile.getAbsolutePath()));
            if (ProbeCaptureProcessor.readAsGZFile(nestedGZFile)) continue;
            return false;
        }
        AbstractTool.logger.finer(() -> LMG.log("(%s): Done.  Returning true.", () -> loggerPrefix));
        return true;
    }

    private static boolean readAsGZFile(File gzippedFile) {
        String loggerPrefix = String.format("(gzippedFile=%s)", gzippedFile.getName());
        AbstractTool.logger.finer(() -> LMG.log("%s:  Starting", () -> loggerPrefix));
        String fileName = gzippedFile.getAbsolutePath();
        try {
            int readLength;
            GZIPInputStream in = new GZIPInputStream(new FileInputStream(fileName));
            String unzippedFileName = StringUtility.substringBefore(fileName, ".gz");
            AbstractTool.logger.finer(() -> LMG.log("%s:  Uncompressing '%s' to '%s'", () -> loggerPrefix, () -> fileName, () -> unzippedFileName));
            FileOutputStreamHelper fout = new FileOutputStreamHelper(unzippedFileName);
            OutputStream out = fout.open();
            byte[] readBuffer = new byte[8192];
            while ((readLength = in.read(readBuffer)) >= 0) {
                out.write(readBuffer, 0, readLength);
            }
            in.close();
            fout.close();
            AbstractTool.logger.finer(() -> LMG.log("%s: '%s' created successfully.", () -> loggerPrefix, () -> unzippedFileName));
        }
        catch (IOException e) {
            AbstractTool.logger.severe(() -> LMG.log("%s: Failed to successfully process gzipped file '%s' due to %s.", () -> loggerPrefix, () -> fileName, () -> e.getMessage()));
            return false;
        }
        AbstractTool.logger.finer(() -> LMG.log("%s:  Done", () -> loggerPrefix));
        return true;
    }
}

