/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.types;

import com.jmorgan.beans.JMBean;
import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class SnmpTarget
extends JMBean
implements Comparable<SnmpTarget> {
    private String host;
    private int port;
    private String community;
    private String trapVersion;
    private String securityName;
    private String securityLevel;

    @XMLInfo(elementType="element", elementName="Host", elementOrder=0, dataPowerType="dmIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="host", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Remote Host Address", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getHost() {
        return this.host;
    }

    @XMLInfo(elementType="element", elementName="Host", elementOrder=0, dataPowerType="dmIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="host", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Remote Host Address", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHost(String host) {
        this.host = host;
    }

    @XMLInfo(elementType="element", elementName="Port", elementOrder=1, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="port", javaType="int", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="162", displayOrder=0, displayValue="Remote Port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getPort() {
        return this.port;
    }

    @XMLInfo(elementType="element", elementName="Port", elementOrder=1, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="port", javaType="int", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="162", displayValue="Remote Port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPort(int port) {
        this.port = port;
    }

    @XMLInfo(elementType="element", elementName="Community", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="community", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=255, validationRegex="", allowedValues={}, defaultValue="public", displayOrder=0, displayValue="Community", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getCommunity() {
        return this.community;
    }

    @XMLInfo(elementType="element", elementName="Community", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="community", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=255, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="public", displayValue="Community", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCommunity(String community) {
        this.community = community;
    }

    @XMLInfo(elementType="element", elementName="TrapVersion", elementOrder=3, dataPowerType="dmSnmpVersion", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="trapVersion", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="1", displayOrder=0, displayValue="Version", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getTrapVersion() {
        return this.trapVersion;
    }

    @XMLInfo(elementType="element", elementName="TrapVersion", elementOrder=3, dataPowerType="dmSnmpVersion", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="trapVersion", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="1", displayValue="Version", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTrapVersion(String trapVersion) {
        if (Comparison.isIn(trapVersion, DPEnumerations.SNMP_VERSION)) {
            this.trapVersion = trapVersion;
        }
    }

    @XMLInfo(elementType="element", elementName="SecurityName", elementOrder=4, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="securityName", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=32, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Security Name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSecurityName() {
        return this.securityName;
    }

    @XMLInfo(elementType="element", elementName="SecurityName", elementOrder=4, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="securityName", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=32, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Security Name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSecurityName(String securityName) {
        this.securityName = securityName;
    }

    @XMLInfo(elementType="element", elementName="SecurityLevel", elementOrder=5, dataPowerType="dmSnmpSecurityLevel", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="securityLevel", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="authPriv", displayOrder=0, displayValue="Security Level", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSecurityLevel() {
        return this.securityLevel;
    }

    @XMLInfo(elementType="element", elementName="SecurityLevel", elementOrder=5, dataPowerType="dmSnmpSecurityLevel", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="securityLevel", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="authPriv", displayValue="Security Level", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSecurityLevel(String securityLevel) {
        if (Comparison.isIn(securityLevel, DPEnumerations.SNMP_SECURITY_LEVEL)) {
            this.securityLevel = securityLevel;
        }
    }

    @Override
    public int compareTo(SnmpTarget that) {
        return this.compareTo(that, "host", "port", "community", "trapVersion", "securityName", "securityLevel");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.host, this.port, this.community, this.trapVersion, this.securityName, this.securityLevel);
    }

    public boolean equals(Object that) {
        return this.equals(that, "host", "port", "community", "trapVersion", "securityName", "securityLevel");
    }

    @Override
    public String toString() {
        return this.toString("host", "port", "community", "trapVersion", "securityName", "securityLevel");
    }
}

