/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.tools.DataPowerXMLManagement;
import com.kumbasoft.core.util.FileUtility;
import java.io.IOException;
import java.util.ArrayList;

abstract class AbstractAPIManagementTool
extends DataPowerXMLManagement {
    private String apiManagementRequest;
    private String actionDescription;
    private AsynchMethodInvoker<Void> processThread;
    protected String apiManagementRequestTemplateFile;

    public AbstractAPIManagementTool(Appliance appliance, Domain domain, String actionDescription, String apiManagementRequest) {
        super(appliance, domain);
        this.setApiManagementRequest(apiManagementRequest);
        this.setActionDescription(actionDescription);
        this.processThread = new AsynchMethodInvoker((Object)this, "processAction", 500);
    }

    public String getActionDescription() {
        return this.actionDescription;
    }

    public void setActionDescription(String actionDescription) {
        this.actionDescription = actionDescription;
    }

    public AsynchMethodInvoker<Void> getProcessThread() {
        return this.processThread;
    }

    protected void processAction() {
        try {
            XMLElement rootElement = this.runRequest();
            if (rootElement == null) {
                return;
            }
            Application.getApplication().getApplicationLogger().fine(String.format("AbstractAPIManagementTool.processAction():  ResponseXML\n%s\n", this.getResponseXML()));
            ArrayList statusElements = (ArrayList)rootElement.getNodes("//amp:Status");
            for (XMLElement statusElement : statusElements) {
                String nodeValue = statusElement.getValue().trim();
                if (nodeValue.length() <= 0) continue;
                if (nodeValue.toUpperCase().equals("OK")) {
                    ManagementCommandStatus commandStatus = new ManagementCommandStatus(this.getAppliance(), this.getDomain(), this.actionDescription, this, "OK");
                    this.notifyManagementCommandSubscribers(commandStatus);
                    continue;
                }
                ManagementCommandError commandError = new ManagementCommandError(this.getAppliance(), this.getDomain(), this.actionDescription, this, nodeValue);
                this.notifyManagementCommandSubscribers(commandError);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getApiManagementRequest() {
        return this.apiManagementRequest;
    }

    public void setApiManagementRequest(String apiManagementRequest) {
        this.apiManagementRequest = apiManagementRequest;
        this.apiManagementRequestTemplateFile = String.format("%s/%s.xml", applicationProperties.getSomaTemplatesDirectory(), apiManagementRequest);
    }

    @Override
    protected String getRequestMessage() {
        String somaFile = null;
        try {
            somaFile = FileUtility.readFile(this.apiManagementRequestTemplateFile);
            String propertyName = StringUtility.getMarkupContent(somaFile, "${", "}");
            String strValue = "";
            while (propertyName != null) {
                Object value = BeanService.getPropertyValue(this, propertyName);
                if (value != null) {
                    if (value instanceof String) {
                        strValue = (String)value;
                    } else {
                        value = value.toString();
                    }
                }
                String somaMarkup = String.format("${%s}", propertyName);
                somaFile = somaFile.replace(somaMarkup, strValue);
                propertyName = StringUtility.getMarkupContent(somaFile, "${", "}");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Application.getApplication().getApplicationLogger().fine(String.format("AbstractAPIManagementTool.getRequestMessage():  Resulting SOMA file\n%s\n", somaFile));
        return somaFile;
    }
}

