/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.tools.AbstractDataPowerManagementRequest;
import java.util.ArrayList;

public abstract class AbstractFileManagementRequest
extends AbstractDataPowerManagementRequest {
    protected ArrayList<DataPowerFileInfo> dataPowerFiles;

    protected AbstractFileManagementRequest() {
    }

    protected AbstractFileManagementRequest(ArrayList<DataPowerFileInfo> dataPowerFiles) {
        this.setDataPowerFiles(dataPowerFiles);
    }

    protected AbstractFileManagementRequest(DataPowerFileInfo dataPowerFileInfo, String commandDescription) {
        this(dataPowerFileInfo, commandDescription, false);
    }

    protected AbstractFileManagementRequest(DataPowerFileInfo dataPowerFileInfo, String commandDescription, boolean runSynchronously) {
        super(dataPowerFileInfo.getAppliance(), dataPowerFileInfo.getSourceDomain(), commandDescription, runSynchronously);
        ArrayList<DataPowerFileInfo> dataPowerFiles = new ArrayList<DataPowerFileInfo>();
        dataPowerFiles.add(dataPowerFileInfo);
        this.setDataPowerFiles(dataPowerFiles);
    }

    public ArrayList<DataPowerFileInfo> getDataPowerFiles() {
        return this.dataPowerFiles;
    }

    public void setDataPowerFiles(ArrayList<DataPowerFileInfo> dataPowerFiles) {
        logger.finer("(datapowerFiles): Starting");
        this.dataPowerFiles = dataPowerFiles;
        Appliance appliance = dataPowerFiles.get(0).getAppliance();
        this.setAppliance(appliance);
        ArrayList<Domain> domains = appliance.getDomains();
        if (CollectionUtility.isEmpty(domains)) {
            logger.warning(() -> LMG.log("(dataPowerFiles): Domains for Appliance: %s is empty!", () -> appliance.getName()));
            appliance.addDomain(new Domain("default"));
        }
        Domain domain = appliance.getDomain("default");
        logger.finer(() -> LMG.log("(dataPowerFiles): Appliance: %s, Domain: %s", () -> appliance.getName(), () -> domain.getName()));
        this.setDomain(domain);
        logger.finer("(datapowerFiles): done");
    }

    public String getFQFN(DataPowerFileInfo dataPowerFile) {
        String FQON;
        String FQFN = FQON = dataPowerFile.getAbsolutePath();
        String domainName = dataPowerFile.getSourceDomain().getName();
        if (!domainName.equals("default")) {
            int firstSlash = FQON.indexOf("/") + 1;
            FQFN = StringUtility.insertInto(domainName + "/", FQFN, firstSlash);
        }
        return FQFN;
    }
}

