/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.io.ASCFileWriter;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.InvocationEvent;
import com.jmorgan.lang.InvocationListener;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.tools.DataPowerXMLManagement;
import com.kumbasoft.core.util.FileUtility;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;

public abstract class AbstractListFiles
extends DataPowerXMLManagement
implements InvocationListener {
    protected static String getFileStoreTemplate;
    protected ArrayList<Domain> domains;
    protected Collection<String> fileStores;
    private boolean layoutOnly;
    protected AsynchMethodInvoker<Void> processThread;

    static {
        try {
            String somaFileName = FileUtility.getSOMATemplateFileName("GetFileStoreRequest.xml");
            getFileStoreTemplate = FileUtility.readFile(somaFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
            getFileStoreTemplate = "";
        }
    }

    protected static Index<Appliance, Domain> getSearchDomainsFrom(Appliance appliance, Domain domain) {
        Index<Appliance, Domain> searchDomains = new Index<Appliance, Domain>();
        searchDomains.put(appliance, domain);
        return searchDomains;
    }

    protected static boolean isTemporaryExempt(String baseDirectory, ArrayList<Domain> domains) {
        if (baseDirectory.startsWith("temporary:")) {
            for (Domain domain : domains) {
                String domainName = domain.getName();
                String logBase = String.format("temporary:/log/%s", domainName);
                if (baseDirectory.startsWith(logBase)) {
                    return true;
                }
                String exportBase = String.format("temporary:/export/%s", domainName);
                if (!baseDirectory.startsWith(exportBase)) continue;
                return true;
            }
        }
        return false;
    }

    protected AbstractListFiles(Appliance appliance, ArrayList<Domain> domains) {
        this(appliance, domains, null);
    }

    protected AbstractListFiles(Appliance appliance, ArrayList<Domain> domains, Collection<String> fileStores) {
        super(appliance, appliance.getDomain("default"));
        this.setDomains(domains);
        this.setFileStores(fileStores);
    }

    public ArrayList<Domain> getDomains() {
        return this.domains;
    }

    public void setDomains(ArrayList<Domain> domains) {
        this.domains = domains;
    }

    public Collection<String> getFileStores() {
        return this.fileStores;
    }

    public void setFileStores(Collection<String> fileStores) {
        this.fileStores = fileStores;
    }

    public boolean isLayoutOnly() {
        return this.layoutOnly;
    }

    public void setLayoutOnly(boolean layoutOnly) {
        this.layoutOnly = layoutOnly;
    }

    protected boolean onlyHSMFileStores() {
        boolean onlyHSMFileStores = true;
        if (CollectionUtility.isNotEmpty(this.fileStores)) {
            for (String fileStore : this.fileStores) {
                if (fileStore.startsWith("hsm")) continue;
                onlyHSMFileStores = false;
                break;
            }
        } else {
            onlyHSMFileStores = false;
        }
        return onlyHSMFileStores;
    }

    public AsynchMethodInvoker<Void> getProcessThread() {
        return this.processThread;
    }

    @Override
    protected String getRequestMessage() {
        logger.finer(() -> LMG.log("(): Starting for %s", () -> this.appliance.getName()));
        String fileStoreRequest = getFileStoreTemplate.replace("${layoutOnly}", "" + this.layoutOnly);
        if (CollectionUtility.isEmpty(this.fileStores)) {
            logger.fine(() -> LMG.log("(): No files stores provided.  Listing directories for %s.", () -> this.appliance.getName()));
            fileStoreRequest = fileStoreRequest.replace("location=\"${fileStore}\"", "");
        } else {
            String requestStanza = DataPowerXMLManagement.getRequestStanza(fileStoreRequest);
            fileStoreRequest = fileStoreRequest.replace(requestStanza, "${requestStanzas}");
            StringBuilder requestStanzas = new StringBuilder();
            for (String fileStore : this.fileStores) {
                if (fileStore == null) {
                    logger.fine(() -> LMG.log("(): Filestore is null in filestores for %s.  Why.. but skipping.", () -> this.appliance.getName()));
                    break;
                }
                if (fileStore.equals("hsm:")) {
                    logger.fine("(): Ignoring 'hsm:' file store.");
                    continue;
                }
                String thisStanza = requestStanza.replace("${fileStore}", fileStore);
                requestStanzas.append(thisStanza);
                requestStanzas.append("\n");
            }
            if (StringUtility.isNotEmpty(requestStanza)) {
                fileStoreRequest = fileStoreRequest.replace("${requestStanzas}", requestStanzas.toString());
            }
        }
        if (logger.getLevel().equals(Level.FINEST)) {
            try {
                String logsDirectoryName = applicationProperties.getLogsDirectory();
                File logsDirectory = new File(logsDirectoryName);
                logsDirectory.mkdirs();
                File outputFile = new File(logsDirectory, "AbstractListFiles.fileStoreRequest.xml");
                new ASCFileWriter(outputFile, fileStoreRequest);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        logger.finer("(): Done.");
        return fileStoreRequest;
    }

    @Override
    public boolean methodInvocationNotice(InvocationEvent invocationEvent) {
        return true;
    }

    @Override
    public void methodInvoked(InvocationEvent invocationEvent) {
        this.notifyConfigObjectSubscribers();
    }

    @Override
    public void methodInvocationCancelled(InvocationEvent invocationEvent) {
        this.notifyConfigObjectSubscribers();
    }
}

