/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.tools.AbstractDataPowerManagementRequest;

public abstract class AbstractPacketCaptureActionTool
extends AbstractDataPowerManagementRequest {
    private String interfaceType;
    private String ethernetInterface;
    private String vlanInterface;
    private String linkAggInterface;
    private String standAloneInterface;

    public AbstractPacketCaptureActionTool(Appliance appliance, String interfaceType, String actionDescription) {
        super(appliance, appliance.getDomain("default"), actionDescription);
        this.setInterfaceType(interfaceType);
    }

    @Override
    protected String finalizeRequestMessage(String requestXML) {
        boolean removeEthernet = true;
        boolean removeVLAN = true;
        boolean removeLinkAgg = true;
        boolean removeStandAlone = true;
        switch (this.interfaceType) {
            case "Ethernet": {
                removeEthernet = false;
                break;
            }
            case "VLAN": {
                removeVLAN = false;
                break;
            }
            case "Aggregate": {
                removeLinkAgg = false;
                break;
            }
            case "Standalone": {
                removeStandAlone = false;
                break;
            }
            case "Loopback": 
            case "All": {
                removeEthernet = false;
                removeVLAN = false;
                removeLinkAgg = false;
                removeStandAlone = false;
            }
        }
        if (removeEthernet) {
            requestXML = AbstractPacketCaptureActionTool.removeElement(requestXML, "EthernetInterface");
        }
        if (removeVLAN) {
            requestXML = AbstractPacketCaptureActionTool.removeElement(requestXML, "VLANInterface");
        }
        if (removeLinkAgg) {
            requestXML = AbstractPacketCaptureActionTool.removeElement(requestXML, "LinkAggregation");
        }
        if (removeStandAlone) {
            requestXML = AbstractPacketCaptureActionTool.removeElement(requestXML, "StandaloneInterface");
        }
        return requestXML;
    }

    protected static String removeElement(String requestXML, String elementName) {
        String beginElement = String.format("<%s>", elementName);
        String endElement = String.format("</%s>", elementName);
        int beginRemove = requestXML.indexOf(beginElement);
        int endRemove = requestXML.indexOf(endElement) + endElement.length();
        return requestXML.substring(0, beginRemove) + requestXML.substring(endRemove);
    }

    public String getInterfaceType() {
        return this.interfaceType;
    }

    public void setInterfaceType(String interfaceType) {
        int spacePos = interfaceType.indexOf(32);
        this.interfaceType = interfaceType.substring(0, spacePos);
    }

    public String getEthernetInterface() {
        return this.ethernetInterface;
    }

    public void setEthernetInterface(String ethernetInterface) {
        this.ethernetInterface = ethernetInterface;
    }

    public String getVlanInterface() {
        return this.vlanInterface;
    }

    public void setVlanInterface(String vlanInterface) {
        this.vlanInterface = vlanInterface;
    }

    public String getLinkAggInterface() {
        return this.linkAggInterface;
    }

    public void setLinkAggInterface(String lingAggInterface) {
        this.linkAggInterface = lingAggInterface;
    }

    public String getStandAloneInterface() {
        return this.standAloneInterface;
    }

    public void setStandAloneInterface(String standAloneInterface) {
        this.standAloneInterface = standAloneInterface;
    }
}

