/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.beans.JMBean;
import java.util.Objects;

public class ApplianceInvocationProfile
extends JMBean {
    private String applianceName;
    private String invokerTarget;
    private String invokedMethod;
    private long invocationCount;
    private long averageTime;

    public ApplianceInvocationProfile() {
    }

    public ApplianceInvocationProfile(String applianceName, String invokerTarget, String invokedMethod) {
        this.setApplianceName(applianceName);
        this.setInvokerTarget(invokerTarget);
        this.setInvokedMethod(invokedMethod);
    }

    void addInvocation(long invocationTimeElapsed) {
        if (this.invocationCount == 0L) {
            this.invocationCount = 1L;
            this.setAverageTime(invocationTimeElapsed);
            return;
        }
        long totalTime = this.averageTime * this.invocationCount + invocationTimeElapsed;
        ++this.invocationCount;
        this.setAverageTime(totalTime / this.invocationCount);
    }

    public String getApplianceName() {
        return this.applianceName;
    }

    public void setApplianceName(String appliance) {
        this.applianceName = appliance;
    }

    public String getInvokerTarget() {
        return this.invokerTarget;
    }

    public void setInvokerTarget(String invokerTarget) {
        this.invokerTarget = invokerTarget;
    }

    public String getInvokedMethod() {
        return this.invokedMethod;
    }

    public void setInvokedMethod(String invokedMethod) {
        this.invokedMethod = invokedMethod;
    }

    public long getInvocationCount() {
        return this.invocationCount;
    }

    public void setInvocationCount(long invocationCount) {
        this.invocationCount = invocationCount;
    }

    public long getAverageTime() {
        return this.averageTime;
    }

    public void setAverageTime(long averageTime) {
        this.averageTime = averageTime;
    }

    public int compareTo(ApplianceInvocationProfile that) {
        return this.compareTo(that, "applianceName", "invokerTarget", "invokedMethod");
    }

    public boolean equals(Object that) {
        return this.equals(that, "applianceName", "invokerTarget", "invokedMethod");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.applianceName, this.invokerTarget, this.invokedMethod);
    }

    @Override
    public String toString() {
        return this.toString("applianceName", "invokerTarget", "invokedMethod");
    }
}

