/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.tools.AbstractConfigTool;
import java.util.Collection;

public class ConfigTool
extends AbstractConfigTool {
    private static final String configSegment = "<${configObjectType} name=\"${configObjectName}\">${configBody}</${configObjectType}>\n       ";

    public ConfigTool(Appliance appliance, Domain domain, DataPowerConfig configObject) {
        super(appliance, domain, configObject);
    }

    public ConfigTool(Appliance appliance, Domain domain, Collection<DataPowerConfig> configObjects) {
        super(appliance, domain, configObjects);
    }

    @Override
    protected String getCommandDescription(DataPowerConfig xmlManagementObject) {
        return String.format("Set configuration for %s %s", xmlManagementObject.getConfigObjectType(), xmlManagementObject.getName());
    }

    @Override
    protected String getRequestMessage() {
        logger.finer(() -> LMG.log("(): Initiating ConfigTool for %s", () -> this.xmlManagementObjectType));
        String requestXML = this.prepareXMLTemplate("ConfigTemplate.xml");
        int insertPoint = requestXML.indexOf("</dp:set-config>");
        for (DataPowerConfig configObject : this.xmlManagementObjects) {
            requestXML = StringUtility.insertInto(configSegment, requestXML, insertPoint);
            String configObjectType = configObject.getConfigObjectType();
            requestXML = requestXML.replace("${configObjectType}", configObjectType);
            String configObjectName = configObjectType.equals("NTPService") ? "NTPService" : configObject.getName();
            requestXML = requestXML.replace("${configObjectName}", configObjectName);
            requestXML = this.buildXMLRequestFromProperties(requestXML, "${configBody}", configObject);
            if (configObject.getConfigObjectType().equals("XMLFirewallService")) {
                int userSummaryIndex = requestXML.indexOf("<UserSummary>", insertPoint);
                int localAddressIndex = requestXML.indexOf("<LocalAddress>", insertPoint);
                if (userSummaryIndex >= 0 && localAddressIndex >= 0 && userSummaryIndex < localAddressIndex) {
                    int endUserSummaryIndex = requestXML.indexOf("</UserSummary>", userSummaryIndex) + 14;
                    int endLocalAddressIndex = requestXML.indexOf("</LocalAddress>", localAddressIndex) + 15;
                    String userSummaryText = requestXML.substring(userSummaryIndex, endUserSummaryIndex);
                    String localAddressText = requestXML.substring(localAddressIndex, endLocalAddressIndex);
                    requestXML = StringUtility.remove(requestXML, userSummaryText, userSummaryIndex);
                    requestXML = StringUtility.remove(requestXML, localAddressText, userSummaryIndex);
                    requestXML = StringUtility.insertInto(localAddressText, requestXML, userSummaryIndex);
                    requestXML = StringUtility.insertInto(userSummaryText, requestXML, userSummaryIndex + localAddressText.length());
                }
            }
            insertPoint = requestXML.indexOf("</dp:set-config>");
        }
        requestXML = this.cleanupRequestXML(requestXML);
        return requestXML;
    }
}

