/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.tools.ConfigurationReplace;
import com.kumbasoft.core.tools.ConfigurationSaveAs;

public class ConfigurationRename
extends ConfigurationReplace {
    public ConfigurationRename(StatusObjectStatus source, String newName) {
        this(source, newName, false);
    }

    public ConfigurationRename(StatusObjectStatus source, String newName, boolean keepOriginal) {
        super(source, newName, keepOriginal);
    }

    @Override
    public void performProcess() {
        logger.finer(() -> LMG.log("(): Starting SaveAs Operation for %s %s to %s", () -> this.source.getDataPowerClass(), () -> this.source.getName(), () -> this.newName));
        SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
        ConfigurationSaveAs configurationSaveAs = new ConfigurationSaveAs(this.source, this.newName);
        configurationSaveAs.getProcessThread().addInvocationListener(stil);
        configurationSaveAs.addManagementCommandSubscriber(this.managementCommandSubscribers);
        logger.finer("(): Waiting for save-as to complete");
        while (!stil.invocationComplete()) {
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
        }
        logger.finer("(): Save-as completed");
        super.performProcess();
        logger.finer("(): Done.");
    }
}

