/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.beans.ManagementCommandSubscriber;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.tools.AbstractConfigurationActionTool;
import com.kumbasoft.core.tools.ConfigTool;
import java.util.function.Supplier;

public class ConfigurationSaveAs
extends AbstractConfigurationActionTool {
    private String newName;

    public ConfigurationSaveAs(StatusObjectStatus sourceObject, String newName) {
        super(sourceObject);
        this.setNewName(newName);
    }

    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    @Override
    public void performProcess() {
        logger.finer(() -> LMG.log("(): Starting", new Supplier[0]));
        ConfigurationManager configurationManager = new ConfigurationManager();
        DataPowerConfig objectConfiguration = configurationManager.getObject(this.source);
        logger.config(() -> LMG.log("(): Got object configuration ... saving %s as %s", () -> this.source.getName(), () -> this.newName));
        objectConfiguration.setName(this.newName);
        SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
        ConfigTool configTool = new ConfigTool(this.source.getAppliance(), this.source.getSourceDomain(), objectConfiguration);
        configTool.getProcessThread().addInvocationListener(stil);
        stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
        if (CollectionUtility.isNotEmpty(this.managementCommandSubscribers)) {
            ManagementCommandStatus result = new ManagementCommandStatus(this.source.getAppliance(), this.getSource().getSourceDomain(), "Save Object As", configTool, String.format("%s %s successfully saved as %s", this.source.getDataPowerClass(), this.source.getName(), this.newName));
            for (ManagementCommandSubscriber subscriber : this.managementCommandSubscribers) {
                subscriber.commandSucceeded(result);
            }
        }
        logger.finer(() -> LMG.log("(): Done", new Supplier[0]));
    }
}

