/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.io.FileOutputStreamHelper;
import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.lang.Application;
import com.jmorgan.util.Date;
import com.jmorgan.util.DateTime;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.ManagementCommandResult;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.tools.AbstractDataPowerManagementRequest;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import org.apache.commons.codec.binary.Base64;

public class CreateDomainBackup
extends AbstractDataPowerManagementRequest {
    private static final SimpleDateFormat timeFormat = new SimpleDateFormat("HH-mm-ss");
    private static String backupsDirectory;

    public CreateDomainBackup(Appliance appliance, Domain domain) {
        super(appliance, domain, "Create Backup");
        if (backupsDirectory == null) {
            backupsDirectory = applicationProperties.getDomainBackupsDirectory();
        }
    }

    @Override
    protected boolean processResultDocument(XMLElement rootElement) {
        Collection<XMLElement> logFileNodeList = rootElement.getNodes("//dp:file");
        for (XMLElement fileNode : logFileNodeList) {
            String base64Content = fileNode.getValue();
            byte[] fileBytes = Base64.decodeBase64(base64Content);
            DateTime now = new DateTime();
            now.getDate().setFormat(Date.SQL_FORMAT);
            now.getTime().setFormat(timeFormat);
            String backupDirName = String.format("%s%s%s%s%s", backupsDirectory, File.separator, this.getAppliance().getName(), File.separator, this.getDomain().getName());
            File backupDir = new File(backupDirName);
            backupDir.mkdirs();
            String fileName = String.format("%s%s-Backup.zip", Character.valueOf(File.separatorChar), now.toString());
            File backupFile = new File(backupDir, fileName);
            Application.getApplication().getApplicationLogger().fine(String.format("CreateDomainBackup.processAction():  Output File:%s\n", backupFile.getAbsolutePath()));
            FileOutputStreamHelper fout = new FileOutputStreamHelper(backupFile);
            fout.open();
            BufferedOutputStream bout = (BufferedOutputStream)fout.getStream();
            ManagementCommandResult doActionResult = null;
            try {
                bout.write(fileBytes);
                doActionResult = new ManagementCommandStatus(this.getAppliance(), this.getDomain(), this.getCommandDescription(), this, "OK");
            }
            catch (IOException e) {
                e.printStackTrace();
                doActionResult = new ManagementCommandError(this.getAppliance(), this.getDomain(), this.getCommandDescription(), this, e.getMessage());
            }
            fout.close();
            this.notifyManagementCommandSubscribers(doActionResult);
        }
        return true;
    }
}

