/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.io.ASCFileWriter;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigObjectCache;
import com.kumbasoft.core.beans.ConfigObjectSubscriber;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.DataPowerFileReader;
import com.kumbasoft.core.tools.ListFiles;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class DataPowerFileExporter
extends AbstractTool
implements ConfigObjectSubscriber<DataPowerFileInfo> {
    private static final String FILE_BACKUP_DIRECTORY = AbstractTool.applicationProperties.getFileBackupDirectory();
    private Appliance appliance;
    private Domain domain;
    private DataPowerFileInfo dpFileInfo;
    private File exportLocation;
    private AsynchMethodInvoker<Void> listFilesThread;
    private AsynchMethodInvoker<Void> fileReaderThread;

    public DataPowerFileExporter(Appliance appliance, Domain domain, DataPowerFileInfo dpFileInfo, File exportLocation) {
        String loggerPrefix = String.format("(appliance=%s, domain=%s, dpFileInfo=%s, exportLocation=%s)", appliance.getName(), domain.getName(), dpFileInfo == null ? "--null--" : dpFileInfo.getAbsolutePath(), exportLocation == null ? "--null--" : exportLocation.getAbsolutePath());
        logger.finer(loggerPrefix + ": Starting");
        this.appliance = appliance;
        this.domain = domain;
        this.dpFileInfo = dpFileInfo;
        String fileStore = null;
        String searchPattern = null;
        if (dpFileInfo != null) {
            logger.finer(() -> LMG.log("%s: dpFileInfo is not null, using file store and search pattern from it", () -> loggerPrefix));
            fileStore = dpFileInfo.getFileStore();
            searchPattern = dpFileInfo.getAbsolutePath();
        } else {
            logger.fine(() -> LMG.log("%s: dpFileInfo is null, setting search pattern to '.*'", () -> loggerPrefix));
            searchPattern = ".*";
        }
        if (exportLocation == null) {
            this.exportLocation = new File(FILE_BACKUP_DIRECTORY);
            logger.fine(() -> LMG.log("%s: Export location is null.  Using %s.", () -> loggerPrefix, () -> this.exportLocation.getAbsolutePath()));
        } else {
            logger.finer(() -> LMG.log("%s: Export location %s.", () -> loggerPrefix, () -> exportLocation.getAbsolutePath()));
            this.exportLocation = exportLocation;
        }
        String processingFileStore = fileStore;
        String finalSearchPattern = searchPattern;
        logger.finer(() -> LMG.log("%s:  File Store: %s, searchPattern=%s", () -> loggerPrefix, () -> processingFileStore, () -> finalSearchPattern));
        if (dpFileInfo == null) {
            logger.fine(() -> LMG.log("%s: dpFileInfo is null, listing ALL files.", () -> loggerPrefix));
            ListFiles listFiles = new ListFiles(appliance, domain, fileStore, searchPattern);
            this.listFilesThread = listFiles.getProcessThread();
            listFiles.addConfigObjectSubscriber(DataPowerFileInfo.class, this);
        } else if (dpFileInfo.getFileName().equals("")) {
            logger.fine(() -> LMG.log("%s: dpFileInfo is a directory, listing the files in %s.", () -> loggerPrefix, () -> dpFileInfo.getBaseDirectory()));
            searchPattern = dpFileInfo.getBaseDirectory();
            SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
            ConfigObjectCache fileCache = new ConfigObjectCache();
            ListFiles listFiles = new ListFiles(appliance, domain, fileStore, searchPattern);
            this.listFilesThread = listFiles.getProcessThread();
            this.listFilesThread.addInvocationListener(stil);
            listFiles.addConfigObjectSubscriber(DataPowerFileInfo.class, fileCache);
            stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
            Vector directoryFiles = fileCache.getObjectCache();
            logger.fine(() -> LMG.log("%s: Listed %d files from %s.", () -> loggerPrefix, () -> directoryFiles.size(), () -> dpFileInfo.getBaseDirectory()));
            for (DataPowerFileInfo file : directoryFiles) {
                String absolutePath = file.getAbsolutePath();
                if (!absolutePath.startsWith(dpFileInfo.getBaseDirectory())) continue;
                this.processDataPowerConfig(file);
            }
        } else {
            logger.fine(() -> LMG.log("%s: dpFileInfo is not null, processing the file directly.", () -> loggerPrefix));
            this.processDataPowerConfig(dpFileInfo);
        }
        logger.finer(loggerPrefix + ": Done");
    }

    public Appliance getAppliance() {
        return this.appliance;
    }

    public void setAppliance(Appliance appliance) {
        this.appliance = appliance;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public DataPowerFileInfo getDpFileInfo() {
        return this.dpFileInfo;
    }

    public void setDpFileInfo(DataPowerFileInfo dpFileInfo) {
        this.dpFileInfo = dpFileInfo;
    }

    public File getExportLocation() {
        return this.exportLocation;
    }

    public void setExportLocation(File exportLocation) {
        if (exportLocation == null) {
            exportLocation = new File(FILE_BACKUP_DIRECTORY);
            logger.fine(() -> LMG.log("(File exportLocation): Export location is null.  Using %s.", () -> this.exportLocation.getAbsolutePath()));
        }
        String exportPath = exportLocation.getAbsolutePath();
        if (!exportLocation.exists()) {
            logger.severe(() -> LMG.log("(File exportLocation):  Export location %s does not exist.", () -> exportPath));
            throw new IllegalArgumentException("DataPowerFileExporter.setExportLocation(File exportLocation):  Export location does not exist.");
        }
        if (!exportLocation.isDirectory()) {
            logger.severe(() -> LMG.log("(File exportLocation):  Export location %s is not a directory.", () -> exportPath));
            throw new IllegalArgumentException("DataPowerFileExporter.setExportLocation(File exportLocation):  Export location is not a directory.");
        }
        this.exportLocation = exportLocation;
    }

    public AsynchMethodInvoker<Void> getListFilesThread() {
        return this.listFilesThread;
    }

    public AsynchMethodInvoker<Void> getFileReaderThread() {
        return this.fileReaderThread;
    }

    @Override
    public void processDataPowerConfig(DataPowerFileInfo dataPowerFileInfo) {
        String loggerPrefix = String.format("(DataPowerFileInfo=%s)", dataPowerFileInfo.getFQON());
        logger.finer(() -> LMG.log("%s: Starting", () -> loggerPrefix));
        if (StringUtility.isEmpty(dataPowerFileInfo.getFileName())) {
            logger.fine(() -> LMG.log("%s: File is a directory.  Skipping.", () -> loggerPrefix));
            return;
        }
        String fileStore = dataPowerFileInfo.getFileStore();
        if (fileStore.endsWith("cert:")) {
            logger.info(() -> LMG.log("%s:  Ignoring %s filestore", () -> loggerPrefix, () -> dataPowerFileInfo.getFileStore()));
            return;
        }
        String fileContent = dataPowerFileInfo.getFileContent();
        Appliance appliance = dataPowerFileInfo.getAppliance();
        if (fileContent == null) {
            logger.finer(() -> LMG.log("%s:  File Content is null.  Reading the file from DataPower.", () -> loggerPrefix));
            SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
            DataPowerFileReader fileReader = new DataPowerFileReader(dataPowerFileInfo);
            this.fileReaderThread = fileReader.getProcessThread();
            this.fileReaderThread.addInvocationListener(stil);
            fileReader.addConfigObjectSubscriber(DataPowerFileInfo.class, this);
            stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
        } else {
            logger.finer(() -> LMG.log("%s:  local file is present.  Processing.", () -> loggerPrefix));
            Domain domain = dataPowerFileInfo.getSourceDomain();
            String dataPowerFileName = dataPowerFileInfo.getFileName();
            String baseDirectory = dataPowerFileInfo.getBaseDirectory();
            baseDirectory = baseDirectory.replace(fileStore, "");
            fileStore = fileStore.replaceAll(":", "");
            String outputLocation = String.format("%s%s%s%sFileSystem%s%s%s%s%s", appliance.getName(), File.separator, domain.getName(), File.separator, File.separator, fileStore, File.separator, baseDirectory, File.separator);
            File fileOutputDir = new File(this.exportLocation, StringUtility.coalesce(outputLocation, File.separator));
            if (!fileOutputDir.exists()) {
                fileOutputDir.mkdirs();
            }
            File outputFile = new File(fileOutputDir, dataPowerFileName);
            try {
                new ASCFileWriter(outputFile, fileContent);
            }
            catch (IOException e) {
                logger.severe(() -> LMG.log("%s: Failed to write file '%s' for upload.", () -> loggerPrefix, () -> outputFile.getAbsolutePath()));
                e.printStackTrace();
            }
        }
        logger.finer(() -> LMG.log("%s: Done", () -> loggerPrefix));
    }

    @Override
    public void configProcessingComplete() {
    }
}

