/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.io.ASCFileReader;
import com.jmorgan.io.ASCFileWriter;
import com.jmorgan.io.FileOutputStreamHelper;
import com.jmorgan.io.FileReaderHelper;
import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.Pair;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.status.StatusDomainStatus;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.DataPowerStatusParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;

public class ErrorReportProcessor
extends AbstractTool {
    private Appliance appliance;
    private Domain defaultDomain;
    private ArrayList<String> domainsFromErrorReport;
    private File errorReportFile;
    private File unzippedErrorReportDirectory;
    private File unzippedErrorReportFile;
    private HashMap<Pair<Domain, String>, File> sectionFileMap;

    public ErrorReportProcessor(Appliance appliance, File errorReportFile) {
        this.setAppliance(appliance);
        this.setErrorReportFile(errorReportFile);
    }

    public Appliance getAppliance() {
        return this.appliance;
    }

    public void setAppliance(Appliance appliance) {
        if (appliance == null) {
            appliance = new Appliance();
            appliance.setName("From_External_File");
            appliance.setConnected(false);
            appliance.addDomain(new Domain("default"));
        }
        this.appliance = appliance;
        this.defaultDomain = appliance.getDomain("default");
    }

    public ArrayList<String> getDomainsFromErrorReport() {
        return this.domainsFromErrorReport;
    }

    public File getErrorReportFile() {
        return this.errorReportFile;
    }

    public void setErrorReportFile(File errorReportFile) {
        this.errorReportFile = errorReportFile;
        this.splitupErrorReportFile();
    }

    public HashMap<Pair<Domain, String>, File> getSectionFileMap() {
        return this.sectionFileMap;
    }

    private void splitupErrorReportFile() {
        this.unzipErrorReportFile();
        FileReaderHelper fileReaderHelper = new FileReaderHelper(this.unzippedErrorReportFile);
        fileReaderHelper.open();
        BufferedReader reader = (BufferedReader)fileReaderHelper.getReader();
        String boundary = ErrorReportProcessor.getMimeBoundary(reader);
        ErrorReportProcessor.readToNextBoundary(reader, boundary);
        this.sectionFileMap = new HashMap();
        ArrayList<String> section = ErrorReportProcessor.readToNextBoundary(reader, boundary);
        while (CollectionUtility.isNotEmpty(section)) {
            String contentIDPrefix;
            String contentID;
            String contentType;
            String contentTypeExtension;
            String domainName = "default";
            String contentTypeLine = null;
            String contentIDLine = null;
            ArrayList<String> sectionIterator = new ArrayList<String>(section);
            int i = 0;
            block3: while (i < sectionIterator.size()) {
                String sectionLine = sectionIterator.get(i);
                if (sectionLine.contains("Content-Type:")) {
                    contentTypeLine = sectionLine.trim();
                } else if (sectionLine.contains("Content-ID")) {
                    contentIDLine = sectionLine.trim();
                }
                section.remove(0);
                if (contentTypeLine != null && contentIDLine != null) {
                    int j = i + 1;
                    while (j < sectionIterator.size()) {
                        sectionLine = sectionIterator.get(j);
                        if (!StringUtility.isEmpty(sectionLine)) break block3;
                        section.remove(0);
                        ++j;
                    }
                    break;
                }
                ++i;
            }
            if ((contentTypeExtension = StringUtility.substringAfter(contentType = StringUtility.getMarkupContent(contentTypeLine, ": ", ";"), "/")).contains("+")) {
                contentTypeExtension = StringUtility.substringAfter(contentTypeExtension, "+");
            }
            if (contentTypeExtension.equals("plain")) {
                contentTypeExtension = "txt";
            }
            if ((contentID = StringUtility.getMarkupContent(contentIDLine, "<", "@")).contains("-") && CollectionUtility.isNotEmpty(this.domainsFromErrorReport) && this.domainsFromErrorReport.contains(contentIDPrefix = StringUtility.substringBefore(contentID, "-"))) {
                contentID = StringUtility.substringAfter(contentID, "-");
                domainName = contentIDPrefix;
            }
            boolean appendFile = false;
            if (StringUtility.startsWithAnyOf(contentID, "AuditLog-Backup", "CLILog-Backup", "CompilerLog-Backup", "DPmon-Backup", "log.1", "log.2", "log.3", "log.4", "SysRecord-Backup", "UsageLog-Backup", "XACTLog-Backup")) {
                appendFile = true;
                contentID = contentID.contains("-Backup") ? StringUtility.substringBefore(contentID, "-Backup") : StringUtility.substringBefore(contentID, ".");
            }
            String sectionFileName = String.format("%s.%s", contentID, contentTypeExtension.trim());
            String contentIDName = contentID;
            logger.finer(() -> LMG.log("Section: %s -> File: %s", () -> contentIDName, () -> sectionFileName));
            try {
                File sectionOutputDirectory = new File(this.unzippedErrorReportDirectory, domainName);
                if (!sectionOutputDirectory.exists()) {
                    sectionOutputDirectory.mkdirs();
                }
                File sectionOutputFile = new File(sectionOutputDirectory, sectionFileName);
                Domain domain = this.appliance.getDomain(domainName);
                if (domain == null) {
                    domain = new Domain(domainName);
                    this.appliance.addDomain(domain);
                }
                this.sectionFileMap.put(new Pair<Domain, String>(domain, contentID), sectionOutputFile);
                if (appendFile || !sectionOutputFile.exists()) {
                    new ASCFileWriter(sectionOutputFile, section, appendFile);
                }
                if (contentID.equals("DomainStatus")) {
                    this.loadDomainsFromErrorReport(section, sectionOutputFile);
                }
                if (this.appliance.getName().equals("From_External_File") && sectionFileName.equals("config.txt") && domainName.equals("default")) {
                    this.getApplianceNameFromDefaultConfig(sectionOutputFile);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            section = ErrorReportProcessor.readToNextBoundary(reader, boundary);
        }
        fileReaderHelper.close();
    }

    private void getApplianceNameFromDefaultConfig(File sectionOutputFile) {
        boolean foundSystem = false;
        try {
            ASCFileReader reader = new ASCFileReader(sectionOutputFile);
            Collection<String> fileData = reader.getData();
            for (String configLine : fileData) {
                configLine = configLine.trim();
                if (!foundSystem && configLine.equals("system")) {
                    foundSystem = true;
                    continue;
                }
                if (!foundSystem || !configLine.startsWith("name")) continue;
                String name = configLine.substring(6, configLine.length() - 1);
                this.appliance.setName(name);
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadDomainsFromErrorReport(ArrayList<String> section, File sectionOutputFile) {
        DataPowerStatusParser parser = new DataPowerStatusParser(this.appliance, this.defaultDomain, "DomainStatus", new DateTime(sectionOutputFile.lastModified()));
        StringBuilder sb = new StringBuilder();
        for (String s : section) {
            sb.append(s);
        }
        XMLElement domainStatusXML = XMLElement.parseXMLString(sb.toString());
        if (domainStatusXML == null) {
            Exception parseException = XMLElement.getParseException();
            String errorMessage = String.format("Unable to parse domain status XML due to %s.", parseException.getClass().getSimpleName());
            logger.warning(errorMessage);
            logger.warning(sb.toString());
            return;
        }
        if (this.domainsFromErrorReport != null) {
            this.domainsFromErrorReport.clear();
            this.domainsFromErrorReport = null;
        }
        this.domainsFromErrorReport = new ArrayList();
        Collection domainStatusList = parser.processStatusData(domainStatusXML);
        for (StatusDomainStatus domainStatus : domainStatusList) {
            String domainName = domainStatus.getDomain();
            this.domainsFromErrorReport.add(domainName);
        }
    }

    private static ArrayList<String> readToNextBoundary(BufferedReader reader, String boundary) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String outputLine = reader.readLine();
            while (outputLine != null) {
                if (!outputLine.trim().equals(boundary)) {
                    lines.add(outputLine);
                    outputLine = reader.readLine();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lines;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getMimeBoundary(BufferedReader reader) {
        try {
            for (String outputLine = reader.readLine(); outputLine != null; outputLine = outputLine.trim()) {
                try {
                    if (StringUtility.isEmpty(outputLine) || outputLine.startsWith("MIME-Version") || !outputLine.contains("boundary=")) continue;
                    String boundary = StringUtility.substringAfter(outputLine, "boundary=");
                    boundary = boundary.replace("\"", "");
                    String string = "--" + boundary;
                    return string;
                }
                finally {
                    outputLine = reader.readLine();
                }
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void unzipErrorReportFile() {
        String absolutePathName = this.errorReportFile.getAbsolutePath();
        if (!absolutePathName.endsWith(".gz")) {
            this.unzippedErrorReportDirectory = this.errorReportFile.getParentFile();
            this.unzippedErrorReportFile = this.errorReportFile;
            return;
        }
        String unzipDirectoryName = StringUtility.substringBefore(absolutePathName, ".txt.gz");
        this.unzippedErrorReportDirectory = new File(unzipDirectoryName);
        if (!this.unzippedErrorReportDirectory.exists()) {
            this.unzippedErrorReportDirectory.mkdirs();
        }
        this.unzippedErrorReportFile = new File(this.unzippedErrorReportDirectory, "ErrorReport.out");
        if (this.unzippedErrorReportFile.exists()) {
            return;
        }
        try {
            GZIPInputStream in = new GZIPInputStream(new FileInputStream(this.errorReportFile));
            FileOutputStreamHelper fout = new FileOutputStreamHelper(this.unzippedErrorReportFile);
            fout.open();
            int b = 0;
            while ((b = in.read()) != -1) {
                ((OutputStream)fout.getStream()).write(b);
            }
            in.close();
            fout.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

