/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.CommandSubscriptionBean;
import com.kumbasoft.core.beans.ConfigObjectCache;
import com.kumbasoft.core.beans.CopyMoveType;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.actions.ActionCreateDir;
import com.kumbasoft.core.beans.actions.ActionDeleteFile;
import com.kumbasoft.core.beans.actions.ActionFetchFile;
import com.kumbasoft.core.beans.actions.ActionMoveFile;
import com.kumbasoft.core.tools.AbstractCommandProcessFileTool;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.DataPowerFileReader;
import com.kumbasoft.core.tools.FileUploader;
import com.kumbasoft.core.tools.ThreadManager;
import java.util.Vector;

public class FileCopyMove
extends AbstractCommandProcessFileTool {
    public static final int MODE_COPY = 0;
    public static final int MODE_MOVE = 1;
    private CopyMoveType copyMoveMode;
    private boolean createDirectories;
    private boolean overwriteFiles;

    public FileCopyMove(DataPowerFileInfo sourceFile, DataPowerFileInfo targetFile, boolean createDirectories, boolean overwriteFiles) {
        this(sourceFile, targetFile, CopyMoveType.COPY, createDirectories, overwriteFiles);
    }

    public FileCopyMove(DataPowerFileInfo sourceFile, DataPowerFileInfo targetFile, CopyMoveType mode, boolean createDirectories, boolean overwriteFiles) {
        super(sourceFile, targetFile);
        this.copyMoveMode = mode;
        this.createDirectories = createDirectories;
        this.overwriteFiles = overwriteFiles;
    }

    @Override
    public void performProcess() {
        AbstractTool.logger.finer("(): Starting");
        String overwriteToggle = this.overwriteFiles ? "on" : "off";
        Appliance sourceAppliance = this.sourceFile.getAppliance();
        Domain sourceDomain = this.sourceFile.getSourceDomain();
        String sourceFileName = this.sourceFile.getAbsolutePath();
        Appliance targetAppliance = this.targetFile.getAppliance();
        Domain targetDomain = this.targetFile.getSourceDomain();
        String targetFileName = this.targetFile.getAbsolutePath();
        String commandDescription = String.format("%s from %s->%s->%s to %s->%s->%s", this.copyMoveMode == CopyMoveType.COPY ? "Copy" : "Move", sourceAppliance.getName(), sourceDomain.getName(), sourceFileName, targetAppliance.getName(), targetDomain.getName(), targetFileName);
        if (this.createDirectories) {
            String targetDirectory = this.targetFile.getBaseDirectory();
            boolean okToCreateDirectory = false;
            if (targetDirectory.startsWith("local:") || targetDirectory.startsWith("logtemp:") || targetDirectory.startsWith("logstore:") || targetDirectory.startsWith("policyframework:") || targetDirectory.startsWith("temporary:")) {
                String fileStore = StringUtility.substringBefore(targetDirectory, ":");
                if (targetDirectory.length() > fileStore.length() + 2) {
                    okToCreateDirectory = true;
                }
            }
            if (okToCreateDirectory) {
                AbstractTool.logger.finer(() -> LMG.log("():  Creating directory %s in %s domain of %s if needed", () -> targetDirectory, () -> targetDomain.getName(), () -> targetAppliance.getName()));
                ActionCreateDir createDirAction = new ActionCreateDir();
                createDirAction.setDir(targetDirectory);
                new ActionTool(targetAppliance, targetDomain, createDirAction, true);
            }
        }
        if (sourceAppliance.equals(targetAppliance) && sourceDomain.equals(targetDomain)) {
            AbstractTool.logger.finer(() -> LMG.log("():  Using on-board file copy/move for %s -> %s.", () -> this.sourceFile.getAbsolutePath(), () -> this.targetFile.getAbsolutePath()));
            stil = new SingleThreadInvocationListener();
            if (this.copyMoveMode.value == CopyMoveType.COPY.value) {
                ActionFetchFile fetchFileAction = new ActionFetchFile();
                fetchFileAction.setURL(this.sourceFile.getAbsolutePath());
                fetchFileAction.setFile(this.targetFile.getAbsolutePath());
                fetchFileAction.setOverwrite(overwriteToggle);
                actionTool = new ActionTool(sourceAppliance, sourceDomain, fetchFileAction);
                actionTool.setCommandDescription(commandDescription);
                actionTool.getProcessThread().addInvocationListener(stil);
                this.addCommandSubscribers(actionTool);
            } else {
                ActionMoveFile moveFileAction = new ActionMoveFile();
                moveFileAction.setSURL(this.sourceFile.getAbsolutePath());
                moveFileAction.setDURL(this.targetFile.getAbsolutePath());
                moveFileAction.setOverwrite(overwriteToggle);
                actionTool = new ActionTool(sourceAppliance, sourceDomain, moveFileAction);
                actionTool.setCommandDescription(commandDescription);
                actionTool.getProcessThread().addInvocationListener(stil);
                this.addCommandSubscribers(actionTool);
            }
            AbstractTool.logger.finer(() -> LMG.log("():  Waiting for copy/move for %s -> %s to complete.", () -> this.sourceFile.getAbsolutePath(), () -> this.targetFile.getAbsolutePath()));
            stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
            AbstractTool.logger.finer(() -> LMG.log("():  Copy/move for %s -> %s completed.", () -> this.sourceFile.getAbsolutePath(), () -> this.targetFile.getAbsolutePath()));
        } else {
            AbstractTool.logger.finer(() -> LMG.log("():  Using export/import file copy/move for %s -> %s.  Reading source.", () -> this.sourceFile.getAbsolutePath(), () -> this.targetFile.getAbsolutePath()));
            stil = new SingleThreadInvocationListener();
            CommandSubscriptionBean commandResultInfo = new CommandSubscriptionBean();
            ConfigObjectCache sourceFileData = new ConfigObjectCache();
            DataPowerFileReader fileReader = new DataPowerFileReader(this.sourceFile, true);
            fileReader.getProcessThread().addInvocationListener(stil);
            fileReader.addConfigObjectSubscriber(DataPowerFileInfo.class, sourceFileData);
            fileReader.addManagementCommandSubscriber(commandResultInfo);
            stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
            Vector files = sourceFileData.getObjectCache();
            AbstractTool.logger.finer(() -> LMG.log("():  Read %d source file(s): %s.", () -> files.size(), () -> this.sourceFile.getAbsolutePath()));
            if (files.size() == 0) {
                AbstractTool.logger.severe("():  File Cache is empty reading source file.  How?");
            } else {
                if (files.size() > 1) {
                    AbstractTool.logger.warning(() -> LMG.log("():  File Cache contains %d files.  How?", () -> files.size()));
                }
                DataPowerFileInfo dataPowerConfig = (DataPowerFileInfo)files.get(0);
                dataPowerConfig.setAppliance(targetAppliance);
                dataPowerConfig.setSourceDomain(targetDomain);
                String name = targetFileName;
                int lastSlash = targetFileName.lastIndexOf(47);
                if (lastSlash > -1) {
                    name = targetFileName.substring(lastSlash + 1);
                }
                dataPowerConfig.setFileName(name);
                dataPowerConfig.setBaseDirectory("temporary:/");
                AbstractTool.logger.finer(() -> LMG.log("(): Uploading %s to temporary:/", () -> this.sourceFile.getAbsolutePath()));
                MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
                FileUploader.upload(CollectionUtility.createListFrom(dataPowerConfig), mtil);
                ThreadManager.monitorAsynchThreadLifeCycle("FileCopyMove.performProcess()", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
                AbstractTool.logger.finer(() -> LMG.log("(): Moving %s from temporary:/ to %s", () -> dataPowerConfig.getAbsolutePath(), () -> this.targetFile.getAbsolutePath()));
                ActionMoveFile moveFileAction = new ActionMoveFile();
                moveFileAction.setSURL(dataPowerConfig.getAbsolutePath());
                moveFileAction.setDURL(this.targetFile.getAbsolutePath());
                moveFileAction.setOverwrite(overwriteToggle);
                stil.clearCompletionStatus();
                ActionTool actionTool = new ActionTool(targetAppliance, targetDomain, moveFileAction);
                actionTool.getProcessThread().addInvocationListener(stil);
                actionTool.setCommandDescription(commandDescription);
                actionTool.addManagementCommandSubscriber(commandResultInfo);
                this.addCommandSubscribers(actionTool);
                stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
                AbstractTool.logger.finer(() -> LMG.log("(): File %s moved from temporary:/ to %s", () -> dataPowerConfig.getAbsolutePath(), () -> this.targetFile.getAbsolutePath()));
                if (this.copyMoveMode == CopyMoveType.MOVE && commandResultInfo.getErrors().size() == 0) {
                    AbstractTool.logger.finer(() -> LMG.log("(): User selected move.  Deleting source %s", () -> this.sourceFile.getAbsolutePath()));
                    ActionDeleteFile actionDeleteFile = new ActionDeleteFile();
                    actionDeleteFile.setFile(this.sourceFile.getName());
                    stil.clearCompletionStatus();
                    ActionTool fileDeleter = new ActionTool(this.sourceFile.getAppliance(), this.sourceFile.getSourceDomain(), actionDeleteFile);
                    fileDeleter.getProcessThread().addInvocationListener(stil);
                    fileDeleter.setCommandDescription(String.format("Delete file %s in %s domain of %s", this.sourceFile.getAbsolutePath(), this.sourceFile.getSourceDomain().getName(), this.sourceFile.getAppliance().getName()));
                    fileDeleter.addAdditionalCommandInfo("file", this.sourceFile);
                    this.addCommandSubscribers(fileDeleter);
                    stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
                    AbstractTool.logger.finer(() -> LMG.log("(): User selected move.  Source %s deleted.", () -> this.sourceFile.getAbsolutePath()));
                }
            }
        }
        AbstractTool.logger.finer("(): Done");
    }
}

