/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.util.Index;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.beans.ManagementCommandSubscriber;
import com.kumbasoft.core.tools.AbstractFileManagementRequest;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.DataPowerXMLManagement;
import com.kumbasoft.core.util.DataStructureUtility;
import com.kumbasoft.core.util.FileUtility;
import com.kumbasoft.core.util.logging.FinestLogRecord;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.apache.commons.codec.binary.Base64;

public class FileUploader
extends AbstractFileManagementRequest
implements ManagementCommandSubscriber {
    private static ArrayList<FileUploader> instances;
    private static Index<Long, ManagementCommandSubscriber> subscribers;
    private static final String FILE_CONTENT_MARKER = "-----fileContent-----";
    private long instant = System.currentTimeMillis();
    private int responseIndex;

    public static ArrayList<FileUploader> upload(Collection<DataPowerFileInfo> files, MultiThreadInvocationListener mtil) {
        logger.finer("(files, mtil): Starting.  Clearing instances.");
        instances = CollectionUtility.createOrClear(instances);
        logger.finer(() -> LMG.log("(files, mtil): Uploading %d files", () -> files.size()));
        if (CollectionUtility.isEmpty(files)) {
            logger.info("(files, mtil): No files to upload.  Returning.");
            return null;
        }
        Index<Appliance, DataPowerFileInfo> filesByAppliance = DataStructureUtility.mapByAppliance(files);
        for (Appliance appliance : filesByAppliance.getKeys()) {
            ArrayList fileList = (ArrayList)filesByAppliance.get(appliance);
            logger.finer(() -> LMG.log("(files, mtil): Uploading %d files to %s", () -> fileList.size(), () -> appliance.getName()));
            FileUploader fileUploader = new FileUploader(fileList);
            AsynchMethodInvoker<?> processThread = fileUploader.getProcessThread();
            mtil.addThread(processThread);
            instances.add(fileUploader);
        }
        logger.finer(() -> LMG.log("(files, mtil): Done initiating upload of %d files.  Returning %d FileUploader instances.", () -> files.size(), () -> instances.size()));
        return instances;
    }

    public static void addCommandSubscribers(Collection<ManagementCommandSubscriber> managementCommandSubscribers) {
        if (CollectionUtility.isNotEmpty(managementCommandSubscribers)) {
            for (ManagementCommandSubscriber subscriber : managementCommandSubscribers) {
                FileUploader.addCommandSubscriber(subscriber);
            }
        }
    }

    public static void addCommandSubscriber(ManagementCommandSubscriber managementCommandSubscriber) {
        if (CollectionUtility.isEmpty(instances)) {
            return;
        }
        if (subscribers == null) {
            subscribers = new Index();
        }
        for (FileUploader fileUploader : instances) {
            subscribers.put((Long)fileUploader.instant, managementCommandSubscriber);
            fileUploader.addManagementCommandSubscriber(fileUploader);
        }
    }

    public static void resetStaticState() {
        instances.clear();
        instances = null;
        subscribers.clear();
        subscribers = null;
    }

    public FileUploader(ArrayList<DataPowerFileInfo> files) {
        super(files);
        logger.finer(() -> LMG.log("Uploading %d files to %s", () -> files.size(), () -> ((DataPowerFileInfo)files.get(0)).getAppliance().getName()));
        this.setCommandDescription("Upload File" + (files.size() > 1 ? "s" : ""));
        this.kickoffProcessThread();
    }

    public FileUploader(DataPowerFileInfo dataPowerFileInfo, String sourceFileName) {
        this(CollectionUtility.createListFrom(dataPowerFileInfo));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String getRequestMessage() {
        AbstractTool.logger.finer("(): Starting");
        String somaTemplate = this.getSOMATemplate();
        String requestStanza = DataPowerXMLManagement.getRequestStanza(somaTemplate);
        String requestXML = somaTemplate.replace(requestStanza, "${requestStanzas}");
        StringBuilder stanzas = new StringBuilder();
        for (DataPowerFileInfo file : this.dataPowerFiles) {
            String base64Content;
            block6: {
                byte[] fileContent;
                block7: {
                    base64Content = null;
                    fileContent = file.getFileData();
                    if (fileContent != null) break block7;
                    File localFile = file.getLocalFile();
                    if (localFile == null) {
                        logger.finer("(): LocalFile is null in file.  This means we're holding it in memory.");
                        break block6;
                    } else {
                        try {
                            logger.finer(() -> LMG.log("(): Converting file '%s' content to Base64.", () -> localFile.getAbsolutePath()));
                            base64Content = FileUtility.readAsBase64(localFile);
                            logger.finer(() -> LMG.log("(): File '%s' successfully converted to Base64.", () -> localFile.getAbsolutePath()));
                            break block6;
                        }
                        catch (IOException e) {
                            logger.severe(() -> LMG.log("(): Error converting file '%s' content to Base64.", () -> localFile.getAbsolutePath()));
                            e.printStackTrace();
                            continue;
                        }
                    }
                }
                byte[] base64Bytes = Base64.encodeBase64(fileContent);
                base64Content = new String(base64Bytes);
            }
            logger.finer(() -> LMG.log("(): Updating", () -> file.getFileName()));
            String fileStanza = requestStanza.replace("${domain.name}", "default");
            String FQFN = this.getFQFN(file);
            fileStanza = fileStanza.replace("${dataPowerFileInfo.name}", FQFN);
            fileStanza = fileStanza.replace(FILE_CONTENT_MARKER, base64Content);
            stanzas.append(fileStanza);
            stanzas.append("\n");
        }
        requestXML = requestXML.replace("${requestStanzas}", stanzas.toString());
        if (logger.getLevel().equals(Level.FINEST)) {
            FinestLogRecord logRecord = new FinestLogRecord(Level.FINEST, this.getAppliance(), this.getDomain(), requestXML);
            logger.log(logRecord);
        }
        AbstractTool.logger.finer("(): Starting");
        return requestXML;
    }

    @Override
    protected String getSOMATemplateFileName() {
        return "UploadFile.xml";
    }

    @Override
    public void commandSucceeded(ManagementCommandStatus commandStatus) {
        if (subscribers != null && !subscribers.isEmpty()) {
            Collection<ManagementCommandSubscriber> subscribers = this.getInstantSubscribers();
            for (ManagementCommandSubscriber subscriber : subscribers) {
                DataPowerFileInfo file = (DataPowerFileInfo)this.dataPowerFiles.get(this.responseIndex);
                commandStatus.setDomain(file.getSourceDomain());
                String commandDescription = String.format("Upload '%s' to '%s'", file.getLocalFile().getAbsolutePath(), file.getAbsolutePath());
                commandStatus.setCommandDescription(commandDescription);
                String statusMessage = String.format("OK", file.getAbsolutePath());
                commandStatus.setResultMessage(statusMessage);
                subscriber.commandSucceeded(commandStatus);
            }
        }
        ++this.responseIndex;
    }

    @Override
    public void commandFailed(ManagementCommandError commandError) {
        if (subscribers != null && !subscribers.isEmpty()) {
            Collection<ManagementCommandSubscriber> subscribers = this.getInstantSubscribers();
            for (ManagementCommandSubscriber subscriber : subscribers) {
                DataPowerFileInfo file = (DataPowerFileInfo)this.dataPowerFiles.get(this.responseIndex);
                commandError.setDomain(file.getSourceDomain());
                String commandDescription = String.format("Upload '%s' to '%s'", file.getLocalFile().getAbsolutePath(), file.getAbsolutePath());
                commandError.setCommandDescription(commandDescription);
                String statusMessage = String.format("Failed.", file.getAbsolutePath());
                commandError.setResultMessage(statusMessage);
                subscriber.commandFailed(commandError);
            }
        }
        ++this.responseIndex;
    }

    private Collection<ManagementCommandSubscriber> getInstantSubscribers() {
        ArrayList<ManagementCommandSubscriber> subscribers = new ArrayList<ManagementCommandSubscriber>();
        if (FileUploader.subscribers != null && !FileUploader.subscribers.isEmpty()) {
            return FileUploader.subscribers.get(this.instant);
        }
        return subscribers;
    }
}

