/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.AdvancedObjectSearchOptions;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.DataPowerObject;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ObjectPropertyDefinition;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.util.DataStructureUtility;
import com.kumbasoft.core.util.RegexUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.script.ScriptException;
import org.openjdk.nashorn.api.scripting.NashornScriptEngine;
import org.openjdk.nashorn.api.scripting.NashornScriptEngineFactory;

public class FindObject
extends AbstractTool {
    private ArrayList<AdvancedObjectSearchOptions> searchOptions;
    private UniqueArrayList<StatusObjectStatus> matchingStatus;
    private UniqueArrayList<DataPowerObject> matchingObjects;
    private final Object processLock = new Object();

    public FindObject(ArrayList<StatusObjectStatus> objectStatus, ArrayList<AdvancedObjectSearchOptions> searchOptions) {
        AbstractTool.logger.finer("(...): Starting.");
        this.searchOptions = searchOptions;
        this.matchingStatus = new UniqueArrayList();
        this.matchingObjects = new UniqueArrayList();
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        HashMap<Appliance, Index<Domain, StatusObjectStatus>> objectsByApplianceDomains = DataStructureUtility.mapByApplianceDomain(objectStatus);
        for (Appliance appliance : objectsByApplianceDomains.keySet()) {
            Index<Domain, StatusObjectStatus> objectsByDomain = objectsByApplianceDomains.get(appliance);
            for (Domain domain : objectsByDomain.getKeys()) {
                ArrayList objects = (ArrayList)objectsByDomain.get(domain);
                AbstractTool.logger.fine(() -> LMG.log("(...): Searching objects from the %s domain of %s.", () -> domain.getName(), () -> appliance.getName()));
                AsynchMethodInvoker ami = new AsynchMethodInvoker((Object)this, "findObjects", (Object)objects);
                mtil.addThread(ami);
            }
        }
        boolean completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("FindObject.FindObject(...)", mtil, objectStatus.size() * KumbaCoreConstants.STARTUP_DELAY, 0);
        if (!completedOnTime) {
            AbstractTool.logger.warning("(...): Not all find object threads completed on time.  Continuing though not all objects may be available.");
        }
        AbstractTool.logger.finer("(...): Done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reflected
    private void findObjects(ArrayList<StatusObjectStatus> objectsToSearch) {
        NashornScriptEngine scriptEngine = (NashornScriptEngine)new NashornScriptEngineFactory().getScriptEngine("ECMAScript");
        AbstractTool.logger.finer("(ArrayList<StatusObjectStatus> objectsToSearch): Starting");
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<DataPowerConfig> configs = configurationManager.getObjects(objectsToSearch);
        ArrayList<DataPowerConfig> matchingConfigs = new ArrayList<DataPowerConfig>();
        ArrayList<StatusObjectStatus> matchingStatus = new ArrayList<StatusObjectStatus>();
        for (DataPowerConfig config : configs) {
            StringBuilder configBuilder = new StringBuilder();
            String configClass = config.getConfigObjectType();
            AbstractTool.logger.finer(() -> LMG.log("(ArrayList<StatusObjectStatus> objectsToSearch): Searching %s", () -> configClass));
            ArrayList<AdvancedObjectSearchOptions> looper = new ArrayList<AdvancedObjectSearchOptions>(this.searchOptions);
            String lastLogicalOperator = "";
            for (AdvancedObjectSearchOptions options : looper) {
                String logicalOperator = options.getLogicalOperator();
                if (logicalOperator == null) {
                    logicalOperator = "AND";
                }
                String matchingExpression = options.getMatchingExpression();
                matchingExpression = RegexUtility.normalizeRegex(matchingExpression);
                Collection<ObjectPropertyDefinition> propertyDefinitions = options.getPropertyDefinitions();
                ArrayList<ObjectPropertyDefinition> propLooper = new ArrayList<ObjectPropertyDefinition>(propertyDefinitions);
                for (ObjectPropertyDefinition objectPropertyDefinition : propLooper) {
                    Class<? extends DataPowerConfig> propertyConfigClass = objectPropertyDefinition.getObjectClass();
                    if (!propertyConfigClass.equals(config.getClass())) continue;
                    String propertyName = objectPropertyDefinition.getPropertyName();
                    Object propertyValue = BeanService.getPropertyValue(config, propertyName);
                    String propertyValueString = propertyValue == null ? "" : String.valueOf(propertyValue);
                    boolean propertyMatches = propertyValueString.matches(matchingExpression);
                    String correctedMatchingExpression = matchingExpression;
                    AbstractTool.logger.finer(() -> LMG.log("(ArrayList<StatusObjectStatus> objectsToSearch): Checking %s in %s as '%s' matches '%s'=%b", () -> propertyName, () -> configClass, () -> propertyValueString, () -> correctedMatchingExpression, () -> propertyMatches));
                    if (configBuilder.length() > 0) {
                        configBuilder.append(lastLogicalOperator.equals("AND") ? " && " : " || ");
                    }
                    configBuilder.append(propertyMatches ? "true" : "false");
                    lastLogicalOperator = logicalOperator;
                }
            }
            String logicClause = configBuilder.toString();
            if (StringUtility.isEmpty(logicClause)) continue;
            AbstractTool.logger.finer(() -> LMG.log("(ArrayList<StatusObjectStatus> objectsToSearch):  Evaluating script: '%s'", () -> logicClause));
            try {
                Boolean result = (Boolean)scriptEngine.eval(logicClause);
                if (result == null) continue;
                AbstractTool.logger.finer(() -> LMG.log("(ArrayList<StatusObjectStatus> objectsToSearch): Object '%s' evaluating '%s' as '%b'", () -> config.getFQON(), () -> logicClause, () -> result));
                if (!result.booleanValue()) continue;
                matchingConfigs.add(config);
                matchingStatus.add(config.getStatus());
            }
            catch (ScriptException e) {
                e.printStackTrace();
            }
        }
        Object object = this.processLock;
        synchronized (object) {
            this.matchingStatus.addAll(matchingStatus);
            this.matchingObjects.addAll(matchingConfigs);
        }
        AbstractTool.logger.finer("(ArrayList<StatusObjectStatus> objectsToSearch): Done");
    }

    public ArrayList<StatusObjectStatus> getMatchingStatus() {
        return this.matchingStatus;
    }

    public ArrayList<DataPowerObject> getMatchingObjects() {
        return this.matchingObjects;
    }
}

