/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.util.Index;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.tools.AbstractDataPowerManagementRequest;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.util.DataStructureUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class GetConfigurations
extends AbstractDataPowerManagementRequest {
    private static final String REQUEST_STANZA = "<dp:request xmlns:dp=\"http://www.datapower.com/schemas/management\" domain=\"${domain.name}\"><dp:get-config class=\"${dataPowerObject.dataPowerClass}\" name=\"${dataPowerObject.name}\" recursive=\"${recursive}\" persisted=\"${persisted}\"/></dp:request>";
    private String requestStanzas;
    private ArrayList<StatusObjectStatus> dataPowerObjects;
    private HashMap<String, Index<String, StatusObjectStatus>> statusMap;
    private final String recursive = "false";
    private final String persisted = "false";
    private ArrayList<DataPowerConfig> dataPowerConfigs;
    private boolean complete;

    public GetConfigurations(Appliance appliance, Domain domain, ArrayList<StatusObjectStatus> dataPowerObjects) {
        super(appliance, domain, String.format("Get Object Configurations %s domain of %s", domain.getName(), appliance.getName()));
        this.dataPowerObjects = dataPowerObjects;
        this.statusMap = DataStructureUtility.mapByTypeAndName(dataPowerObjects);
    }

    public String getRequestStanzas() {
        return this.requestStanzas;
    }

    public void setRequestStanzas(String requestStanzas) {
        this.requestStanzas = requestStanzas;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public ArrayList<StatusObjectStatus> getDataPowerObjects() {
        return this.dataPowerObjects;
    }

    public ArrayList<DataPowerConfig> getDataPowerConfigs() {
        return this.dataPowerConfigs;
    }

    String getRecursive() {
        return "false";
    }

    String getPersisted() {
        return "false";
    }

    @Override
    protected String getRequestMessage() {
        AbstractTool.logger.finer("(): Starting.  Building request stanzas.");
        this.buildRequestStanzas();
        AbstractTool.logger.finer("(): Getting request message.");
        String requestMessage = super.getRequestMessage();
        AbstractTool.logger.finer("(): Done.  Returning request message.");
        return requestMessage;
    }

    private void buildRequestStanzas() {
        AbstractTool.logger.finer(() -> LMG.log("(): Starting for domain '%s'", () -> this.domain.getName()));
        if (CollectionUtility.isEmpty(this.dataPowerObjects)) {
            this.requestStanzas = null;
            AbstractTool.logger.finer(() -> LMG.log("(): Cannot build stanzs because there are no obects in domain '%s'.  Done", () -> this.domain.getName()));
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (StatusObjectStatus object : this.dataPowerObjects) {
            AbstractTool.logger.finer(() -> LMG.log("(): Adding object to request stanza:\n\tDomain: '%s'\n\tClass: '%s'\n\tName: '%s'\n\tRecursive: %b\n\tPersisted: %b", () -> this.domain.getName(), () -> object.getDataPowerClass(), () -> object.getName(), () -> "false", () -> "false"));
            String requestStanza = REQUEST_STANZA.replace("${domain.name}", this.domain.getName());
            requestStanza = requestStanza.replace("${dataPowerObject.dataPowerClass}", object.getDataPowerClass());
            requestStanza = requestStanza.replace("${dataPowerObject.name}", object.getName());
            requestStanza = requestStanza.replace("${recursive}", "false");
            requestStanza = requestStanza.replace("${persisted}", "false");
            sb.append(requestStanza);
            sb.append("\n");
        }
        this.requestStanzas = sb.toString();
        AbstractTool.logger.finer(() -> LMG.log("(): Dont for domain '%s'", () -> this.domain.getName()));
    }

    @Override
    protected boolean processResultDocument(XMLElement rootElement) {
        AbstractTool.logger.finer("(XMLElement rootElement): Starting");
        boolean isValid = super.processResultDocument(rootElement);
        if (isValid) {
            this.dataPowerConfigs = CollectionUtility.createOrClear(this.dataPowerConfigs);
            Collection<XMLElement> dpConfigNodes = rootElement.getNodes("//dp:config");
            AbstractTool.logger.finer(() -> LMG.log("(XMLElement rootElement): Processing %d config nodes.", () -> dpConfigNodes.size()));
            for (XMLElement configNode : dpConfigNodes) {
                Collection<XMLElement> objectNodes = configNode.getNodes();
                for (XMLElement objectNode : objectNodes) {
                    JMBean configObject = (JMBean)ConfigurationManager.xmlToObject(this.getAppliance(), this.getDomain(), objectNode);
                    BeanService.setPropertyValue(configObject, "status", this.getObjectStatus(configObject));
                    this.dataPowerConfigs.add((DataPowerConfig)configObject);
                }
            }
        }
        this.complete = true;
        AbstractTool.logger.finer("(XMLElement rootElement): Done");
        return isValid;
    }

    private StatusObjectStatus getObjectStatus(JMBean configObject) {
        AbstractTool.logger.finer("(configObject): Starting.");
        String type = (String)BeanService.getPropertyValue(configObject, "configObjectType");
        Index<String, StatusObjectStatus> objectsByType = this.statusMap.get(type);
        AbstractTool.logger.finer(() -> LMG.log("(configObject):  Got %d objects by type '%s", () -> objectsByType.totalSize(), () -> type));
        String name = (String)BeanService.getPropertyValue(configObject, "name");
        ArrayList objectsByName = (ArrayList)objectsByType.get(name);
        AbstractTool.logger.finer(() -> LMG.log("(configObject):  Got %d objects by name '%s", () -> objectsByName.size(), () -> name));
        StatusObjectStatus status = (StatusObjectStatus)objectsByName.get(0);
        AbstractTool.logger.finer(() -> LMG.log("(configObject): Done.  Returning status for '%s')", () -> status.getFQON()));
        return status;
    }

    @Override
    protected String getSOMATemplateFileName() {
        return "GetObjectConfigurations.xml";
    }
}

