/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.tools.AbstractDataPowerManagementRequest;
import com.kumbasoft.core.util.FileUtility;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class ImportConfiguration
extends AbstractDataPowerManagementRequest {
    private String fileType;
    private boolean overWriteFiles;
    private boolean overWriteObjects;
    private String fileName;
    private String deploymentPolicy;
    private String deploymentPolicyVariables;
    private boolean dryRun;
    private String fileContent;

    public ImportConfiguration(Appliance appliance, Domain domain, String fileType, boolean overWriteFiles, boolean overWriteObjects, String fileName) {
        super(appliance, domain, "Import Configuration from " + fileName);
        this.setFileName(fileName);
        this.setFileType(fileType);
        this.setOverWriteFiles(overWriteFiles);
        this.setOverWriteObjects(overWriteObjects);
    }

    public ImportConfiguration(Appliance appliance, Domain domain, String fileType, boolean overWriteFiles, boolean overWriteObjects, String fileName, String deploymentPolicy) {
        this(appliance, domain, fileType, overWriteFiles, overWriteObjects, fileName);
        this.setDeploymentPolicy(deploymentPolicy);
    }

    public ImportConfiguration(Appliance appliance, Domain domain, String fileType, boolean overWriteFiles, boolean overWriteObjects, String fileName, String deploymentPolicy, String deploymentPolicyVariables) {
        this(appliance, domain, fileType, overWriteFiles, overWriteObjects, fileName, deploymentPolicy);
        this.setDeploymentPolicyVariables(deploymentPolicyVariables);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        logger.finer(() -> LMG.log("(fileName='%s'): Starting", () -> fileName));
        this.fileName = fileName;
        try {
            logger.finer(() -> LMG.log("(fileName='%s'): Reading File as Base64.", () -> fileName));
            this.fileContent = FileUtility.readAsBase64(this.fileName);
        }
        catch (FileNotFoundException e) {
            logger.severe(() -> LMG.log("(fileName='%s'): File not found.", () -> fileName));
            ManagementCommandError commandError = new ManagementCommandError(this.getAppliance(), this.getDomain(), "Import Configuration", this, "Source file " + this.fileName + " not found");
            this.notifyManagementCommandSubscribers(commandError);
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.severe(() -> LMG.log("(fileName='%s'): Error reading file.", () -> fileName));
            ManagementCommandError commandError = new ManagementCommandError(this.getAppliance(), this.getDomain(), "Import Configuration", this, "Error reading source file " + this.fileName);
            this.notifyManagementCommandSubscribers(commandError);
            e.printStackTrace();
        }
        logger.finer(() -> LMG.log("(fileName='%s'): Done", () -> fileName));
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        if (fileType == null) {
            int dotPos = this.fileName.indexOf(46);
            fileType = this.fileName.substring(dotPos + 1).toUpperCase();
        } else {
            fileType = fileType.toUpperCase();
        }
        if (fileType.equals("XCFG")) {
            fileType = "XML";
        }
        switch (fileType) {
            case "XML": 
            case "ZIP": {
                this.fileType = fileType;
                break;
            }
            default: {
                throw new IllegalArgumentException("ImportConfiguration.setFileType(fileType=\"" + fileType + "\"):  The given file type must be either one of 'ZIP' or 'XML'");
            }
        }
    }

    public boolean isOverWriteFiles() {
        return this.overWriteFiles;
    }

    public void setOverWriteFiles(boolean overWriteFiles) {
        this.overWriteFiles = overWriteFiles;
    }

    public boolean isOverWriteObjects() {
        return this.overWriteObjects;
    }

    public void setOverWriteObjects(boolean overWriteObjects) {
        this.overWriteObjects = overWriteObjects;
    }

    public String getDeploymentPolicy() {
        return this.deploymentPolicy;
    }

    public void setDeploymentPolicy(String deploymentPolicy) {
        this.deploymentPolicy = deploymentPolicy;
    }

    public String getDeploymentPolicyVariables() {
        return this.deploymentPolicyVariables;
    }

    public void setDeploymentPolicyVariables(String deploymentPolicyVariables) {
        this.deploymentPolicyVariables = deploymentPolicyVariables;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public String getFileContent() {
        return this.fileContent;
    }

    public void setFileContent(String fileContent) {
        this.fileContent = fileContent;
    }

    @Override
    protected boolean processResultDocument(XMLElement rootElement) {
        block32: {
            block30: {
                ArrayList resultNodes = (ArrayList)rootElement.getNodes("//dp:result");
                for (XMLElement resultNode : resultNodes) {
                    if (!resultNode.getValue().equals("ERROR")) continue;
                    String errorMessage = String.format("There was an unspecified error importing %s", this.getFileName());
                    ManagementCommandError commandError = new ManagementCommandError(this.getAppliance(), this.getDomain(), "Import Configuration Error", this, errorMessage);
                    this.notifyManagementCommandSubscribers(commandError);
                    return false;
                }
                if (!this.dryRun) break block30;
                Collection<XMLElement> importedObjectsList = rootElement.getNodes("//imported-objects");
                ArrayList<XMLElement> importedObjects = new ArrayList<XMLElement>();
                for (XMLElement importedObjectElement : importedObjectsList) {
                    importedObjects.addAll(importedObjectElement.getNodes("object"));
                }
                for (XMLElement importNode : importedObjects) {
                    Object overwriteStatus;
                    String objectClass = importNode.getAttributeValue("class");
                    Iterator name = importNode.getAttributeValue("name");
                    String overwrite = importNode.getAttributeValue("overwrite");
                    String status = importNode.getAttributeValue("status");
                    Object object = overwriteStatus = overwrite.equals("on") ? "will" : "will not";
                    if (status.equals("filtered")) {
                        status = "is filtered";
                    } else if (status.equals("new")) {
                        overwriteStatus = (String)overwriteStatus + " be created";
                        status = "is new";
                    } else {
                        overwriteStatus = (String)overwriteStatus + " be overwritten";
                    }
                    String responseMessage = String.format("%s %s %s because object %s", objectClass, name, overwriteStatus, status);
                    ManagementCommandStatus commandStatus = new ManagementCommandStatus(this.getAppliance(), this.getDomain(), "Import Configuration - Dry Run", this, responseMessage);
                    this.notifyManagementCommandSubscribers(commandStatus);
                }
                Collection<XMLElement> importedFilesList = rootElement.getNodes("//imported-files");
                ArrayList<XMLElement> importedFiles = new ArrayList<XMLElement>();
                for (XMLElement importedFileElement : importedFilesList) {
                    importedFiles.addAll(importedFileElement.getNodes("file"));
                }
                for (XMLElement importFile : importedFiles) {
                    String name = importFile.getAttributeValue("name");
                    String overwrite = importFile.getAttributeValue("overwrite");
                    String status = importFile.getAttributeValue("status");
                    String overwriteStatus = overwrite.equals("on") ? "will" : "will not";
                    String statusMessage = null;
                    switch (status) {
                        case "same": {
                            statusMessage = "they are the same";
                            break;
                        }
                        case "internal": {
                            statusMessage = "they are internal";
                            break;
                        }
                        case "missing-key": {
                            statusMessage = "the key is missing";
                            break;
                        }
                        case "missing-file": {
                            statusMessage = "the file is missing";
                            break;
                        }
                        default: {
                            statusMessage = status;
                        }
                    }
                    String responseMessage = String.format("File %s %s be overritten because %s.", name, overwriteStatus, statusMessage);
                    ManagementCommandStatus commandStatus = new ManagementCommandStatus(this.getAppliance(), this.getDomain(), "Import Configuration - Dry Run", this, responseMessage);
                    this.notifyManagementCommandSubscribers(commandStatus);
                }
                break block32;
            }
            Collection<XMLElement> importResults = rootElement.getNodes("//cfg-result");
            for (XMLElement resultNode : importResults) {
                ManagementCommandStatus commandStatus;
                String responseMessage;
                String objectClass = resultNode.getAttributeValue("class");
                String objectName = resultNode.getAttributeValue("name");
                String status = resultNode.getAttributeValue("status");
                if (status.equals("SUCCESS")) {
                    responseMessage = String.format("%s of %s imported successfully", objectName, objectClass);
                    commandStatus = new ManagementCommandStatus(this.getAppliance(), this.getDomain(), "Import Configuration", this, responseMessage);
                    this.notifyManagementCommandSubscribers(commandStatus);
                    continue;
                }
                if (status.equals("skipped")) {
                    responseMessage = String.format("%s of %s filtered by deployment policy", objectName, objectClass);
                    commandStatus = new ManagementCommandStatus(this.getAppliance(), this.getDomain(), "Import Configuration", this, responseMessage);
                    this.notifyManagementCommandSubscribers(commandStatus);
                    continue;
                }
                String errorMessage = String.format("%s of %s failed to import properly", objectName, objectClass);
                ManagementCommandError commandError = new ManagementCommandError(this.getAppliance(), this.getDomain(), "Import Configuration", this, errorMessage);
                this.notifyManagementCommandSubscribers(commandError);
            }
            Collection<XMLElement> fileCopyNodes = rootElement.getNodes("//file-copy-log");
            ArrayList<XMLElement> fileResultNodes = new ArrayList<XMLElement>();
            for (XMLElement fileCopyNode : fileCopyNodes) {
                fileResultNodes.addAll(fileCopyNode.getNodes("file-result"));
            }
            for (XMLElement fileNode : fileResultNodes) {
                String fileName = fileNode.getAttributeValue("name");
                String result = fileNode.getAttributeValue("result");
                XMLElement reasonElement = fileNode.getNode("reason");
                String reason = reasonElement.getValue();
                String responseMessage = String.format("File %s %s.  %s", fileName, result, reason);
                ManagementCommandStatus commandStatus = new ManagementCommandStatus(this.getAppliance(), this.getDomain(), "Import Configuration", this, responseMessage);
                this.notifyManagementCommandSubscribers(commandStatus);
            }
        }
        return true;
    }
}

