/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.lang.Null;
import com.jmorgan.lang.StackTrace;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.DateTimeException;
import com.jmorgan.util.StringIndexer;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.AbstractLogEntry;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.AuditLogEntry;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.LogEntry;
import com.kumbasoft.core.beans.LogEntryNumberer;
import com.kumbasoft.core.tools.AbstractTool;
import java.util.ArrayList;

public class LogParser
extends AbstractTool {
    private Appliance appliance;
    private Domain domain;
    private String logTargetName;
    private String baseFileName;
    private long lineNumber;
    private LogEntryNumberer<Null> defaultLineNumberer;
    private LogEntryNumberer<String> auditLineNumberer;
    private LogEntryNumberer<Long> systemLineNumberer;

    public LogParser(Appliance appliance, Domain domain, String logTargetName, String baseFileName) {
        AbstractTool.logger.finer(() -> LMG.log("(Appliance appliance=%s, Domain domain=%s, String logTargetName=%s, String baseFileName=%s): Starting", () -> appliance.getName(), () -> domain.getName(), () -> logTargetName, () -> baseFileName));
        this.setAppliance(appliance);
        this.setDomain(domain);
        this.setLogTargetName(logTargetName);
        this.setBaseFileName(baseFileName);
    }

    public Appliance getAppliance() {
        return this.appliance;
    }

    public void setAppliance(Appliance appliance) {
        this.appliance = appliance;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public String getLogTargetName() {
        return this.logTargetName;
    }

    public void setLogTargetName(String logTargetName) {
        this.logTargetName = logTargetName;
    }

    public String getBaseFileName() {
        return this.baseFileName;
    }

    public void setBaseFileName(String baseFileName) {
        switch (this.baseFileName = baseFileName) {
            case "audit:/audit-log": 
            case "AuditLog.txt": {
                this.auditLineNumberer = new LogEntryNumberer();
                break;
            }
            case "XACTLog.txt": 
            case "DiagnosticLog.txt": 
            case "CompilerLog.txt": 
            case "logtemp:///diag-log": 
            case "logtemp:///compile-log": 
            case "CLILog.txt": 
            case "UsageLog.txt": 
            case "logtemp:///xact-log": 
            case "logtemp:///startup-errors": 
            case "logtemp:///usage-log": 
            case "logtemp:///cli-log": {
                this.defaultLineNumberer = new LogEntryNumberer();
                break;
            }
            default: {
                this.systemLineNumberer = new LogEntryNumberer();
            }
        }
    }

    public Domain getDomain(String logEntry) {
        AbstractTool.logger.finest(() -> LMG.log("(String logEntry): %s", () -> logEntry));
        int domainStart = logEntry.indexOf("domain=");
        if (domainStart < 0) {
            return null;
        }
        int domainEnd = logEntry.indexOf("'", domainStart += 8);
        String domainName = logEntry.substring(domainStart, domainEnd);
        AbstractTool.logger.finer(() -> LMG.log("(String logEntry): domainName in log: %s", () -> domainName));
        Domain domain = this.appliance.getDomain(domainName);
        return domain;
    }

    public void processLogEntries(String[] logEntries, ArrayList<AbstractLogEntry> logObjects) {
        AbstractTool.logger.finer("(String[] logEntries, ArrayList<AbstractLogEntry> logObjects): Starting");
        String[] stringArray = logEntries;
        int n = logEntries.length;
        int n2 = 0;
        while (n2 < n) {
            String logEntry = stringArray[n2];
            ++this.lineNumber;
            if (logEntry.length() >= 100) {
                this.processLogEntry(logEntry, logObjects);
            }
            ++n2;
        }
        AbstractTool.logger.finer("(String[] logEntries, ArrayList<AbstractLogEntry> logObjects): Done");
    }

    public void processLogEntry(String logEntry, ArrayList<AbstractLogEntry> logObjects) {
        block38: {
            block37: {
                boolean isXML;
                AbstractTool.logger.finer("(String logEntry, ArrayList<AbstractLogEntry> logObjects): Starting");
                boolean bl = isXML = logEntry.trim().charAt(0) == '<';
                if (!isXML) break block37;
                AbstractTool.logger.finer("(String logEntry, ArrayList<AbstractLogEntry> logObjects): Log entry is XML.");
                this.parseXML(logEntry, logObjects);
                break block38;
            }
            logger.finer(() -> LMG.log("(String logEntry, ArrayList<AbstractLogEntry> logObjects):  Log Entry is text.  Base File Name: %s", () -> this.baseFileName));
            switch (this.baseFileName) {
                case "audit:/audit-log": 
                case "AuditLog.txt": {
                    AbstractTool.logger.finer("(String logEntry, ArrayList<AbstractLogEntry> logObjects): Log Entry is from Audit Log.");
                    this.parseAuditText(logEntry, logObjects);
                    break;
                }
                case "CLILog.txt": 
                case "logtemp:///cli-log": {
                    AbstractTool.logger.finer("(String logEntry, ArrayList<AbstractLogEntry> logObjects): Log Entry is from CLI Log.");
                    this.parseCLIText(logEntry, logObjects);
                    break;
                }
                case "CompilerLog.txt": 
                case "logtemp:///compile-log": {
                    AbstractTool.logger.finer("(String logEntry, ArrayList<AbstractLogEntry> logObjects): Log Entry is from Compile Log.");
                    this.parseCompileText(logEntry, logObjects);
                    break;
                }
                case "DiagnosticLog.txt": 
                case "logtemp:///diag-log": {
                    AbstractTool.logger.finer("(String logEntry, ArrayList<AbstractLogEntry> logObjects): Log Entry is from Diag Log.");
                    this.parseDiagText(logEntry, logObjects);
                    break;
                }
                case "UsageLog.txt": 
                case "logtemp:///usage-log": {
                    AbstractTool.logger.finer("(String logEntry, ArrayList<AbstractLogEntry> logObjects): Log Entry is from Usage Log.");
                    this.parseUsageText(logEntry, logObjects);
                    break;
                }
                case "XACTLog.txt": 
                case "logtemp:///xact-log": {
                    AbstractTool.logger.finer("(String logEntry, ArrayList<AbstractLogEntry> logObjects): Log Entry is from Transaction Log.");
                    this.parseXactText(logEntry, logObjects);
                    break;
                }
                case "logtemp:///startup-errors": {
                    AbstractTool.logger.finer("(String logEntry, ArrayList<AbstractLogEntry> logObjects): Log Entry is from Startup Error Log.");
                    this.parseStartupErrorsText(logEntry, logObjects);
                    break;
                }
                default: {
                    this.parseText(logEntry, logObjects);
                }
            }
        }
        AbstractTool.logger.finer("(String logEntry, ArrayList<AbstractLogEntry> logObjects): Done");
    }

    public void parseXML(String logEntry, ArrayList<AbstractLogEntry> logObjects) {
        logger.finest(() -> LMG.log("(logEntry, logObjects): Log Entry:\n\t\t", () -> logEntry));
        Domain domain = this.getDomain(logEntry);
        String time = LogParser.extractElementContents(logEntry, "date-time");
        if (StringUtility.isEmpty(time)) {
            logger.fine("(logEntry, logObjects):  Invalid log entry.  Skipping.");
            return;
        }
        DateTime logTime = null;
        try {
            logTime = new DateTime(time.trim());
        }
        catch (DateTimeException e) {
            logger.fine(() -> LMG.log("(logEntry, logObjects):  Time could not be parsed from '%s'.", () -> time));
        }
        String type = LogParser.extractElementContents(logEntry, "type");
        String objectClass = LogParser.extractElementContents(logEntry, "class");
        String objectName = LogParser.extractElementContents(logEntry, "object");
        String transactionID = LogParser.extractElementContents(logEntry, "transaction");
        String globalTransactionID = LogParser.extractElementContents(logEntry, "gtid");
        String client = LogParser.extractElementContents(logEntry, "client");
        String errorCode = LogParser.extractElementContents(logEntry, "code");
        String logLevel = LogParser.extractElementContents(logEntry, "level");
        String message = LogParser.extractElementContents(logEntry, "message");
        long lineNumber = this.systemLineNumberer.getNextLineNumber(1L, Long.parseLong(transactionID));
        logger.fine(() -> LMG.log("(logEntry, logObjects):  Adding entry for line number %d", () -> lineNumber));
        LogEntry logObject = new LogEntry(this.appliance, domain, this.logTargetName, lineNumber, logTime, type, Long.parseLong(transactionID), globalTransactionID, objectClass, objectName, client, message);
        logObject.setErrorCode(errorCode);
        logObject.setLogLevel(logLevel);
        logObjects.add(logObject);
        logger.finer("(logEntry, logObjects):  Done.");
    }

    public static String extractElementContents(String source, String element) {
        logger.finer(() -> LMG.log("(source, element='%s'): Starting", () -> element));
        if (StringUtility.isEmpty(source) || StringUtility.isEmpty(element)) {
            logger.fine(() -> LMG.log("(source, element='%s'): Source or element is empty. Returning null.", () -> element));
            return null;
        }
        String startElement = String.format("<%s>", element);
        if (!source.contains(startElement)) {
            logger.finer(() -> LMG.log("(source, element='%s'): Element potentially contains attributes.  Adjusting.", () -> element));
            startElement = String.format("<%s", element);
            int startElementPosition = source.indexOf(startElement);
            if (startElementPosition == -1) {
                logger.finer(() -> LMG.log("(source, element='%s'): Element not found. Returning '%s'", () -> element, () -> source));
                return source;
            }
            int endElementMarker = source.indexOf(62, startElementPosition);
            if (endElementMarker == -1 || endElementMarker >= source.length()) {
                endElementMarker = source.length() - 1;
                logger.fine(() -> LMG.log("(source, element='%s'): End of opening element delimiter '>' not found.  Why?  Assuming it to be end of source.", () -> element));
            }
            startElement = source.substring(startElementPosition, endElementMarker + 1);
        }
        String endElement = String.format("</%s>", element);
        String elementContents = StringUtility.getMarkupContent(source, startElement, endElement);
        logger.finer(() -> LMG.log("(source, element='%s'): Done. Returning '%s'", () -> element, () -> elementContents));
        return elementContents;
    }

    public void parseText(String logEntry, ArrayList<AbstractLogEntry> logObjects) {
        logger.finer("(logEntry, logObjects): Starting");
        int[] lineFeedOffsets = StringIndexer.indexCharacter(logEntry, '\n');
        AbstractLogEntry lastLogEntry = null;
        Object message = "";
        int i = 0;
        int lastOffset = -1;
        while (i < lineFeedOffsets.length) {
            String logLine = logEntry.substring(lastOffset + 1, lineFeedOffsets[i]);
            String presentedLogLine = logLine = StringUtility.removeAll(logLine, "\r\n");
            if (logLine.contains("Log has been archived successfully")) {
                logger.fine("(logEntry, logObjects): Skipping archived message.");
            } else {
                int startPos = logLine.indexOf(" [");
                if (startPos < 0) {
                    logger.fine("(logEntry, logObjects): Log line does not appear to be normally parseable.  Skipping.");
                } else {
                    String time = LogParser.getSubString(0, startPos, logLine);
                    DateTime logTime = null;
                    boolean timeMatched = false;
                    try {
                        logTime = new DateTime(time.trim());
                        timeMatched = true;
                    }
                    catch (DateTimeException e) {
                        logger.fine("(logEntry, logObjects): Timestamp not present.  Is this a continuation from the previous line?");
                    }
                    if (!timeMatched) {
                        message = (String)message + logLine;
                        if (lastLogEntry != null) {
                            lastLogEntry.setMessage((String)message);
                        }
                        logger.fine("(logEntry, logObjects): Line continuation detected.  Appending and moving on.");
                    } else {
                        startPos = logLine.indexOf(91);
                        int endPos = logLine.indexOf(93, startPos);
                        String domainName = LogParser.getSubString(startPos + 1, endPos, logLine);
                        String code = "";
                        if (StringUtility.isEmpty(domainName)) {
                            domainName = this.domain.getName();
                        } else if (domainName.startsWith("0x")) {
                            code = domainName;
                            domainName = this.domain.getName();
                        } else {
                            startPos = logLine.indexOf(91, endPos);
                            endPos = logLine.indexOf(93, startPos);
                            code = LogParser.getSubString(startPos + 1, endPos, logLine);
                        }
                        startPos = logLine.indexOf(91, endPos);
                        endPos = logLine.indexOf(93, startPos);
                        String type = LogParser.getSubString(startPos + 1, endPos, logLine);
                        startPos = logLine.indexOf(91, endPos);
                        endPos = logLine.indexOf(93, startPos);
                        String logLevel = LogParser.getSubString(startPos + 1, endPos, logLine);
                        int nextColon = logLine.indexOf(58, endPos);
                        int nextParen = logLine.indexOf(40, endPos);
                        String objectClass = "";
                        String objectName = "";
                        if (nextParen > endPos && nextColon > nextParen) {
                            startPos = logLine.indexOf(32, endPos) + 1;
                            endPos = logLine.indexOf(40, startPos);
                            objectClass = LogParser.getSubString(startPos, endPos, logLine);
                            startPos = endPos;
                            endPos = logLine.indexOf(41, startPos);
                            objectName = LogParser.getSubString(startPos + 1, endPos, logLine);
                        }
                        startPos = logLine.indexOf("tid(");
                        long transactionID = 0L;
                        if (startPos > 0) {
                            endPos = logLine.indexOf(41, startPos);
                            String strTx = LogParser.getSubString(startPos + 4, endPos, logLine);
                            if (!strTx.matches("\\d+")) {
                                logger.severe(() -> LMG.log("Error extracting transaction ID:\n\t%s\nIn:\n\t%s\n", () -> strTx, () -> presentedLogLine));
                            } else {
                                transactionID = Long.parseLong(strTx);
                            }
                        }
                        int gtidIndex = logLine.indexOf("gtid(");
                        String client = "";
                        startPos = logLine.indexOf(91, endPos);
                        if (startPos > 0 && startPos < gtidIndex) {
                            endPos = logLine.indexOf(93, startPos);
                            client = LogParser.getSubString(startPos + 1, endPos, logLine);
                            if (client.matches("(request|response|lbhealth|scheduled|error)")) {
                                client = "";
                            } else if (!client.matches("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}")) {
                                String logClient = client = "";
                                logger.severe(() -> LMG.log("Error extracting client:\n\t%s\nIn:\n\t%s\n", () -> logClient, () -> presentedLogLine));
                            }
                        }
                        startPos = gtidIndex;
                        String globalTransactionID = "";
                        if (startPos > 0 && !(globalTransactionID = LogParser.getSubString(startPos + 5, endPos = logLine.indexOf(41, startPos), logLine)).matches("[\\da-f]+")) {
                            String GTID = globalTransactionID;
                            logger.severe(() -> LMG.log("Error extracting global transaction ID:\n\t%s\nIn:\n\t%s\n", () -> GTID, () -> presentedLogLine));
                        }
                        logger.finer("(logEntry, logObjects): Extracting message");
                        endPos = logLine.indexOf(58, endPos);
                        startPos = logLine.indexOf(32, endPos) + 1;
                        message = logLine.substring(startPos);
                        Domain domain = this.appliance.getDomain(domainName);
                        long lineNumber = this.systemLineNumberer.getNextLineNumber(1L, transactionID);
                        logger.finer(() -> LMG.log("(logEntry, logObjects): Adding new logging entry for line number %d", () -> lineNumber));
                        LogEntry logObject = new LogEntry(this.appliance, domain, this.logTargetName, lineNumber, logTime, type, transactionID, globalTransactionID, objectClass, objectName, client, (String)message);
                        logObject.setErrorCode(code);
                        logObject.setLogLevel(logLevel);
                        logObjects.add(logObject);
                        lastLogEntry = logObject;
                    }
                }
            }
            lastOffset = lineFeedOffsets[i];
            ++i;
        }
        logger.finer("(logEntry, logObjects): Done");
    }

    public void parseStartupErrorsText(String logEntry, ArrayList<AbstractLogEntry> logObjects) {
        logger.finer("(logEntry, logObjects): Starting");
        String[] lines = logEntry.split("\r\n");
        logger.finer(() -> LMG.log("(logEntry, logObjects): Log entry spans %d lines.", () -> lines.length));
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.contains("Log has been archived successfully")) {
                logger.finer("(logEntry, logObjects): Ingnoring log archive message.");
            } else {
                logger.finer("(logEntry, logObjects): Extracting Date");
                int bracketStart = line.indexOf(91);
                String logDateStr = LogParser.getSubString(0, bracketStart, line);
                DateTime logDate = new DateTime(logDateStr);
                logger.finer("(logEntry, logObjects): Extracting Error Code");
                int bracketEnd = line.indexOf(93);
                String errorCode = LogParser.getSubString(bracketStart + 1, bracketEnd, line);
                logger.finer("(logEntry, logObjects): Extracting Log Category");
                bracketStart = line.indexOf(91, bracketEnd);
                bracketEnd = line.indexOf(93, bracketStart);
                String logCategory = LogParser.getSubString(bracketStart + 1, bracketEnd, line);
                logger.finer("(logEntry, logObjects): Extracting Log Level");
                bracketStart = line.indexOf(91, bracketEnd);
                bracketEnd = line.indexOf(93, bracketStart);
                String logLevel = LogParser.getSubString(bracketStart + 1, bracketEnd, line);
                int tidStart = line.indexOf(": tid(", bracketEnd) + 6;
                long transactionID = 0L;
                if (tidStart > 5) {
                    logger.finer("(logEntry, logObjects): Extracting Transaction ID");
                    int tidEnd = line.indexOf(41, tidStart);
                    String txID = LogParser.getSubString(tidStart, tidEnd, line);
                    transactionID = Long.parseLong(txID);
                }
                String objectType = "";
                String objectName = "";
                if (line.charAt(bracketEnd += 2) != ':') {
                    logger.finer("(logEntry, logObjects): Extracting Object type and name");
                    int objectNameBegin = line.indexOf(40, bracketEnd);
                    int objectNameEnd = line.indexOf(41, objectNameBegin);
                    objectType = LogParser.getSubString(bracketEnd, objectNameBegin, line);
                    objectName = LogParser.getSubString(objectNameBegin + 1, objectNameEnd, line);
                }
                logger.finer("(logEntry, logObjects): Extracting Message");
                int messageDelimiter = line.lastIndexOf(": ") + 2;
                String message = line.substring(messageDelimiter);
                logger.finer("(logEntry, logObjects): Adding log entry");
                LogEntry logObject = new LogEntry(this.appliance, this.appliance.getDomain("default"), this.logTargetName, this.lineNumber, logDate, logCategory, transactionID, "", objectType, objectName, "", message);
                logObject.setLogLevel(logLevel);
                logObject.setErrorCode(errorCode);
                logObjects.add(logObject);
            }
            ++n2;
        }
        logger.finer("(logEntry, logObjects): Done");
    }

    public void parseXactText(String logEntry, ArrayList<AbstractLogEntry> logObjects) {
        logger.finer("(logEntry, logObjects): Starting.");
        this.parseCommonTextFormat(logEntry, logObjects);
        logger.finer("(logEntry, logObjects): Done.");
    }

    public void parseUsageText(String logEntry, ArrayList<AbstractLogEntry> logObjects) {
        logger.finer("(logEntry, logObjects): Starting.");
        this.parseCommonTextFormat(logEntry, logObjects);
        logger.finer("(logEntry, logObjects): Done.");
    }

    public void parseDiagText(String logEntry, ArrayList<AbstractLogEntry> logObjects) {
        logger.finer("(logEntry, logObjects): Starting.");
        this.parseCommonTextFormat(logEntry, logObjects);
        logger.finer("(logEntry, logObjects): Done.");
    }

    public void parseCompileText(String logEntry, ArrayList<AbstractLogEntry> logObjects) {
        logger.finer("(logEntry, logObjects): Starting.");
        this.parseCommonTextFormat(logEntry, logObjects);
        logger.finer("(logEntry, logObjects): Done.");
    }

    public void parseCLIText(String logEntry, ArrayList<AbstractLogEntry> logObjects) {
        logger.finer("(logEntry, logObjects): Starting.");
        this.parseCommonTextFormat(logEntry, logObjects);
        logger.finer("(logEntry, logObjects): Done.");
    }

    public void parseAuditText(String logEntry, ArrayList<AbstractLogEntry> logObjects) {
        logger.finer("(logEntry, logObjects): Starting.");
        String[] lines = logEntry.split("\n");
        logger.finer(() -> LMG.log("(logEntry, logObjects): Log entry spans %d lines.", () -> lines.length));
        int beginIndex = 0;
        int endIndex = -1;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line != null) {
                line = line.trim();
                endIndex = line.indexOf(32);
                int fractionPoint = line.indexOf(46);
                DateTime time = new DateTime(line.substring(beginIndex, fractionPoint));
                beginIndex = line.indexOf(91, endIndex) + 1;
                endIndex = line.indexOf(93, beginIndex);
                String logType = line.substring(beginIndex, endIndex);
                beginIndex = endIndex + 2;
                endIndex = line.indexOf(93, beginIndex);
                String auditResult = line.substring(beginIndex, endIndex);
                beginIndex = endIndex + 2;
                endIndex = line.indexOf(93, beginIndex);
                String errorCode = line.substring(beginIndex, endIndex);
                beginIndex = line.indexOf(40, endIndex);
                String user = "";
                String auditDomain = "";
                String authenticationType = "";
                String userIP = "";
                if (beginIndex == -1) {
                    beginIndex = line.indexOf(32, endIndex) + 1;
                } else {
                    endIndex = line.indexOf(41, beginIndex);
                    String[] auditEffects = line.substring(beginIndex + 1, endIndex).split(":");
                    user = auditEffects[0];
                    auditDomain = auditEffects[1];
                    authenticationType = auditEffects[2];
                    userIP = auditEffects[3];
                    beginIndex = line.indexOf(58, endIndex) + 2;
                }
                String message = line.substring(beginIndex);
                Domain actualDomain = StringUtility.isEmpty(auditDomain) ? this.domain : this.appliance.getDomain(auditDomain);
                long lineNumber = this.auditLineNumberer.getNextLineNumber(this.lineNumber, user);
                logger.finer(() -> LMG.log("(logEntry, logObjects): Creating audit log entry for line number %d.", () -> lineNumber));
                AuditLogEntry auditLogEntry = new AuditLogEntry(this.appliance, actualDomain, lineNumber, time, user, logType, auditResult, authenticationType, userIP, errorCode, message);
                logObjects.add(auditLogEntry);
                beginIndex = 0;
                endIndex = -1;
            }
            ++n2;
        }
        logger.finer("(logEntry, logObjects): Done.");
    }

    private void parseCommonTextFormat(String logEntry, ArrayList<AbstractLogEntry> logObjects) {
        logger.finer("(logEntry, logObjects): Starting.");
        String lineSplitString = null;
        lineSplitString = logEntry.contains("\r\n") ? "\r\n" : "\n";
        String[] lines = logEntry.split(lineSplitString);
        logger.finer(() -> LMG.log("(logEntry, logObjects): Log entry spans %d lines.", () -> lines.length));
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            ++this.lineNumber;
            if (line.contains("Log has been archived successfully")) {
                logger.fine("(logEntry, logObjects): Skipping archive success message");
            } else {
                Object message;
                String[] elements = line.split(",");
                logger.finer(() -> LMG.log("(logEntry, logObjects): Line %d has %d elements.", () -> this.lineNumber, () -> elements.length));
                int unk1 = Integer.parseInt(elements[0]);
                DateTime time = elements.length > 1 ? new DateTime(elements[1]) : new DateTime();
                String domainName = elements.length > 2 ? elements[2] : "";
                String logCategory = elements.length > 3 ? elements[3] : "";
                String logLevel = elements.length > 4 ? elements[4] : "";
                String cliType = elements.length > 5 ? elements[5] : "";
                String objectName = elements.length > 6 ? elements[6] : "";
                long transactionID = elements.length > 7 ? Long.parseLong(elements[7]) : 0L;
                String globalTransactionID = elements.length < 9 || elements[8].trim().length() == 0 ? "" : elements[8];
                String clientIP = elements.length > 9 ? elements[9] : "";
                String errorCode = elements.length > 10 ? elements[10] : "";
                String resourceName = elements.length > 11 ? elements[11] : "";
                String transactionDirection = elements.length > 12 ? elements[12] : "";
                Object object = message = elements.length > 13 ? elements[13].trim() : elements[0];
                if (StringUtility.isEmpty((String)message)) {
                    message = "";
                } else if (((String)message).charAt(0) == '\"') {
                    message = ((String)message).substring(1);
                }
                if (unk1 != 1) {
                    logger.fine(() -> LMG.log("(): unk1=%d.  Look into what this means for the unk1 field.", () -> unk1));
                }
                if (resourceName != null && resourceName.trim().length() > 0) {
                    message = (String)message + ": Resource Name: " + resourceName;
                }
                LogEntry logObject = new LogEntry(this.appliance, this.appliance.getDomain(domainName), this.logTargetName, this.lineNumber, time, logCategory, transactionID, globalTransactionID, cliType, objectName, clientIP, (String)message);
                logObject.setLogLevel(logLevel);
                logObject.setErrorCode(errorCode);
                logger.finer(() -> LMG.log("(logEntry, logObjects): Adding log entry for transaction %d.", () -> transactionID));
                logObjects.add(logObject);
            }
            ++n2;
        }
        logger.finer("(logEntry, logObjects): Done.");
    }

    private static String getSubString(int startPos, int endPos, String logLine) {
        logger.finer(() -> LMG.log("(startPos=%d, endPos=%d, logLine): Starting", () -> startPos, () -> endPos));
        String subString = "";
        try {
            subString = logLine.substring(startPos, endPos);
        }
        catch (StringIndexOutOfBoundsException e) {
            logger.severe(() -> LMG.log("(startPos=%d, endPos=%d, logLine=%s): Index out of bounds.\n%s", () -> startPos, () -> endPos, () -> logLine, () -> StackTrace.getStackTrace(e)));
            e.printStackTrace();
        }
        String returnValue = subString.trim();
        logger.finer(() -> LMG.log("(startPos=%d, endPos=%d, logLine): Done.  Returning '%s'", () -> startPos, () -> endPos, () -> returnValue));
        return returnValue;
    }
}

