/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.BeanIndexer;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.AbstractLogEntry;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigObjectCache;
import com.kumbasoft.core.beans.ConfigObjectSubscriber;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.LogEntrySubscriber;
import com.kumbasoft.core.beans.config.ConfigEventlog;
import com.kumbasoft.core.beans.config.ConfigLogTarget;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.DataPowerFileReader;
import com.kumbasoft.core.tools.ListFiles;
import com.kumbasoft.core.tools.LogParser;
import com.kumbasoft.core.tools.LogTargetProcessListener;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.util.DataStructureUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class LogTargetProcessor
extends AbstractTool
implements ConfigObjectSubscriber<DataPowerFileInfo> {
    public static final byte ABORTING = 1;
    public static final byte ABORTED = 2;
    private static final int LIST_STARTED = 0;
    private static final int SET_FILE_COUNT = 1;
    private static final int PROCESS_FILE = 2;
    private static final int PROCESS_COMPLETE = 3;
    private ArrayList<ConfigLogTarget> loggingTargets;
    private HashMap<Appliance, Index<Domain, ConfigLogTarget>> logTargetMap;
    private String fileNameMatchPattern;
    private ArrayList<String> directories;
    private ArrayList<LogEntrySubscriber<?>> logEntrySubscribers;
    private MultiThreadInvocationListener mtil;
    private ArrayList<DataPowerFileInfo> filesToRead;
    private ArrayList<DataPowerFileReader> fileReaderInstances;
    private ArrayList<LogTargetProcessListener> processListeners;
    private boolean isAuditLog;
    private byte abort;

    public LogTargetProcessor(ArrayList<ConfigLogTarget> loggingTargets) {
        this.loggingTargets = loggingTargets;
        logger.finer(() -> LMG.log("(ArrayList<ConfigLogTarget> loggingTargets): Starting for %d logging targets.", () -> loggingTargets.size()));
        this.logEntrySubscribers = new ArrayList();
        this.buildLogTargetMetaData();
        new AsynchMethodInvoker((Object)this, "readLog", KumbaCoreConstants.STARTUP_DELAY);
    }

    private void buildLogTargetMetaData() {
        logger.finer("(): Starting.");
        this.logTargetMap = DataStructureUtility.mapByApplianceDomain(this.loggingTargets);
        UniqueArrayList<String> baseFileNames = new UniqueArrayList<String>();
        for (ConfigLogTarget logTarget : this.loggingTargets) {
            String baseFileName = logTarget.getLocalFile();
            if (baseFileName == null) {
                logger.warning(() -> LMG.log("(): The base file name of log target '%s' is null.  How?", () -> logTarget.getFQON()));
                continue;
            }
            if (baseFileName.startsWith("audit:")) {
                logger.fine("(): Processing the Audit log");
                this.isAuditLog = true;
            }
            baseFileNames.add(baseFileName);
        }
        int baseFileNameCount = baseFileNames.size();
        StringBuilder sb = new StringBuilder("(");
        if (baseFileNameCount == 0) {
            logger.warning("(): No base file names to work with.  Munging the pattern so nothing is found.");
            sb.append("xq".repeat(50));
            sb.append(")");
        } else {
            logger.finer(() -> LMG.log("(): Building the file name match pattern for %d base file names.", () -> baseFileNameCount));
            this.directories = new ArrayList();
            for (String baseFileName : baseFileNames) {
                int lastSlash = baseFileName.lastIndexOf("/");
                String directory = baseFileName.substring(0, lastSlash + 1);
                directory = StringUtility.coalesce(directory, "/");
                this.directories.add(directory);
                String fileName = baseFileName.substring(lastSlash + 1);
                if (sb.length() > 1) {
                    sb.append("|");
                }
                sb.append(fileName);
            }
            sb.append(")(\\.\\d+)?");
        }
        this.fileNameMatchPattern = sb.toString();
        logger.finer(() -> LMG.log("(): Done.  File name match pattern is '%s'.", () -> this.fileNameMatchPattern));
    }

    public void addLogTargetProcessListener(LogTargetProcessListener listener) {
        if (this.processListeners == null) {
            this.processListeners = new ArrayList();
        }
        this.processListeners.add(listener);
    }

    public void addLogEntrySubscriber(LogEntrySubscriber<?> logEntrySubscriber) {
        this.logEntrySubscribers.add(logEntrySubscriber);
    }

    public boolean isRunning() {
        return !this.mtil.isComplete();
    }

    public boolean isAborting() {
        return this.abort == 1;
    }

    public boolean isAborted() {
        return this.abort == 2;
    }

    public void abort() {
        logger.info("(): Aborting due to user external change in selections.");
        if (CollectionUtility.isNotEmpty(this.fileReaderInstances)) {
            for (DataPowerFileReader instance : this.fileReaderInstances) {
                instance.setAbortReading(true);
            }
        }
        this.abort = 1;
    }

    @Reflected
    private void readLog() {
        logger.finer("(): Processing");
        this.notifyProcessListeners(0, 0, null);
        if (this.abort == 1) {
            this.abort = (byte)2;
            logger.finer("(): Abort set.  Returning now.");
            return;
        }
        Index<Appliance, Domain> searchDomains = new Index<Appliance, Domain>();
        for (Appliance appliance : this.logTargetMap.keySet()) {
            Index<Domain, ConfigLogTarget> logTargetsInAppliance = this.logTargetMap.get(appliance);
            Collection<Domain> domains = logTargetsInAppliance.getKeys();
            searchDomains.put(appliance, domains);
        }
        if (this.abort == 1) {
            this.abort = (byte)2;
            logger.finer("(): Abort set.  Returning now.");
            return;
        }
        this.mtil = new MultiThreadInvocationListener();
        ConfigObjectCache<DataPowerFileInfo> fileCache = new ConfigObjectCache<DataPowerFileInfo>();
        logger.finer("(): Listing log files");
        if (this.isAuditLog) {
            for (ConfigLogTarget auditLogTarget : this.loggingTargets) {
                Appliance appliance = auditLogTarget.getAppliance();
                Domain domain = auditLogTarget.getSourceDomain();
                int numberOfRotatations = (int)auditLogTarget.getRotate();
                int i = 0;
                while (i < numberOfRotatations) {
                    Object fileName = i == 0 ? "audit-log" : "audit-log." + i;
                    DataPowerFileInfo dataPowerFileInfo = new DataPowerFileInfo(appliance, domain, null, 0L, "audit:/", (String)fileName);
                    fileCache.processDataPowerConfig(dataPowerFileInfo);
                    ++i;
                }
            }
        } else if (this.directories == null) {
            logger.warning("():  Directories list is null.  How?");
        } else {
            ListFiles.list(searchDomains, this.directories, this.fileNameMatchPattern, this.mtil);
            ListFiles.addConfigObjectSubscriber(fileCache);
            ThreadManager.monitorAsynchThreadLifeCycle("LogTargetProcessor.readLog()", this.mtil, this.directories.size() * KumbaCoreConstants.STARTUP_DELAY, 0);
            this.mtil.clearCompleted();
        }
        this.filesToRead = new ArrayList(fileCache.getObjectCache());
        fileCache.clearCache();
        this.notifyProcessListeners(1, this.filesToRead.size(), null);
        if (this.filesToRead.size() == 0) {
            this.abort = (byte)2;
            logger.info("(): No files found.  Returning.");
            this.configProcessingComplete();
            return;
        }
        if (this.abort == 1) {
            this.abort = (byte)2;
            logger.finer("(): Abort set.  Returning now.");
            return;
        }
        logger.finer(() -> LMG.log("(): Reading %d files.", () -> this.filesToRead.size()));
        this.fileReaderInstances = DataPowerFileReader.readFiles(this.filesToRead, this.mtil, this);
        logger.finer("(): Done setting up logs to read.");
    }

    private void notifySubscribers(ArrayList<AbstractLogEntry> logEntries) {
        for (LogEntrySubscriber<?> ler : this.logEntrySubscribers) {
            ler.addLogEntries(logEntries);
        }
    }

    private void notifyProcessListeners(int messageNumber, int fileCount, DataPowerFileInfo file) {
        if (this.processListeners == null) {
            return;
        }
        for (LogTargetProcessListener listener : this.processListeners) {
            switch (messageNumber) {
                case 0: {
                    listener.listingLogTargetFiles();
                    break;
                }
                case 1: {
                    listener.setLogTargetFileCount(fileCount);
                    break;
                }
                case 2: {
                    listener.readingFile(file);
                    break;
                }
                case 3: {
                    listener.processingComplete();
                }
            }
        }
    }

    @Override
    public void processDataPowerConfig(DataPowerFileInfo dataPowerFile) {
        logger.finer(() -> LMG.log("((DataPowerFileInfo dataPowerFile='%s'): Processing File.", () -> dataPowerFile.getFQON()));
        AsynchMethodInvoker thread = new AsynchMethodInvoker((Object)this, "processDataPowerFile", (Object)dataPowerFile);
        this.mtil.addThread(thread);
    }

    @Reflected
    private void processDataPowerFile(DataPowerFileInfo dataPowerFile) {
        Appliance fileAppliance = dataPowerFile.getAppliance();
        Domain sourceDomain = dataPowerFile.getSourceDomain();
        String dataPowerFileName = StringUtility.coalesce(dataPowerFile.getName(), "/");
        ArrayList<DataPowerFileInfo> filesToReadLooper = new ArrayList<DataPowerFileInfo>(this.filesToRead);
        for (DataPowerFileInfo fileToRead : filesToReadLooper) {
            String fileToReadName;
            Domain fileToReadDomain;
            if (fileToRead == null) {
                logger.info(() -> LMG.log("(dataPowerFile=%s):  File to read is null", () -> dataPowerFileName));
                continue;
            }
            Appliance fileToReadAppliance = fileToRead.getAppliance();
            if (!fileToReadAppliance.equals(fileAppliance) || !(fileToReadDomain = fileToRead.getSourceDomain()).equals(sourceDomain) || !(fileToReadName = StringUtility.coalesce(fileToRead.getName(), "/")).equals(dataPowerFileName)) continue;
            this.filesToRead.remove(fileToRead);
            break;
        }
        if (this.abort == 1) {
            this.notifyProcessListeners(2, 0, dataPowerFile);
            if (this.filesToRead.size() == 0) {
                this.configProcessingComplete();
            }
            logger.finer(() -> LMG.log("(dataPowerFile=%s):  Abort set, returning now", () -> dataPowerFileName));
            return;
        }
        String loggerPrefix = String.format("(DataPowerFileInfo dataPowerFile=%s)", dataPowerFile.getFQON());
        logger.finer(() -> LMG.log("%s: Start Processing File.", () -> loggerPrefix));
        DataPowerFileInfo dpFile = dataPowerFile;
        String fileContent = dataPowerFile.getFileContent();
        if (fileContent == null) {
            logger.warning(() -> LMG.log("%s:  File content is NULL in the '%s' file.", () -> loggerPrefix, () -> dpFile.getAbsolutePath()));
            return;
        }
        String[] logEntries = fileContent.split("</log-entry>");
        fileContent = null;
        dataPowerFile.setFileContent(null);
        logger.finer(() -> LMG.log("%s: %d Logging Entries within '%s'.", () -> loggerPrefix, () -> logEntries.length, () -> dpFile.getAbsolutePath()));
        ArrayList<AbstractLogEntry> logObjects = new ArrayList<AbstractLogEntry>();
        Index<Domain, ConfigLogTarget> logTargetsInAppliance = this.logTargetMap.get(fileAppliance);
        Collection<ConfigLogTarget> logTargetsInDomain = logTargetsInAppliance.get(sourceDomain);
        BeanIndexer<ConfigLogTarget> localFileIndexer = new BeanIndexer<ConfigLogTarget>(logTargetsInDomain);
        HashMap<String, ConfigLogTarget> logTargetsByFileName = localFileIndexer.getMapOf("localFile", "");
        DataPowerConfig matchingLogTarget = null;
        for (String logTargetLocalFileName : logTargetsByFileName.keySet()) {
            String fixedLocalFileName = StringUtility.coalesce(logTargetLocalFileName, "/");
            if (!dataPowerFileName.startsWith(fixedLocalFileName)) continue;
            matchingLogTarget = logTargetsByFileName.get(logTargetLocalFileName);
            break;
        }
        if (matchingLogTarget == null) {
            logger.info(() -> LMG.log("%s:  Cannot find matching logging target for '%s' within the '%s' domain of '%s'.", () -> loggerPrefix, () -> dataPowerFileName, () -> fileAppliance.getName(), () -> sourceDomain.getName()));
            return;
        }
        String matchingLogTargetName = matchingLogTarget.getName();
        logger.info(() -> LMG.log("%s:  Found matching logging target '%s' for '%s' within the '%s' domain of '%s'.", () -> loggerPrefix, () -> matchingLogTargetName, () -> dataPowerFileName, () -> fileAppliance.getName(), () -> sourceDomain.getName()));
        LogParser logParser = new LogParser(dataPowerFile.getAppliance(), dataPowerFile.getSourceDomain(), matchingLogTargetName, ((ConfigEventlog)matchingLogTarget).getLocalFile());
        logParser.processLogEntries(logEntries, logObjects);
        logger.finer(() -> LMG.log("%s: Notifying Subscribers.", () -> loggerPrefix));
        this.notifySubscribers(logObjects);
        this.notifyProcessListeners(2, 0, dataPowerFile);
        logger.finer(() -> LMG.log("%s: Done Processing File.", () -> loggerPrefix));
        if (this.filesToRead.size() == 0) {
            this.configProcessingComplete();
        }
    }

    @Override
    public void configProcessingComplete() {
        logger.finer("(): Processing of files is complete");
        this.abort = (byte)2;
        this.notifyProcessListeners(3, 0, null);
    }
}

