/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.tools.AbstractConfigTool;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.util.logging.FinestLogRecord;
import java.util.Collection;
import java.util.logging.Level;

public class ModifyTool
extends AbstractConfigTool {
    private static final String modifySegment = "<${modifyObjectType} name=\"${modifyObjectName}\">${modifyBody}</${modifyObjectType}>\n       ";

    public ModifyTool(Appliance appliance, Domain domain, DataPowerConfig configObject) {
        super(appliance, domain, configObject);
    }

    public ModifyTool(Appliance appliance, Domain domain, Collection<DataPowerConfig> configObjects) {
        super(appliance, domain, configObjects);
    }

    public ModifyTool(Appliance appliance, Domain domain, DataPowerConfig configObject, boolean runSynchronously) {
        super(appliance, domain, configObject, runSynchronously);
    }

    @Override
    protected String getRequestMessage() {
        AbstractTool.logger.finer(() -> LMG.log("(): Building Modify request for %s", () -> this.xmlManagementObjectType));
        String requestXML = this.prepareXMLTemplate("ModifyTemplate.xml");
        int insertPoint = requestXML.indexOf("</dp:modify-config>");
        for (DataPowerConfig modifyObject : this.xmlManagementObjects) {
            requestXML = StringUtility.insertInto(modifySegment, requestXML, insertPoint);
            requestXML = requestXML.replace("${modifyObjectType}", modifyObject.getConfigObjectType());
            requestXML = requestXML.replace("${modifyObjectName}", modifyObject.getName());
            requestXML = this.buildXMLRequestFromProperties(requestXML, "${modifyBody}", modifyObject);
            insertPoint = requestXML.indexOf("</dp:modify-config>");
        }
        requestXML = this.cleanupRequestXML(requestXML);
        if (AbstractTool.logger.getLevel().equals(Level.FINEST)) {
            FinestLogRecord logRecord = new FinestLogRecord(Level.FINEST, this.getAppliance(), this.getDomain(), requestXML);
            logger.log(logRecord);
        }
        return requestXML;
    }
}

