/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.KumbaCoreApplicationParameters;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.ApplianceInvocationProfile;
import com.kumbasoft.core.util.FileUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class ThreadManager
extends AbstractTool {
    private static final int INVOCATION_PROFILE_WRITE_FREQUENCY = 300000;
    private static final int THREAD_MANAGER_STATE_LOGGER_FREQUENCY = 60000;
    private static ConcurrentHashMap<Appliance, MultiThreadInvocationListener> threads;
    private static ConcurrentHashMap<String, ApplianceInvocationProfile> invocationProfiles;
    private static File invocationProfilesFile;
    private static boolean inGetThread;

    private ThreadManager() {
    }

    public static final void startThreadManager(int applianceCount) {
        logger.finer(() -> LMG.log("(int applianceCount=%d): Creating hash for the given count of appliances.", () -> applianceCount));
        threads = new ConcurrentHashMap(applianceCount, 0.75f, applianceCount * 2);
        String logsDirectoryName = applicationProperties.getLogsDirectory();
        File logsDirectory = new File(logsDirectoryName);
        logsDirectory.mkdirs();
        invocationProfilesFile = new File(logsDirectory, "InvocationProfiles.xgn");
        invocationProfiles = (ConcurrentHashMap)FileUtility.readObject(invocationProfilesFile, true);
        if (invocationProfiles == null && (invocationProfiles = (ConcurrentHashMap)FileUtility.readObject(invocationProfilesFile, false)) == null) {
            invocationProfiles = new ConcurrentHashMap(applianceCount * 5);
        }
        new AsynchMethodInvoker(ThreadManager.class, "showThreadsByAppliance", 60000);
        new AsynchMethodInvoker(ThreadManager.class, "writeInvocationProfiles", 300000);
    }

    public static <T> AsynchMethodInvoker<T> getThread(Appliance appliance, Object invocationTarget, String invocationMethodName, int delay, Object ... arguments) {
        inGetThread = true;
        try {
            String invocationTargetClassName = invocationTarget.getClass().getName();
            String loggerPrefix = String.format("(Appliance appliance=%s, Object invocationTarget=%s, String invocationMethodName=%s, int delay=%d, Object...arguments=%s)", appliance.getName(), invocationTarget.getClass().getSimpleName(), invocationMethodName, delay, Arrays.toString(arguments));
            if (threads == null) {
                logger.finer(() -> LMG.log("%s: Creating hash for 32 appliances.", () -> loggerPrefix));
                threads = new ConcurrentHashMap(32, 0.75f, 64);
            }
            logger.finer(() -> LMG.log("%s: Starting", () -> loggerPrefix));
            MultiThreadInvocationListener mtil = threads.get(appliance);
            if (mtil == null) {
                mtil = new MultiThreadInvocationListener();
                threads.put(appliance, mtil);
            } else {
                Vector<AsynchMethodInvoker> threads;
                int runningThreads;
                int startingThreadCount = runningThreads = mtil.getRunningThreadCount();
                logger.finer(() -> LMG.log("%s: %d threads active.", () -> loggerPrefix, () -> startingThreadCount));
                int threadWait = KumbaCoreConstants.THREAD_WAIT;
                while (runningThreads >= KumbaCoreConstants.MAX_THREADS && threadWait < KumbaCoreConstants.THREAD_TIMEOUT) {
                    int runningThreadCount = runningThreads;
                    logger.finer(() -> LMG.log("%s: Waiting on thread availability.  %d threads to go.", () -> loggerPrefix, () -> runningThreadCount));
                    ThreadUtility.sleep(threadWait);
                    mtil.clearCompleted();
                    threadWait += KumbaCoreConstants.THREAD_WAIT;
                    runningThreads = mtil.getRunningThreadCount();
                }
                String invocationProfileKey = String.format("%s-%s-%s", appliance.getName(), invocationTargetClassName, invocationMethodName);
                ApplianceInvocationProfile invocationProfile = invocationProfiles.get(invocationProfileKey);
                if (invocationProfile == null) {
                    invocationProfile = new ApplianceInvocationProfile();
                    invocationProfile.setApplianceName(appliance.getName());
                    invocationProfile.setInvokerTarget(invocationTargetClassName);
                    invocationProfile.setInvokedMethod(invocationMethodName);
                    invocationProfiles.put(invocationProfileKey, invocationProfile);
                    logger.finer(() -> LMG.log("%s: Added invocation profile to %s.", () -> loggerPrefix, () -> invocationProfileKey));
                }
                if (CollectionUtility.isNotEmpty(threads = mtil.getThreads())) {
                    try {
                        logger.finer(() -> LMG.log("%s: Number of existing threads for appliance %s.", () -> threads.size(), () -> appliance.getName()));
                        ArrayList<AsynchMethodInvoker> applianceThreads = new ArrayList<AsynchMethodInvoker>(threads);
                        for (AsynchMethodInvoker thread : applianceThreads) {
                            if (thread == null || !thread.hasCompleted()) continue;
                            Object targetObject = thread.getObject();
                            String targetMethod = thread.getMethodName();
                            String profileKey = String.format("%s-%s-%s", appliance.getName(), targetObject.getClass().getName(), targetMethod);
                            if (!invocationProfileKey.equals(profileKey)) continue;
                            long timeElapsed = thread.getInvocationTimeElapsed();
                            invocationProfile.addInvocation(timeElapsed);
                            logger.finer(() -> LMG.log("%s: Setting invocation time elapsed for %s to %d.", () -> loggerPrefix, () -> invocationProfileKey, () -> timeElapsed));
                        }
                    }
                    catch (Exception e) {
                        logger.severe(() -> LMG.log("%s: Exception in processing.  Fix it!", () -> loggerPrefix));
                        e.printStackTrace();
                    }
                }
            }
            MultiThreadInvocationListener threadListener = mtil;
            logger.finer(() -> LMG.log("%s: Thread count prior to clear: %d.", () -> loggerPrefix, () -> threadListener.getThreads().size()));
            mtil.clearCompleted();
            logger.finer(() -> LMG.log("%s: Thread count after clear: %d.", () -> loggerPrefix, () -> threadListener.getThreads().size()));
            logger.finer(() -> LMG.log("%s: Creating Thread", () -> loggerPrefix));
            AsynchMethodInvoker thread = null;
            thread = arguments == null ? new AsynchMethodInvoker(invocationTarget, invocationMethodName, delay) : new AsynchMethodInvoker(invocationTarget, invocationMethodName, arguments, delay);
            mtil.addThread(thread);
            logger.finer(() -> LMG.log("%s: Done", () -> loggerPrefix));
            AsynchMethodInvoker asynchMethodInvoker = thread;
            return asynchMethodInvoker;
        }
        finally {
            inGetThread = false;
        }
    }

    public static boolean monitorAsynchThreadLifeCycle(String source, MultiThreadInvocationListener invocationListener, int startWaitTimeout, int maxWaitTimeout) {
        boolean completedOnTime;
        int timeToWait;
        int extraWaitTimeout = startWaitTimeout + KumbaCoreConstants.STARTUP_DELAY;
        logger.finer(() -> LMG.log("(...): Waiting up to %dms for threads to start for %s.", () -> extraWaitTimeout, () -> source));
        boolean startedOnTime = invocationListener.waitToStart(extraWaitTimeout);
        KumbaCoreApplicationParameters parms = (KumbaCoreApplicationParameters)Application.getApplication().getApplicationParametersBean();
        int userSuppliedTimeout = parms.getSomaConnectionTimeout() + parms.getSomaReadTimeout();
        if (userSuppliedTimeout == KumbaCoreConstants.SOMA_CONNECTION_TIMEOUT + KumbaCoreConstants.SOMA_READ_TIMEOUT) {
            userSuppliedTimeout = KumbaCoreConstants.THREAD_TIMEOUT;
        }
        int computedTimeToWait = invocationListener.getRunningThreadCount() * userSuppliedTimeout;
        int n = timeToWait = maxWaitTimeout > 0 && computedTimeToWait > maxWaitTimeout ? maxWaitTimeout : computedTimeToWait;
        if (startedOnTime) {
            logger.finer(() -> LMG.log("(...): At least one thread has started for %s. Waiting %dms for threads to complete.", () -> source, () -> timeToWait));
        } else {
            logger.info(() -> LMG.log("(...): Timed out waiting for threads to start for %s. Waiting %dms for threads to complete.", () -> source, () -> timeToWait));
        }
        boolean bl = completedOnTime = timeToWait > 0 ? invocationListener.waitUntilComplete(timeToWait) : true;
        if (completedOnTime) {
            logger.finer(() -> LMG.log("(...): Threads completed on time for %s.", () -> source));
        } else {
            logger.warning(() -> LMG.log("(...): Not all threads completed on time for %s.  Those threads may still complete, but giving control back to the client.", () -> source));
            Vector<AsynchMethodInvoker> threads = invocationListener.getThreads();
            for (AsynchMethodInvoker thread : threads) {
                String methodName = thread.getMethodName();
                String objectName = thread.getObject().getClass().getSimpleName();
                long invocationStarted = thread.getInvocationStarted();
                logger.finer(() -> LMG.log("(...):  Thread %s.%s started at %d is running for source %s.", () -> objectName, () -> methodName, () -> invocationStarted, () -> source));
            }
        }
        return completedOnTime;
    }

    @Reflected
    private static void showThreadsByAppliance() {
        try {
            if (inGetThread) {
                return;
            }
            Enumeration<Appliance> applianceEnumerator = threads.keys();
            while (applianceEnumerator.hasMoreElements()) {
                Appliance appliance = applianceEnumerator.nextElement();
                MultiThreadInvocationListener mtil = threads.get(appliance);
                int runningThreads = mtil.getRunningThreadCount();
                logger.finer(() -> LMG.log("(): Threads for %s: %d", () -> appliance.getName(), () -> runningThreads));
            }
        }
        finally {
            new AsynchMethodInvoker(ThreadManager.class, "showThreadsByAppliance", 60000);
        }
    }

    @Reflected
    private static void writeInvocationProfiles() {
        logger.finer("(): Starting");
        FileUtility.writeObject(invocationProfilesFile, invocationProfiles, true);
        new AsynchMethodInvoker(ThreadManager.class, "writeInvocationProfiles", 300000);
        logger.finer("(): Done");
    }
}

