/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.dialog;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMDialog;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.event.ComponentEventInvoker;
import com.jmorgan.swing.util.WindowCloser;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.ui.panel.ConfigureObjectPanel;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;

public class ConfigureObjectDialog
extends JMDialog {
    public static final int SAVED = 0;
    public static final int CANCELLED = 1;
    private static int userAction;
    private DataPowerConfig configObject;
    private ConfigureObjectPanel configureObjectPanel;
    private JMButton saveButton;
    private JMButton cancelButton;

    public static int getUserAction() {
        return userAction;
    }

    public ConfigureObjectDialog(JFrame owner, String title, Object ... arguments) {
        super(owner, title, true, arguments);
    }

    @Override
    public void buildGUI(Object ... arguments) {
        userAction = 1;
        this.configObject = (DataPowerConfig)arguments[0];
        String[] hiddenFields = null;
        if (arguments.length > 1) {
            hiddenFields = new String[arguments.length - 1];
            int i = 1;
            while (i < arguments.length) {
                hiddenFields[i - 1] = (String)arguments[i];
                ++i;
            }
        }
        this.saveButton = ComponentFactory.createButton(null, "Save", "Save the configuration", true, this, "saveAndClose", new Object[0]);
        this.cancelButton = ComponentFactory.createButton(null, "Cancel", "Cancel changes", true, this, "cancelAndClose", new Object[0]);
        this.configureObjectPanel = new ConfigureObjectPanel(this.configObject, hiddenFields);
        Dimension panelSize = this.configureObjectPanel.getPreferredSize();
        JMPanel buttonPanel = new JMPanel();
        buttonPanel.addAll(this.saveButton, this.cancelButton);
        this.add((Component)this.configureObjectPanel, "Center");
        this.add((Component)buttonPanel, "South");
        Dimension buttonPanelSize = buttonPanel.getPreferredSize();
        Dimension idealSize = new Dimension(Math.max(panelSize.width, buttonPanelSize.width) + 40, panelSize.height + buttonPanelSize.height + 80);
        this.setSize(idealSize);
        this.setPreferredSize(idealSize);
        new ComponentEventInvoker(this, 8, (Object)this, "windowResized");
    }

    @Reflected
    private void windowResized() {
        Dimension size = this.getSize();
        this.configureObjectPanel.setSize(size);
        this.configureObjectPanel.setPreferredSize(size);
        this.revalidate();
        this.repaint();
    }

    @Reflected
    private void saveAndClose() {
        userAction = 0;
        this.configureObjectPanel.applyConfiguration();
        WindowCloser.closeWindow(this);
    }

    @Reflected
    private void cancelAndClose() {
        userAction = 1;
        WindowCloser.closeWindow(this);
    }
}

