/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.dialog.auditLogSettings;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMButtonGroup;
import com.jmorgan.swing.JMDialog;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMRadioButton;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.util.ContainerService;
import com.jmorgan.swing.util.WindowCloser;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.auditLogSettings.AuditLogSettingsPanel;
import com.kumbasoft.core.ui.dialog.auditLogSettings.ConsolePublisherSettingsPanel;
import com.kumbasoft.core.ui.dialog.auditLogSettings.FilePublisherSettingsPanel;
import com.kumbasoft.core.util.FileUtility;
import com.kumbasoft.core.util.logging.AuditLogHandler;
import com.kumbasoft.core.util.logging.FilePublisherSettings;
import com.kumbasoft.core.util.logging.LogPublisher;
import com.kumbasoft.core.util.logging.PublisherSettings;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;

public class AuditLogSettingsDialog
extends JMDialog {
    private static final String CONSOLE = "console";
    private static final String FILE = "localFile";
    private static final String UDPSYSLOG = "udpSyslog";
    private static final String TCPSYSLOG = "tcpSyslog";
    private static final String NFSFILE = "nfsFile";
    private static final String FTPFILE = "ftpFile";
    private static final String SFTPFILE = "sftpFile";
    private static final String JSON = "json";
    private static final String XML = "xml";
    private static final String MQ = "mq";
    private JMRadioButton rbConsole;
    private JMRadioButton rbFile;
    private JMRadioButton rbUDPSyslog;
    private JMRadioButton rbTCPSyslog;
    private JMRadioButton rbNFSFile;
    private JMRadioButton rbFTPFile;
    private JMRadioButton rbSFTPFile;
    private JMRadioButton rbJSON;
    private JMRadioButton rbXML;
    private JMRadioButton rbMQ;
    private JMButton saveButton;
    private JMButton cancelButton;
    private AuditLogSettingsPanel currentPanel;
    private JMPanel cardPanel;
    private CardLayout cardLayout;

    public AuditLogSettingsDialog(JFrame frame) {
        super(frame, "Audit Log Settings", true);
    }

    @Override
    public void buildGUI(Object ... arguments) {
        super.buildGUI(arguments);
        this.contentPane.add((Component)this.createOptionPanel(), "West");
        this.contentPane.add((Component)this.createCardPanel(), "Center");
        this.contentPane.add((Component)this.createBottomPanel(), "South");
    }

    private JMPanel createOptionPanel() {
        JMPanel panel = KumbaCoreUIConstants.createVerticalFlowLayoutPanel(0);
        this.rbConsole = new JMRadioButton("Console");
        this.rbFile = new JMRadioButton("Local File");
        new JMButtonGroup(this.rbConsole, this.rbFile);
        panel.addAll(this.rbConsole, this.rbFile);
        panel.setBorder(BorderFactory.createEtchedBorder());
        return panel;
    }

    private JMPanel createBottomPanel() {
        JMPanel panel = KumbaCoreUIConstants.createFlowLayoutPanel(1);
        this.saveButton = new JMButton("Save");
        this.cancelButton = new JMButton("Cancel");
        panel.addAll(this.saveButton, this.cancelButton);
        return panel;
    }

    private JMPanel createCardPanel() {
        block12: {
            block10: {
                this.cardLayout = new CardLayout();
                this.cardPanel = new JMPanel(this.cardLayout);
                this.currentPanel = new ConsolePublisherSettingsPanel();
                this.cardPanel.add((Component)this.currentPanel, CONSOLE);
                this.cardPanel.add((Component)new FilePublisherSettingsPanel(), FILE);
                PublisherSettings settings = (PublisherSettings)FileUtility.readObject(AuditLogHandler.AUDIT_LOG_SETTINGS_CONFIG_FILENAME, false);
                JMRadioButton rbToSelect = this.rbConsole;
                if (settings == null) break block10;
                String panelToShow = switch (settings.getClass().getSimpleName()) {
                    case "ConsolePublisherSettings" -> {
                        rbToSelect = this.rbConsole;
                        yield CONSOLE;
                    }
                    case "FilePublisherSettings" -> {
                        FilePublisherSettings filePublisherSettings = (FilePublisherSettings)settings;
                        List<FilePublisherSettingsPanel> panels = ContainerService.findComponentsByType(this.cardPanel, FilePublisherSettingsPanel.class);
                        FilePublisherSettingsPanel panel = panels.get(0);
                        panel.setPublisherSettings(filePublisherSettings);
                        rbToSelect = this.rbFile;
                        yield FILE;
                    }
                    default -> {
                        rbToSelect = this.rbConsole;
                        yield CONSOLE;
                    }
                };
                rbToSelect.setSelected(true);
                this.cardLayout.show(this.cardPanel, panelToShow);
                break block12;
            }
            this.rbConsole.setSelected(true);
            this.cardLayout.show(this.cardPanel, CONSOLE);
        }
        return this.cardPanel;
    }

    @Override
    public void setupEventHandling() {
        new ActionEventInvoker(this.saveButton, this, "saveSettings");
        new ActionEventInvoker(this.cancelButton, this.getWindowCloser(), "closeWindow");
        new ActionEventInvoker(this.rbConsole, this, "setCurrentPanel", CONSOLE);
        new ActionEventInvoker(this.rbFile, this, "setCurrentPanel", FILE);
    }

    @Reflected
    private void setCurrentPanel(String currentPanelName) {
        Component[] allComponents;
        this.cardLayout.show(this.cardPanel, currentPanelName);
        Component visiblePanel = null;
        Component[] componentArray = allComponents = this.cardPanel.getComponents();
        int n = allComponents.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c.isVisible()) {
                visiblePanel = c;
                break;
            }
            ++n2;
        }
        this.currentPanel = (AuditLogSettingsPanel)visiblePanel;
    }

    public void saveSettings() {
        Object settings = this.currentPanel.getPublisherSettings();
        FileUtility.writeObject(AuditLogHandler.AUDIT_LOG_SETTINGS_CONFIG_FILENAME, settings, false);
        LogPublisher publisher = this.currentPanel.getPublisher();
        AuditLogHandler.getInstance().setPublisher(publisher);
        WindowCloser.closeWindow(this, 0);
    }
}

