/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.dialog.auditLogSettings;

import com.jmorgan.io.filefilter.DirectoryFileFilter;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.NumberField;
import com.jmorgan.swing.component.FileSelectorComponent;
import com.jmorgan.swing.spinner.NumberSpinner;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.auditLogSettings.AuditLogSettingsPanel;
import com.kumbasoft.core.util.logging.FilePublisher;
import com.kumbasoft.core.util.logging.FilePublisherSettings;
import com.kumbasoft.core.util.logging.LogPublisher;
import java.awt.Component;

public class FilePublisherSettingsPanel
extends AuditLogSettingsPanel<FilePublisherSettings> {
    private FileSelectorComponent fileSelector = new FileSelectorComponent("Audit Files Directory:", "...");
    private NumberField nfMaximumSize;

    public FilePublisherSettingsPanel() {
        super(KumbaCoreUIConstants.createVerticalFlowLayout(0));
        this.fileSelector.setPreferredSize(600, 25);
        this.fileSelector.setFileNameFilter(new DirectoryFileFilter());
        this.fileSelector.hideActionButton();
        this.nfMaximumSize = new NumberField(1000.0);
        NumberSpinner nsMaximumSize = new NumberSpinner(this.nfMaximumSize, 1000.0, 100.0, 2.147483647E9);
        LabeledComponent lblSize = new LabeledComponent("File Size (KiB):", (Component)nsMaximumSize);
        this.addAll(this.fileSelector, lblSize);
    }

    @Override
    public FilePublisherSettings getPublisherSettings() {
        if (this.publisherSettings == null) {
            this.publisherSettings = new FilePublisherSettings();
        }
        String directoryName = this.fileSelector.getFileName();
        int maximumSize = (int)this.nfMaximumSize.getNumber();
        ((FilePublisherSettings)this.publisherSettings).setDirectoryName(directoryName);
        ((FilePublisherSettings)this.publisherSettings).setMaximumSize(maximumSize);
        return (FilePublisherSettings)this.publisherSettings;
    }

    @Override
    public void setPublisherSettings(FilePublisherSettings publisherSettings) {
        super.setPublisherSettings(publisherSettings);
        this.fileSelector.setFileName(publisherSettings.getDirectoryName());
        this.nfMaximumSize.setNumber(publisherSettings.getMaximumSize() / 1024);
    }

    @Override
    public LogPublisher<FilePublisherSettings> getPublisher() {
        FilePublisher filePublisher = new FilePublisher();
        filePublisher.setPublisherSettings((FilePublisherSettings)this.publisherSettings);
        return filePublisher;
    }
}

