/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.dialog.logSearchOptions;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.swing.JMButtonGroup;
import com.jmorgan.swing.JMRadioButton;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.beans.AbstractLogSearchOptions;
import com.kumbasoft.core.ui.beans.RelativeAnchor;
import com.kumbasoft.core.ui.beans.RelativeTimeMeasure;
import com.kumbasoft.core.ui.dialog.logSearchOptions.AbstractDateOptionsPanel;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;

public class QuickOptionsPanel
extends AbstractDateOptionsPanel {
    private static final String[] LABELS = new String[]{"Last 15 Seconds", "Last 30 Seconds", "Last 60 Seconds", "Last 2 Minutes", "Last 5 Minutes", "Last 10 Minutes", "Last 15 Minutes", "Last 30 Minutes", "Last 45 Minutes", "Last 60 Minutes", "Last 2 Hours", "Last 4 Hours", "Last 6 Hours", "Last 8 Hours", "Last 12 Hours", "Last 24 Hours", "All Time"};
    private static final RelativeAnchor[] ANCHORS = new RelativeAnchor[]{RelativeAnchor.NOW, RelativeAnchor.NOW, RelativeAnchor.NOW, RelativeAnchor.NOW, RelativeAnchor.NOW, RelativeAnchor.NOW, RelativeAnchor.NOW, RelativeAnchor.NOW, RelativeAnchor.NOW, RelativeAnchor.NOW, RelativeAnchor.NOW, RelativeAnchor.NOW, RelativeAnchor.NOW, RelativeAnchor.NOW, RelativeAnchor.NOW, RelativeAnchor.NOW, RelativeAnchor.NOW};
    private static final RelativeTimeMeasure[] MEASURES = new RelativeTimeMeasure[]{RelativeTimeMeasure.SECONDS, RelativeTimeMeasure.SECONDS, RelativeTimeMeasure.SECONDS, RelativeTimeMeasure.MINUTES, RelativeTimeMeasure.MINUTES, RelativeTimeMeasure.MINUTES, RelativeTimeMeasure.MINUTES, RelativeTimeMeasure.MINUTES, RelativeTimeMeasure.MINUTES, RelativeTimeMeasure.MINUTES, RelativeTimeMeasure.HOURS, RelativeTimeMeasure.HOURS, RelativeTimeMeasure.HOURS, RelativeTimeMeasure.HOURS, RelativeTimeMeasure.HOURS, RelativeTimeMeasure.HOURS, RelativeTimeMeasure.YEARS};
    private static final int[] VALUES = new int[]{-15, -30, -60, -2, -5, -10, -15, -30, -45, -60, -2, -4, -6, -8, -12, -24, -10};
    private HashMap<String, DynamicBean> dataSelection;
    private JMButtonGroup selectionGroup;
    private JMRadioButton[] buttons;

    public QuickOptionsPanel(AbstractLogSearchOptions searchOptions) {
        super(searchOptions, KumbaCoreUIConstants.createGridLayout(5, 4));
    }

    @Override
    protected void createControls() {
        this.dataSelection = new HashMap();
        this.buttons = new JMRadioButton[LABELS.length];
        int i = 0;
        while (i < this.buttons.length) {
            JMRadioButton button = new JMRadioButton(LABELS[i]);
            button.setName(LABELS[i]);
            this.buttons[i] = button;
            DynamicBean properties = new DynamicBean();
            properties.setProperty("anchor", (Object)ANCHORS[i]);
            properties.setProperty("measure", (Object)MEASURES[i]);
            properties.setProperty("value", VALUES[i]);
            this.dataSelection.put(LABELS[i], properties);
            ++i;
        }
        String selectedRB = (String)this.searchOptions.getUserSelectedOption("quickOptionRBSelected");
        if (selectedRB != null) {
            JMRadioButton rb = this.getButtonByLabel(selectedRB);
            rb.setSelected(true);
        } else {
            this.buttons[this.buttons.length - 1].setSelected(true);
        }
        this.selectionGroup = new JMButtonGroup(this.buttons);
        this.addAll(this.buttons);
    }

    @Override
    protected void setSearchOptions(AbstractLogSearchOptions searchOptions) {
        super.setSearchOptions(searchOptions);
        if (this.buttons != null) {
            String selectedRB = (String)this.searchOptions.getUserSelectedOption("quickOptionRBSelected");
            JMRadioButton rb = this.getButtonByLabel(selectedRB);
            if (rb == null) {
                AbstractPanel.logger.warning(() -> LMG.log("(searchOptions):  Did not find button by label '%s'.", () -> selectedRB));
            } else {
                rb.setSelected(true);
            }
        }
    }

    private JMRadioButton getButtonByLabel(String label) {
        JMRadioButton[] jMRadioButtonArray = this.buttons;
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            JMRadioButton rb = jMRadioButtonArray[n2];
            if (rb.getText().equals(label)) {
                return rb;
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected void saveOptions() {
        AbstractPanel.logger.finer("(): Starting");
        this.searchOptions.setUserSelectedOption("selectedDateTab", "quick");
        List<AbstractButton> selectedButtons = this.selectionGroup.getSelected();
        if (CollectionUtility.isEmpty(selectedButtons)) {
            selectedButtons.add(this.buttons[this.buttons.length - 1]);
        }
        for (AbstractButton button : selectedButtons) {
            String buttonName = button.getName();
            this.searchOptions.setUserSelectedOption("quickOptionRBSelected", buttonName);
            DynamicBean properties = this.dataSelection.get(buttonName);
            RelativeAnchor anchor = (RelativeAnchor)((Object)properties.getProperty("anchor"));
            this.searchOptions.setRelativeAnchor(anchor);
            this.searchOptions.setRelativeTimeMeasure((RelativeTimeMeasure)((Object)properties.getProperty("measure")));
            this.searchOptions.setTimeAmount((Integer)properties.getProperty("value"));
        }
        AbstractPanel.logger.finer("(): Done");
    }
}

