/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.dialog.logSearchOptions;

import com.jmorgan.swing.JMComboBox;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.NumberField;
import com.jmorgan.swing.spinner.NumberSpinner;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.beans.AbstractLogSearchOptions;
import com.kumbasoft.core.ui.beans.RelativeAnchor;
import com.kumbasoft.core.ui.beans.RelativeTimeMeasure;
import com.kumbasoft.core.ui.dialog.logSearchOptions.AbstractDateOptionsPanel;

public class RelativeOptionsPanel
extends AbstractDateOptionsPanel {
    private NumberField nfRelativeTime;
    private JMComboBox<String> timeFrameList;

    public RelativeOptionsPanel(AbstractLogSearchOptions searchOptions) {
        super(searchOptions, KumbaCoreUIConstants.createFlowLayout(0));
    }

    @Override
    protected void createControls() {
        RelativeTimeMeasure relativeTimeMeasure = this.searchOptions.getRelativeTimeMeasure();
        int relativeTimeAmount = this.searchOptions.getTimeAmount();
        if (relativeTimeMeasure == null) {
            relativeTimeMeasure = RelativeTimeMeasure.MINUTES;
            relativeTimeAmount = 15;
        }
        this.nfRelativeTime = new NumberField((double)relativeTimeAmount);
        NumberSpinner nsTimeFrameCount = new NumberSpinner(this.nfRelativeTime, 1.0, 1.0, 2.147483647E9);
        this.timeFrameList = new JMComboBox<String>((ItemType[])new String[]{"Seconds", "Minutes", "Hours", "Days", "Weeks", "Months", "Years"});
        this.timeFrameList.setSelectedItem(relativeTimeMeasure.getName());
        LabeledComponent lblTimeFrameCount = new LabeledComponent("Last:", this.timeFrameList, 45, 100);
        this.initializeControls();
        this.addAll(lblTimeFrameCount, nsTimeFrameCount);
    }

    @Override
    protected void setSearchOptions(AbstractLogSearchOptions searchOptions) {
        super.setSearchOptions(searchOptions);
        if (this.nfRelativeTime != null) {
            this.initializeControls();
        }
    }

    private void initializeControls() {
        this.nfRelativeTime.setNumber(this.searchOptions.getTimeAmount());
        RelativeTimeMeasure timeMeasure = this.searchOptions.getRelativeTimeMeasure();
        if (timeMeasure == null) {
            return;
        }
        String selectedTimeMeasure = "";
        switch (timeMeasure) {
            case SECONDS: {
                selectedTimeMeasure = "Seconds";
                break;
            }
            case MINUTES: {
                selectedTimeMeasure = "Minutes";
                break;
            }
            case HOURS: {
                selectedTimeMeasure = "Hours";
                break;
            }
            case DAYS: {
                selectedTimeMeasure = "Days";
                break;
            }
            case WEEKS: {
                selectedTimeMeasure = "Weeks";
                break;
            }
            case MONTHS: {
                selectedTimeMeasure = "Months";
                break;
            }
            case YEARS: {
                selectedTimeMeasure = "Years";
            }
        }
        this.timeFrameList.setSelectedItem(selectedTimeMeasure);
    }

    @Override
    protected void saveOptions() {
        AbstractPanel.logger.finer("(): Starting");
        this.searchOptions.setUserSelectedOption("selectedDateTab", "relative");
        this.searchOptions.setRelativeAnchor(RelativeAnchor.NOW);
        RelativeTimeMeasure timeMeasure = RelativeTimeMeasure.SECONDS;
        switch ((String)this.timeFrameList.getSelectedItem()) {
            case "Seconds": {
                timeMeasure = RelativeTimeMeasure.SECONDS;
                break;
            }
            case "Minutes": {
                timeMeasure = RelativeTimeMeasure.MINUTES;
                break;
            }
            case "Hours": {
                timeMeasure = RelativeTimeMeasure.HOURS;
                break;
            }
            case "Days": {
                timeMeasure = RelativeTimeMeasure.DAYS;
                break;
            }
            case "Weeks": {
                timeMeasure = RelativeTimeMeasure.WEEKS;
                break;
            }
            case "Months": {
                timeMeasure = RelativeTimeMeasure.MONTHS;
                break;
            }
            case "Years": {
                timeMeasure = RelativeTimeMeasure.YEARS;
            }
        }
        this.searchOptions.setRelativeTimeMeasure(timeMeasure);
        int measure = -((int)this.nfRelativeTime.getNumber());
        this.searchOptions.setTimeAmount(measure);
        AbstractPanel.logger.finer("(): Done");
    }
}

