/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.editors;

import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.app.KumbaCoreConstants;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;

public class DataPowerDirectoryTableCellEditor
extends DefaultCellEditor
implements TableCellRenderer {
    private DefaultComboBoxModel<String> cbxModel;
    private JComboBox<String> editor = (JComboBox)this.getComponent();
    private JTextField renderer;
    private ArrayList<String> directories;
    private String lastFileStore;

    public DataPowerDirectoryTableCellEditor() {
        super(new JComboBox(new DefaultComboBoxModel()));
        this.cbxModel = (DefaultComboBoxModel)this.editor.getModel();
        this.renderer = new JTextField();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        assert (column == 2);
        this.lastFileStore = (String)table.getValueAt(row, 1);
        this.updateComboBoxModel(this.lastFileStore);
        if (value == null) {
            value = "/";
        }
        this.editor.setSelectedItem(value);
        return this.getComponent();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        assert (column == 2);
        if (value == null) {
            this.renderer.setText("/");
        } else {
            this.renderer.setText(value.toString());
        }
        return this.renderer;
    }

    public void setDirectories(ArrayList<String> directories) {
        this.directories = directories;
    }

    private void updateComboBoxModel(String fileStore) {
        if (this.directories == null) {
            new AsynchMethodInvoker((Object)this, "updateComboBoxModel", (Object)fileStore, KumbaCoreConstants.THREAD_WAIT);
            return;
        }
        int fileStoreLength = fileStore.length() + 1;
        this.cbxModel.removeAllElements();
        this.cbxModel.addElement("/");
        Collections.sort(this.directories);
        for (String directory : this.directories) {
            String rawDirectory;
            if (!directory.startsWith(fileStore) || StringUtility.isEmpty(rawDirectory = directory.substring(fileStoreLength))) continue;
            this.cbxModel.addElement(rawDirectory);
        }
    }
}

