/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.models;

import com.jmorgan.swing.dnd.FileDropHandlerListener;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.beans.ImportConfigurationBean;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.io.File;
import java.util.HashMap;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class ImportConfigurationTableModel
extends BeanTableModel<ImportConfigurationBean>
implements TableModelListener,
FileDropHandlerListener {
    private static final HashMap<String, String> DIRECTORY_INFORMATION = new HashMap();

    static {
        String[] stringArray = DPEnumerations.FILESTORE_LOCATION;
        int n = DPEnumerations.FILESTORE_LOCATION.length;
        int n2 = 0;
        while (n2 < n) {
            String fileStore = stringArray[n2];
            String plainFileStore = fileStore.replace(":", "");
            String localDir = String.format("%s%s%s", File.separator, plainFileStore, File.separator);
            DIRECTORY_INFORMATION.put(localDir, fileStore);
            ++n2;
        }
    }

    public ImportConfigurationTableModel() {
        super(ImportConfigurationBean.class);
        this.setEditable();
        this.addTableModelListener(this);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int fileNameColumn = -1;
        int fileTypeColumn = -1;
        int columnCount = this.getColumnCount();
        int c = 0;
        while (c < columnCount) {
            switch (this.getColumnName(c)) {
                case "fileName": {
                    fileNameColumn = c;
                    break;
                }
                case "fileType": {
                    fileTypeColumn = c;
                }
            }
            if (fileNameColumn >= 0 && fileTypeColumn >= 0) break;
            ++c;
        }
        int type = e.getType();
        if (type == 0) {
            int i;
            String fileExtension;
            ImportConfigurationBean bean;
            String fileName;
            int firstRow = e.getFirstRow();
            int column = e.getColumn();
            if (firstRow >= 0 && column == fileNameColumn && !StringUtility.isEmpty(fileName = (bean = (ImportConfigurationBean)this.getValue(firstRow)).getFileName()) && Comparison.isIn((fileExtension = fileName.substring((i = fileName.lastIndexOf(46)) + 1)).toUpperCase(), DPEnumerations.IMPORT_FORMAT)) {
                this.setValueAt(fileExtension, firstRow, fileTypeColumn);
            }
        }
    }

    @Override
    public void addDroppedFile(File file) {
        if (file.isDirectory()) {
            this.addDroppedDirectory(file);
            return;
        }
        ImportConfigurationBean newRow = new ImportConfigurationBean(file.getAbsolutePath());
        this.addRow(newRow);
    }

    private void addDroppedDirectory(File droppedDirectory) {
        File[] files;
        if (!droppedDirectory.isDirectory()) {
            return;
        }
        File[] fileArray = files = droppedDirectory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            this.addDroppedFile(file);
            ++n2;
        }
    }
}

