/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.panel;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.dialog.DialogPanel;
import com.jmorgan.swing.dialog.GenericDialog;
import com.jmorgan.swing.event.ListSelectionEventInvoker;
import com.jmorgan.swing.layout.EastWestLayout;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.util.Index;
import com.jmorgan.util.Pair;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.SearchOptions;
import com.kumbasoft.core.ui.AbstractTablePanel;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.util.FileUtility;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JFrame;
import javax.swing.ListModel;

public abstract class AbstractSearchOptionsPanel<BeanType extends SearchOptions>
extends AbstractTablePanel<BeanType>
implements DialogPanel {
    private GenericDialog parentDialog;
    protected JMListModel<String> listModel;
    protected JMList<String> list;
    protected Index<String, BeanType> savedSearches;
    protected JMButton btnDeleteSaved;
    protected JMPanel leftControls;
    protected JMPanel rightControls;
    private JMButton btnAdd;
    private JMButton btnDelete;
    private JMButton btnClear;
    private JMTextField tfSearchName;
    private JMButton btnSave;
    private JMButton btnOK;
    private JMButton btnCancel;
    private File searchSettingsDirectory;
    private boolean isDirty;

    public AbstractSearchOptionsPanel(Class<BeanType> elementType) {
        super(elementType);
    }

    public AbstractSearchOptionsPanel(Class<BeanType> elementType, Object ... arguments) {
        super(elementType, arguments);
        this.add((Component)this.createTopControlsPanel(), "North");
        this.add((Component)this.createBottomControlsPanel(), "South");
    }

    @Override
    protected JMPanel createLeftPanel() {
        JMPanel panel = KumbaCoreUIConstants.createBorderLayoutPanel();
        this.savedSearches = new Index();
        File savedSearchesDirectory = this.getSearchSettingsDirectory();
        File[] allFiles = savedSearchesDirectory.listFiles();
        ArrayList<String> savedNames = new ArrayList<String>();
        File[] fileArray = allFiles;
        int n = allFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (this.isFileNameApplicable(file.getName())) {
                Pair savedSearch = (Pair)FileUtility.readObject(file, true);
                String savedName = (String)savedSearch.first;
                savedNames.add(savedName);
                this.savedSearches.put((String)savedSearch.first, (Collection)savedSearch.second);
            }
            ++n2;
        }
        Collections.sort(savedNames);
        this.listModel = new JMListModel();
        this.list = new JMList<String>((ListModel<String>)this.listModel);
        this.list.setPreferredSize(250, 350);
        new ListSelectionEventInvoker(this.list, this, "fileOpen");
        this.listModel.addAll(savedNames);
        this.listModel.setOrdered(true);
        panel.add(new JMScrollPane(this.list));
        return panel;
    }

    protected boolean isFileNameApplicable(String fileName) {
        return true;
    }

    protected JMPanel createTopControlsPanel() {
        boolean hasData = this.tableModel.getRowCount() > 0;
        JMLabel savedLabel = new JMLabel("Saved Searches");
        this.btnDeleteSaved = ComponentFactory.createButton(KumbaCoreUIConstants.DELETE_ICON, null, "Delete Selected Saved Search", this.listModel.getSize() > 0, this, "deleteSavedSearch", new Object[0]);
        this.btnAdd = ComponentFactory.createButton(KumbaCoreUIConstants.ADD_ICON, null, "Add a new row", true, this, "editAdd", new Object[0]);
        this.btnDelete = ComponentFactory.createButton(KumbaCoreUIConstants.DELETE_ICON, null, "Delete all or selected rows", hasData, this, "editDelete", new Object[0]);
        this.btnClear = ComponentFactory.createButton(KumbaCoreUIConstants.CLEAR_ICON, null, "Clear the search options", hasData, this, "editClear", new Object[0]);
        this.tfSearchName = new JMTextField(10);
        LabeledComponent lblSearchName = new LabeledComponent("Save as Name:", (Component)this.tfSearchName);
        this.btnSave = ComponentFactory.createButton(KumbaCoreUIConstants.SAVE_ICON, null, "Save the current set of search options", hasData, this, "fileSave", new Object[0]);
        this.leftControls = new JMPanel(new FlowLayout(0));
        this.leftControls.addAll(savedLabel, ComponentFactory.createSpacer(this.getTopControlsButtonSpacerWidth(), 16), this.btnDeleteSaved, ComponentFactory.createSpacer(5, 16), this.btnAdd, this.btnDelete, this.btnClear);
        this.rightControls = new JMPanel(new FlowLayout(2));
        this.rightControls.addAll(lblSearchName, this.btnSave);
        JMPanel panel = new JMPanel(new EastWestLayout());
        panel.add((Component)this.leftControls, "west");
        panel.add((Component)this.rightControls, "east");
        return panel;
    }

    protected int getTopControlsButtonSpacerWidth() {
        return 110;
    }

    protected JMPanel createBottomControlsPanel() {
        this.btnOK = ComponentFactory.createButton(null, "Apply && Close", "Apply the search options and close", true, this, "okClicked", new Object[0]);
        this.btnCancel = ComponentFactory.createButton(null, "Cancel", "Cancel - Don't apply these search options - Keep the previous set.", true, this, "cancelClicked", new Object[0]);
        JMPanel panel = new JMPanel();
        panel.addAll(ComponentFactory.createSpacer(252, 16), this.btnOK, this.btnCancel);
        return panel;
    }

    @Override
    public boolean isPopupReady() {
        int selectedRowCount = this.displayTable.getSelectedRowCount();
        this.popupMenu.setMenuItemEnabled("[Dd]elete.*", selectedRowCount > 0);
        return true;
    }

    protected File getSearchSettingsDirectory() {
        if (this.searchSettingsDirectory == null) {
            String settingsDirectoryName = this.getSearchSettingsDirectoryName();
            this.searchSettingsDirectory = new File(settingsDirectoryName);
        }
        return this.searchSettingsDirectory;
    }

    protected abstract String getSearchSettingsDirectoryName();

    @Reflected
    private void fileOpen() {
        this.displayTable.commitEdits();
        this.displayTable.clearSelection();
        this.tableModel.reset();
        this.setButtonState(false);
        if (this.list.getSelectedIndex() == -1) {
            this.displayTable.repaint();
            return;
        }
        String selectedName = this.list.getSelectedItem();
        File file = new File(this.searchSettingsDirectory, this.getFileNamePrefix() + selectedName + ".dat");
        if (!file.exists()) {
            new JMMessageBox((JFrame)frame, selectedName + " Does Not Exist!", "Was it deleted since this screen was opened?");
            return;
        }
        Pair searchData = (Pair)FileUtility.readObject(file, true);
        this.tfSearchName.setText((String)searchData.first);
        ArrayList options = (ArrayList)searchData.second;
        this.tableModel.addAll(options);
        if (!this.listModel.contains(selectedName)) {
            this.listModel.addElement(selectedName);
        }
        this.setButtonState(this.tableModel.getRowCount() > 0);
    }

    @Reflected
    private void fileSave() {
        this.displayTable.commitEdits();
        String searchName = this.tfSearchName.getText();
        if (StringUtility.isEmpty(searchName)) {
            return;
        }
        File file = new File(this.searchSettingsDirectory, this.getFileNamePrefix() + searchName + ".dat");
        if (file.exists()) {
            new JMMessageBox((JFrame)frame, searchName + " exists!", "Do you want to overwrite the existing search?", 12);
            if (JMMessageBox.getSelection() == 8) {
                return;
            }
        }
        ArrayList options = this.tableModel.getModelData();
        Pair searchData = new Pair(searchName, options);
        FileUtility.writeObject(file, searchData, true);
        if (!this.listModel.contains(searchName)) {
            this.listModel.addElement(searchName);
        }
        this.savedSearches.put(searchName, options);
        this.btnDeleteSaved.setEnabled(this.listModel.getSize() > 0);
        this.isDirty = false;
    }

    protected String getFileNamePrefix() {
        return "";
    }

    @Reflected
    private void editAdd() {
        this.isDirty = true;
        this.displayTable.commitEdits();
        this.tableModel.addRow(this.createRowInstance());
        this.setButtonState(true);
    }

    protected abstract BeanType createRowInstance();

    @Reflected
    private void deleteSavedSearch() {
        logger.finer("(): Starting");
        if (this.listModel.getSize() == 0) {
            logger.finer("(): No saved searches. This should not be possible!  Returning.");
            return;
        }
        String searchName = this.list.getSelectedItem();
        File file = new File(this.searchSettingsDirectory, this.getFileNamePrefix() + searchName + ".dat");
        logger.finer(() -> LMG.log("(): File for '%s' is '%s'.", () -> searchName, () -> file.getAbsolutePath()));
        if (file.exists()) {
            new JMMessageBox((JFrame)frame, "Delete " + searchName + "?", "Do you want to delete the existing search?", 12);
            if (JMMessageBox.getSelection() == 8) {
                logger.finer(() -> LMG.log("(): User rejected delete of file for '%s'.  Retruning.", () -> searchName));
                return;
            }
            logger.finer(() -> LMG.log("(): Deleting file '%s'.", () -> searchName, () -> file.getAbsolutePath()));
            file.delete();
        }
        int itemIndex = this.list.getSelectedIndex();
        logger.finer(() -> LMG.log("(): Removing search item '%s' at index %d.", () -> searchName, () -> itemIndex));
        this.listModel.removeElement(itemIndex);
        this.btnDeleteSaved.setEnabled(this.listModel.getSize() > 0);
        logger.finer("(): Done");
    }

    @Reflected
    private void editDelete() {
        this.isDirty = true;
        this.displayTable.commitEdits();
        this.displayTable.deleteSelected("Delete Selected Rows", "Are you sure you want to delete the selected rows");
        this.setButtonState(this.tableModel.getRowCount() > 0);
    }

    @Reflected
    private void editClear() {
        this.displayTable.commitEdits();
        this.displayTable.clearSelection();
        this.tableModel.reset();
        this.setButtonState(false);
        this.displayTable.repaint();
    }

    @Reflected
    private void okClicked() {
        this.displayTable.commitEdits();
        if (this.updateSearchOptionsFromTable()) {
            this.parentDialog.closeDialog();
        }
    }

    protected abstract boolean updateSearchOptionsFromTable();

    @Reflected
    private void cancelClicked() {
        this.parentDialog.closeDialog();
    }

    protected void setButtonState(boolean buttonState) {
        this.btnDelete.setEnabled(buttonState);
        this.btnClear.setEnabled(buttonState);
        this.btnSave.setEnabled(buttonState);
    }

    @Override
    public BeanTableModel<BeanType> getTableModel() {
        BeanTableModel model = super.getTableModel();
        model.setEditable();
        return model;
    }

    @Override
    public void setParentDialog(GenericDialog dialog) {
        this.parentDialog = dialog;
    }

    @Override
    public boolean parentDialogClosing() {
        return true;
    }
}

