/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.panel;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.io.FileInputStreamHelper;
import com.jmorgan.io.FileOutputStreamHelper;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.ExceptionListenerClient;
import com.jmorgan.swing.JMButtonGroup;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMPasswordField;
import com.jmorgan.swing.JMRadioButton;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.NumberField;
import com.jmorgan.swing.ScrollablePanel;
import com.jmorgan.swing.combobox.ListComboBox;
import com.jmorgan.swing.component.OptionsMenuButton;
import com.jmorgan.swing.decorator.TOCDecorator;
import com.jmorgan.swing.event.ComponentEventInvoker;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.swing.spinner.NumberSpinner;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.swing.util.LabelUtility;
import com.jmorgan.swing.util.VisualComponentEditor;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreGUIApplicationProperties;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.util.FileUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;

public class ConfigureObjectPanel
extends AbstractPanel {
    private static final int LABEL_WIDTH = 200;
    private static final int BOOLEAN_FIELD_WIDTH = 20;
    private static final int TEXT_FIELD_WIDTH = 400;
    private static final int NUMBER_FIELD_WIDTH = 150;
    private static HashMap<String, HashMap<String, String>> referenceMap;
    private static File uiPreferencesDirectory;
    private static final String[] EXEMPT_PROPERTIES;
    private Index<Appliance, Domain> selectedDomains;
    private JMPanel topPanel;
    private JMPanel controlsPanel;
    private JMScrollPane scrollPane;
    private File uiSettingsFile;
    private HashMap<String, LabeledComponent> uiComponents;
    private HashMap<String, VisualComponentEditor> uiEditors;
    private boolean uiCreated;
    private DataPowerConfig configObject;
    private String[] hiddenFields;
    private boolean resizing;

    static {
        EXEMPT_PROPERTIES = new String[]{"appliance", "sourceDomain", "quiesceState", "isLocal", "isExternal", "isReadOnly", "isIntrinsic", "configObjectType"};
        KumbaCoreGUIApplicationProperties appProps = (KumbaCoreGUIApplicationProperties)Application.getApplication().getApplicationProperties();
        String uiPreferencesDirectoryName = appProps.getUiPreferencesDirectory();
        uiPreferencesDirectory = new File(uiPreferencesDirectoryName);
        String objectReferenceMapFileName = appProps.getObjectReferenceMapFile();
        ExceptionListenerClient exceptionListenerClient = new ExceptionListenerClient();
        referenceMap = (HashMap)FileUtility.readObject(objectReferenceMapFileName, (ExceptionListener)exceptionListenerClient);
        if (exceptionListenerClient.hasException()) {
            new JMMessageBox(null, "Failed to read object reference map file", "Cannot read object reference map file");
        }
    }

    public ConfigureObjectPanel(DataPowerConfig configObject) {
        this(configObject, null);
    }

    public ConfigureObjectPanel(DataPowerConfig configObject, String ... hiddenFields) {
        super(new BorderLayout());
        this.uiSettingsFile = new File(uiPreferencesDirectory, String.format("ConfigureObjectPanel%s%sUISettings.xcn", File.separator, configObject.getConfigObjectType()));
        this.topPanel = new JMPanel(new FlowLayout(2));
        OptionsMenuButton optionsMenuButton = new OptionsMenuButton(new TOCDecorator());
        optionsMenuButton.addMenuItem(null, "Enter Design Mode", this, "enterDesignMode");
        optionsMenuButton.addMenuItem(null, "Exit Design Mode", this, "exitDesignMode");
        this.topPanel.add(optionsMenuButton);
        this.add((Component)this.topPanel, "North");
        this.controlsPanel = new ScrollablePanel(null);
        this.scrollPane = KumbaCoreUIConstants.createScrollPane(this.controlsPanel);
        this.add((Component)this.scrollPane, "Center");
        this.hiddenFields = hiddenFields;
        this.setConfigObject(configObject);
        new ComponentEventInvoker(this, 8, (Object)this, "resizeComponents");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void applyConfiguration() {
        block28: for (String propertyName : this.uiComponents.keySet()) {
            Method accessorMethod = BeanService.getPropertyAccessor(this.configObject, propertyName);
            XMLInfo xmlInfo = (XMLInfo)BeanService.getMethodAnnotation(accessorMethod, XMLInfo.class);
            LabeledComponent component = this.uiComponents.get(propertyName);
            Component propertyEditor = component.getComponent();
            if (propertyEditor instanceof JMScrollPane) {
                JMScrollPane scrollPane = (JMScrollPane)propertyEditor;
                propertyEditor = scrollPane.getViewport().getView();
            }
            String editorClassName = StringUtility.getNthOfDelimited(propertyEditor.getClass().getName(), ".");
            AbstractPanel.logger.fine(() -> LMG.log("():  Editor class for property %s is %s", () -> propertyName, () -> editorClassName));
            block10 : switch (editorClassName) {
                case "JMTextField": {
                    String textBoxValue = ((JMTextField)propertyEditor).getText();
                    BeanService.setPropertyValue(this.configObject, propertyName, textBoxValue);
                    break;
                }
                case "JMPasswordField": {
                    String passwordValue = ((JMPasswordField)propertyEditor).getText();
                    BeanService.setPropertyValue(this.configObject, propertyName, passwordValue);
                    break;
                }
                case "JMCheckBox": {
                    JMCheckBox cbx = (JMCheckBox)propertyEditor;
                    boolean boolValue = cbx.isSelected();
                    BeanService.setPropertyValue(this.configObject, propertyName, boolValue);
                    break;
                }
                case "NumberSpinner": {
                    NumberSpinner ns = (NumberSpinner)propertyEditor;
                    NumberField nf = (NumberField)ns.getComponent();
                    long longValue = (long)nf.getNumber();
                    String numberType = xmlInfo.javaType();
                    if (numberType.equals("long")) {
                        BeanService.setPropertyValue(this.configObject, propertyName, longValue);
                        break;
                    }
                    if (numberType.equals("integer")) {
                        BeanService.setPropertyValue(this.configObject, propertyName, (int)longValue);
                        break;
                    }
                    BigInteger bigN = BigInteger.valueOf(longValue);
                    BeanService.setPropertyValue(this.configObject, propertyName, bigN);
                    break;
                }
                case "JMRadioButton": {
                    System.out.printf("ConfigureObjectPanel.applyConfiguration():  JMRadioButton standing alone for property %s of %s\n", propertyName, this.configObject.getClass().getName());
                    break;
                }
                case "JMList": {
                    JMList list = (JMList)propertyEditor;
                    if (list.getSelectionMode() == 2) {
                        String javaType;
                        List selectedValues = list.getSelectedValuesList();
                        switch (javaType = xmlInfo.javaType()) {
                            case "String": {
                                ArrayList<String> stringElements = new ArrayList<String>(selectedValues.size());
                                Iterator iterator = selectedValues.iterator();
                                while (true) {
                                    if (!iterator.hasNext()) {
                                        BeanService.setPropertyValue(this.configObject, propertyName, stringElements);
                                        break block10;
                                    }
                                    Object o = iterator.next();
                                    String stringElement = (String)o;
                                    stringElements.add(stringElement);
                                }
                            }
                            case "ObjectReference": {
                                ArrayList referenceElements = new ArrayList(selectedValues.size());
                                Iterator iterator = selectedValues.iterator();
                                while (true) {
                                    if (!iterator.hasNext()) {
                                        BeanService.setPropertyValue(this.configObject, propertyName, referenceElements);
                                        break block10;
                                    }
                                    Object o = iterator.next();
                                    String selectedObject = (String)o;
                                    ObjectReference objectReference = new ObjectReference();
                                    String objectReferenceType = this.getObjectReferenceType(propertyName);
                                    objectReference.setClassName(objectReferenceType);
                                    objectReference.setName(selectedObject);
                                    referenceElements.add(objectReference);
                                }
                            }
                        }
                        System.out.printf("ConfigureObjectPanel.applyConfiguration():  Handle ArrayList type %s for property %s of %s\n", javaType, propertyName, this.configObject.getClass().getName());
                        break;
                    }
                    String selectedValue = (String)list.getSelectedValue();
                    BeanService.setPropertyValue(this.configObject, propertyName, selectedValue);
                    break;
                }
                case "ListComboBox": {
                    String selectedValue;
                    ListComboBox lcbx = (ListComboBox)propertyEditor;
                    if (xmlInfo.isEnumeration()) {
                        int selectedIndex = lcbx.getSelectedIndex();
                        if (selectedIndex <= 0) continue block28;
                        String[] enumeratedValues = ConfigureObjectPanel.getEnumeratedValues(propertyName, xmlInfo);
                        String enumeratedValue = enumeratedValues[selectedIndex];
                        BeanService.setPropertyValue(this.configObject, propertyName, enumeratedValue);
                        break;
                    }
                    if (!xmlInfo.javaType().equals("ObjectReference") || (selectedValue = (String)lcbx.getSelectedValue()) == null) continue block28;
                    ObjectReference objectReference = new ObjectReference();
                    String objectReferenceType = this.getObjectReferenceType(propertyName);
                    objectReference.setClassName(objectReferenceType);
                    objectReference.setName(selectedValue);
                    BeanService.setPropertyValue(this.configObject, propertyName, objectReference);
                    break;
                }
                case "JMPanel": {
                    JMPanel panel = (JMPanel)propertyEditor;
                    Component[] components = panel.getComponents();
                    String selectedEnumValue = null;
                    Component[] componentArray = components;
                    int n = components.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JMRadioButton radioButton;
                        Component c = componentArray[n2];
                        if (c instanceof JMRadioButton && (radioButton = (JMRadioButton)c).isSelected()) {
                            selectedEnumValue = radioButton.getName();
                            break;
                        }
                        ++n2;
                    }
                    if (selectedEnumValue == null) continue block28;
                    BeanService.setPropertyValue(this.configObject, propertyName, selectedEnumValue);
                    break;
                }
                default: {
                    System.out.printf("ConfigureObjectPanel.applyConfiguration(): Handle component type %s for property %s of %s\n", editorClassName, propertyName, this.configObject.getClass().getName());
                }
            }
        }
    }

    @Reflected
    private void resizeComponents() {
        if (this.resizing) {
            return;
        }
        this.resizing = true;
        Dimension thisSize = this.getSize();
        Dimension topSize = this.topPanel.getSize();
        Dimension controlPanelSize = this.controlsPanel.getSize();
        int cpWidth = thisSize.width - this.scrollPane.getVerticalScrollBar().getWidth();
        int cpHeight = thisSize.height - topSize.height - this.scrollPane.getHorizontalScrollBar().getHeight();
        Dimension cpDim = new Dimension(cpWidth, cpHeight);
        if (cpDim.width < controlPanelSize.width) {
            cpDim.width = controlPanelSize.width;
        }
        if (cpDim.height < controlPanelSize.height) {
            cpDim.height = controlPanelSize.height;
        }
        this.controlsPanel.setSize(cpDim);
        this.controlsPanel.setPreferredSize(cpDim);
        this.scrollPane.setSize(thisSize);
        this.scrollPane.setPreferredSize(thisSize);
        this.scrollPane.getViewport().setSize(thisSize);
        this.scrollPane.getViewport().setPreferredSize(thisSize);
        this.revalidate();
        this.repaint();
        this.resizing = false;
    }

    public DataPowerConfig getConfigObject() {
        return this.configObject;
    }

    public void setConfigObject(DataPowerConfig configObject) {
        if (configObject == null) {
            return;
        }
        this.configObject = configObject;
        if (!this.uiCreated) {
            this.buildUI();
        }
    }

    private void buildUI() {
        this.selectedDomains = ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection();
        ArrayList<String> objectProperties = BeanService.getPropertyNames(this.configObject);
        Collections.sort(objectProperties);
        this.uiComponents = new HashMap();
        this.uiEditors = new HashMap();
        HashMap<String, Rectangle> fieldPositions = this.readUIPreferences();
        boolean external = this.configObject.getIsExternal();
        boolean intrinsic = this.configObject.getIsIntrinsic();
        boolean readOnly = this.configObject.getIsReadOnly();
        boolean fieldsEnabled = !external && !intrinsic && !readOnly;
        int x = 10;
        int y = 10;
        int maxWidth = 0;
        for (String propertyName : objectProperties) {
            LabeledComponent component;
            if (Comparison.isIn(propertyName, EXEMPT_PROPERTIES) || !ArrayUtility.isEmpty(this.hiddenFields) && Comparison.isIn(propertyName, this.hiddenFields) || (component = this.getComponentFor(propertyName)) == null) continue;
            component.setEnabled(fieldsEnabled);
            this.uiComponents.put(propertyName, component);
            VisualComponentEditor editor = new VisualComponentEditor(component);
            editor.setEnabled(false);
            this.uiEditors.put(propertyName, editor);
            int width = component.getPreferredSize().width;
            int height = component.getPreferredSize().height;
            Rectangle fieldPosition = null;
            if (fieldPositions == null) {
                fieldPosition = new Rectangle(x, y, width, height);
            } else {
                fieldPosition = fieldPositions.get(propertyName);
                if (fieldPosition == null) {
                    fieldPosition = new Rectangle(x, y, width, height);
                }
            }
            component.setBounds(fieldPosition);
            this.controlsPanel.add(component);
            int fieldY = fieldPosition.y + fieldPosition.height + 10;
            if (fieldY > y) {
                y = fieldY;
            }
            if ((width = fieldPosition.x + fieldPosition.width) <= maxWidth) continue;
            maxWidth = width;
        }
        this.setPreferredSize(maxWidth + 10, y + 10);
        this.uiCreated = true;
    }

    private LabeledComponent getComponentFor(String propertyName) {
        Class<?> propertyType = BeanService.getPropertyType(this.configObject, propertyName);
        Method accessor = BeanService.getPropertyAccessor(this.configObject, propertyName);
        XMLInfo xmlInfo = (XMLInfo)BeanService.getMethodAnnotation(accessor, XMLInfo.class);
        if (xmlInfo == null) {
            return null;
        }
        int multiplicity = xmlInfo.multiplicity();
        AbstractPanel.logger.finer(() -> LMG.log("(propertyName=%s): Property Type: %s", () -> propertyName, () -> propertyType));
        String requiredIndicator = xmlInfo.isRequired() ? "&nbsp;<span style=\"color: red\">*</span>" : "";
        String label = String.format(LabelUtility.wrapInHTML("&nbsp;%s%s:"), StringUtility.getDisplayableTitle(propertyName), requiredIndicator);
        LabeledComponent component = null;
        switch (propertyType.getName()) {
            case "java.lang.Boolean": {
                boolean booleanValue = (Boolean)BeanService.getPropertyValue(this.configObject, propertyName);
                JMCheckBox cbx = new JMCheckBox();
                cbx.setSelected(booleanValue);
                component = new LabeledComponent(label, (Component)cbx, 2, 200, 20);
                break;
            }
            case "java.lang.String": {
                String stringValue = (String)BeanService.getPropertyValue(this.configObject, propertyName);
                if (stringValue == null) {
                    stringValue = "";
                }
                String[] enumeratedValues = null;
                if (xmlInfo.isEnumeration() && (enumeratedValues = ConfigureObjectPanel.getEnumeratedValues(propertyName, xmlInfo)) != null) {
                    component = ConfigureObjectPanel.createEnumeratedValueComponent(propertyName, enumeratedValues, multiplicity, stringValue);
                }
                if (component != null) break;
                if (propertyName.equals("password")) {
                    component = new LabeledComponent(label, (Component)new JMPasswordField(stringValue), 1, 200, 400);
                    break;
                }
                JMTextField textField = new JMTextField(stringValue);
                component = new LabeledComponent(label, (Component)textField, 1, 200, 400);
                break;
            }
            case "java.lang.Integer": {
                int intValue = (Integer)BeanService.getPropertyValue(this.configObject, propertyName);
                NumberField intNF = new NumberField((double)intValue, "###0;-###0");
                NumberSpinner intNS = new NumberSpinner(intNF);
                component = new LabeledComponent(label, (Component)intNS, 1, 200, 150);
                break;
            }
            case "java.lang.Long": {
                long longValue = (Long)BeanService.getPropertyValue(this.configObject, propertyName);
                NumberField longNF = new NumberField((double)longValue, "###0;-###0");
                NumberSpinner longNS = new NumberSpinner(longNF);
                component = new LabeledComponent(label, (Component)longNS, 1, 200, 150);
                break;
            }
            case "java.math.BigInteger": {
                BigInteger bi = (BigInteger)BeanService.getPropertyValue(this.configObject, propertyName);
                NumberField bigIntNF = new NumberField((double)bi.longValue(), "#,##0;-#,##0");
                NumberSpinner bigIntNS = new NumberSpinner(bigIntNF);
                component = new LabeledComponent(label, (Component)bigIntNS, 1, 200, 150);
                break;
            }
            case "com.kumbasoft.core.beans.ObjectReference": {
                ObjectReference objectReference = (ObjectReference)BeanService.getPropertyValue(this.configObject, propertyName);
                String referenceName = objectReference == null ? "" : objectReference.getName();
                String referenceObjectType = this.getObjectReferenceType(propertyName);
                ListComboBox lcbx = new ListComboBox();
                JMList list = (JMList)lcbx.getList();
                JMListModel model = (JMListModel)list.getModel();
                component = new LabeledComponent(label, (Component)lcbx, 1, 200, 400);
                new AsynchMethodInvoker(ConfigureObjectPanel.class, "loadListModel", new Object[]{this.selectedDomains, referenceObjectType, list, model, referenceName});
                break;
            }
            case "java.util.ArrayList": {
                String xmlInfoJavaType = xmlInfo.javaType();
                String referenceType = this.getObjectReferenceType(propertyName);
                AbstractPanel.logger.fine(() -> LMG.log("(propertyName=%s):  xmlInfoJavaType=%s, referenceType=%s", () -> propertyName, () -> xmlInfoJavaType, () -> referenceType));
                if (xmlInfoJavaType.equals("ObjectReference")) {
                    JMListModel referenceModel = new JMListModel();
                    JMList referenceList = new JMList(referenceModel);
                    referenceList.setSelectionMode(2);
                    new AsynchMethodInvoker(ConfigureObjectPanel.class, "loadListModel", new Object[]{this.selectedDomains, referenceType, referenceList, referenceModel, ""});
                    component = new LabeledComponent(label, (Component)KumbaCoreUIConstants.createScrollPane(referenceList), 1, 200, 400);
                    break;
                }
                try {
                    String javaType = String.format("%s.%s", "com.kumbasoft.core.beans.types", xmlInfoJavaType);
                    Class<?> javaClass = Class.forName(javaType);
                    BeanTableModel tableModel = new BeanTableModel(javaClass);
                    BeanColumnModel columnModel = new BeanColumnModel(javaClass);
                    ConfigureObjectPanel.setupReferenceColumnModel(tableModel, columnModel, javaClass);
                    JMTable table = new JMTable(tableModel, columnModel);
                    ArrayList values = (ArrayList)BeanService.getPropertyValue(this.configObject, propertyName);
                    if (values != null) {
                        tableModel.addAll(values);
                    }
                    component = new LabeledComponent(label, (Component)KumbaCoreUIConstants.createScrollPane(table), 1, 200, 400);
                    break;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        if (component == null) {
            AbstractPanel.logger.fine(() -> LMG.log("(propertyName=%s):  Component is null", () -> propertyName));
        }
        return component;
    }

    private static void setupReferenceColumnModel(BeanTableModel tableModel, BeanColumnModel columnModel, Class<?> javaClass) {
        ArrayList<String> propertyNames = BeanService.getPropertyNames(javaClass);
        for (String propertyName : propertyNames) {
            Class<?> propertyType = BeanService.getPropertyType(javaClass, propertyName);
            if (!propertyType.getName().equals("com.kumbasoft.core.beans.ObjectReference")) continue;
            tableModel.setValueExpression(propertyName, "name");
        }
    }

    private static String[] getEnumeratedValues(String propertyName, XMLInfo xmlInfo) {
        String enumType = xmlInfo.dataPowerType();
        String[] enumeratedValues = DPEnumerations.getEnumeratedValues(enumType);
        if (enumeratedValues == null) {
            AbstractPanel.logger.severe(() -> LMG.log("(propertyName=%s): Enumerated Values for %s is not found", () -> propertyName, () -> enumType));
        }
        return enumeratedValues;
    }

    private String getObjectReferenceType(String propertyName) {
        HashMap<String, String> propertyMap = referenceMap.get(this.configObject.getClass().getName());
        String referenceType = propertyMap.get(propertyName);
        if (referenceType == null) {
            AbstractPanel.logger.fine(() -> LMG.log("(propertyName=%s):  Reference type not mapped for %s", () -> propertyName, () -> this.configObject.getClass().getName()));
            return null;
        }
        int lastDot = referenceType.lastIndexOf(46);
        String referenceBaseType = referenceType.substring(lastDot + 7);
        return referenceBaseType;
    }

    @Reflected
    private static void loadListModel(Index<Appliance, Domain> selectedDomains, String objectType, JMList list, JMListModel listModel, String currentValue) {
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<StatusObjectStatus> referenceObjects = configurationManager.listObjects(selectedDomains, "^" + objectType + "$", ".*");
        UniqueArrayList<String> referenceObjectNames = new UniqueArrayList<String>(referenceObjects.size() + 1);
        referenceObjectNames.add("  ");
        for (StatusObjectStatus sos : referenceObjects) {
            referenceObjectNames.add(sos.getName());
        }
        referenceObjectNames.sort();
        listModel.addAll(referenceObjectNames);
        if (currentValue != null) {
            list.setSelectedValue(currentValue, true);
        }
    }

    private static LabeledComponent createEnumeratedValueComponent(String propertyName, String[] values, int multiplicity, String value) {
        LabeledComponent component = null;
        String componentLabel = StringUtility.getDisplayableTitle(propertyName);
        if (multiplicity == 1) {
            if (values.length < 6) {
                JMButtonGroup buttonGroup = new JMButtonGroup();
                LayoutManager layoutManager = null;
                layoutManager = values.length < 3 ? new FlowLayout(0) : new VerticalFlowLayout(0);
                JMPanel panel = new JMPanel(layoutManager);
                String[] stringArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String v = stringArray[n2];
                    String label = StringUtility.getDisplayableTitle(v);
                    JMRadioButton rb = new JMRadioButton(label);
                    rb.setName(v);
                    rb.setSelected(v.equals(value));
                    buttonGroup.add((AbstractButton)rb);
                    panel.add(rb);
                    ++n2;
                }
                component = new LabeledComponent(componentLabel, (Component)panel, 1, 200, 400);
            } else {
                Object[] labels = new String[values.length];
                int i = 0;
                while (i < values.length) {
                    labels[i] = StringUtility.getDisplayableTitle(values[i]);
                    ++i;
                }
                ListComboBox listComboBox = new ListComboBox(labels);
                component = new LabeledComponent(componentLabel, (Component)listComboBox, 1, 200, 400);
            }
        } else {
            String[] displayValues = new String[values.length];
            int i = 0;
            while (i < values.length) {
                displayValues[i] = StringUtility.getDisplayableTitle(values[i]);
                ++i;
            }
            JMList<String> list = new JMList<String>((ElementType[])values);
            list.setSelectionMode(2);
            JMScrollPane scrollPane = KumbaCoreUIConstants.createScrollPane(list);
            component = new LabeledComponent(componentLabel, (Component)scrollPane, 1, 200, 400);
        }
        return component;
    }

    @Reflected
    private void enterDesignMode() {
        for (String propertyName : this.uiEditors.keySet()) {
            VisualComponentEditor editor = this.uiEditors.get(propertyName);
            editor.setEnabled(true);
        }
    }

    @Reflected
    private void exitDesignMode() {
        HashMap<String, Rectangle> fieldPositions = new HashMap<String, Rectangle>();
        for (String propertyName : this.uiEditors.keySet()) {
            VisualComponentEditor editor = this.uiEditors.get(propertyName);
            editor.setEnabled(false);
            Component component = this.uiComponents.get(propertyName);
            Rectangle r = component.getBounds();
            fieldPositions.put(propertyName, r);
        }
        this.writeUIPreferences(fieldPositions);
    }

    private void writeUIPreferences(HashMap<String, Rectangle> fieldPositions) {
        FileOutputStreamHelper fout = new FileOutputStreamHelper(this.uiSettingsFile);
        fout.open();
        XMLEncoder encoder = new XMLEncoder((OutputStream)fout.getStream());
        encoder.writeObject(fieldPositions);
        encoder.flush();
        encoder.close();
        fout.close();
    }

    private HashMap<String, Rectangle> readUIPreferences() {
        if (!this.uiSettingsFile.exists()) {
            return null;
        }
        FileInputStreamHelper fin = new FileInputStreamHelper(this.uiSettingsFile);
        fin.open();
        XMLDecoder decoder = new XMLDecoder((InputStream)fin.getStream());
        HashMap fieldPositions = (HashMap)decoder.readObject();
        decoder.close();
        fin.close();
        return fieldPositions;
    }
}

