/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.panel.logs;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.rules.PropertyValueRule;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.component.AccordionComponent;
import com.jmorgan.swing.dialog.DialogPanel;
import com.jmorgan.swing.dialog.GenericDialog;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.event.ListSelectionEventInvoker;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreApplicationProperties;
import com.kumbasoft.core.beans.LogFilterEventListener;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.panel.logs.CustomQuickFilter;
import com.kumbasoft.core.ui.panel.logs.CustomQuickFiltersPanel;
import com.kumbasoft.core.util.FileUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Label;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public abstract class AbstractLogFiltersComponent<LogEntryType>
extends AbstractPanel {
    private final ReadWriteLock LOCK = new ReentrantReadWriteLock();
    protected ArrayList<String> filterTitles;
    protected ArrayList<String> filterProperties;
    private JMButton btnCustomFilterSettings;
    private JMButton btnClearFilters;
    private AccordionComponent accordionControl;
    protected HashMap<String, String> accordionFilterProperties;
    protected BeanTableModel<LogEntryType> tableModel;
    protected HashMap<String, JMListModel<String>> accordionListModels;
    private HashMap<String, JMList<String>> accordionLists;
    private ArrayList<CustomQuickFilter> customQuickFilters;
    private boolean filterListItemChanging;
    private ArrayList<LogFilterEventListener<LogEntryType>> logFilterEventListeners;

    public AbstractLogFiltersComponent() {
        super(new BorderLayout());
        this.loadCustomQuickFilters();
        this.filterTitles = this.getFilterTitles();
        this.filterProperties = this.getFilterProperties();
        for (CustomQuickFilter customQuickFilter : this.customQuickFilters) {
            this.filterTitles.add(customQuickFilter.getTitle());
            this.filterProperties.add(customQuickFilter.getRegex());
        }
        this.createControls();
    }

    protected void createControls() {
        this.accordionControl = new AccordionComponent();
        this.accordionFilterProperties = new HashMap();
        this.accordionListModels = new HashMap();
        this.accordionLists = new HashMap();
        int i = 0;
        while (i < this.filterTitles.size()) {
            String filterTitle = this.filterTitles.get(i);
            String filterProperty = this.filterProperties.get(i);
            this.addQuickFilterSection(filterTitle, filterProperty);
            ++i;
        }
        this.accordionControl.setPreferredSize(150, 200);
        this.accordionControl.setSize(150, 200);
        this.btnCustomFilterSettings = new JMButton(KumbaCoreUIConstants.EDIT_ICON, "Custom Filter Settings...");
        new ActionEventInvoker(this.btnCustomFilterSettings, this, "manageCustomQuickFilters");
        this.btnClearFilters = new JMButton(KumbaCoreUIConstants.FILTER_CLEAR_ICON, "Clear Filters");
        this.btnClearFilters.setEnabled(false);
        new ActionEventInvoker(this.btnClearFilters, this, "clearQuickFilters");
        JMPanel buttonPanel = new JMPanel(new FlowLayout(2, 5, 1));
        buttonPanel.addAll(this.btnCustomFilterSettings, this.btnClearFilters);
        Label label = new Label("Quick Filters");
        JMPanel topPanel = new JMPanel(new BorderLayout());
        topPanel.add((Component)label, "Center");
        topPanel.add((Component)buttonPanel, "East");
        JMPanel quickFiltersPanel = KumbaCoreUIConstants.createBorderLayoutPanel();
        quickFiltersPanel.add((Component)topPanel, "North");
        quickFiltersPanel.add((Component)this.accordionControl, "Center");
        this.add((Component)quickFiltersPanel, "Center");
    }

    private void addQuickFilterSection(String filterTitle, String filterProperty) {
        JMListModel listModel = new JMListModel();
        listModel.setOrdered(true);
        JMList list = new JMList(listModel);
        new ListSelectionEventInvoker(list, this, "filterListItemChanged", filterTitle);
        this.accordionFilterProperties.put(filterTitle, filterProperty);
        this.accordionListModels.put(filterTitle, listModel);
        this.accordionLists.put(filterTitle, list);
        this.accordionControl.addCategory(filterTitle, new JScrollPane(list));
    }

    public void setTableModel(BeanTableModel<LogEntryType> tableModel) {
        this.tableModel = tableModel;
    }

    private void loadCustomQuickFilters() {
        KumbaCoreApplicationProperties props = (KumbaCoreApplicationProperties)Application.getApplication().getApplicationProperties();
        String customFileFiltersFileName = props.getLogFiltersFile();
        this.customQuickFilters = (ArrayList)FileUtility.readObject(customFileFiltersFileName, true);
        if (this.customQuickFilters == null) {
            this.customQuickFilters = new ArrayList();
        } else {
            Collections.sort(this.customQuickFilters);
        }
    }

    protected abstract ArrayList<String> getFilterTitles();

    protected abstract ArrayList<String> getFilterProperties();

    @Reflected
    private void manageCustomQuickFilters() {
        HashMap<String, String> oldFilters = this.mapQuickFilters();
        CustomQuickFiltersPanel panel = new CustomQuickFiltersPanel(CustomQuickFilter.class, new Object[]{this.customQuickFilters});
        GenericDialog dialog = new GenericDialog((JFrame)AbstractPanel.frame, "Manage Quick Filters", (DialogPanel)panel, true);
        dialog.setSize(460, 400);
        dialog.setVisible(true);
        if (dialog.wasCancelled()) {
            return;
        }
        for (CustomQuickFilter filter : this.customQuickFilters) {
            String title = filter.getTitle();
            if (this.filterTitles.contains(title)) {
                String regex;
                String oldRegex = oldFilters.get(title);
                if (oldRegex.equals(regex = filter.getRegex())) {
                    logger.finer(() -> LMG.log("():  Filter '%s' is already added.  Skipping.", () -> title));
                    oldFilters.remove(title);
                    continue;
                }
                logger.finer(() -> LMG.log("():  Filter '%s' Changed.  Updating.", () -> title));
                this.accordionFilterProperties.put(title, regex);
                this.updateQuickFiltersFor(title);
                oldFilters.remove(title);
                continue;
            }
            logger.finer(() -> LMG.log("():  Adding new filter '%s'.", () -> title));
            this.filterTitles.add(title);
            this.filterProperties.add(filter.getRegex());
            this.addQuickFilterSection(title, filter.getRegex());
            this.updateQuickFiltersFor(title);
        }
        for (String oldFilterTitle : oldFilters.keySet()) {
            logger.finer(() -> LMG.log("():  Removing'%s'.", () -> oldFilterTitle));
            JMListModel<String> filterModel = this.accordionListModels.get(oldFilterTitle);
            filterModel.clear();
            this.accordionControl.removeCategory(oldFilterTitle);
            this.filterTitles.remove(oldFilterTitle);
            this.accordionListModels.remove(oldFilterTitle);
            this.accordionLists.remove(oldFilterTitle);
            this.accordionFilterProperties.remove(oldFilterTitle);
        }
        logger.finer("(): Done");
    }

    private HashMap<String, String> mapQuickFilters() {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        for (CustomQuickFilter filter : this.customQuickFilters) {
            filterMap.put(filter.getTitle(), filter.getRegex());
        }
        return filterMap;
    }

    @Reflected
    private void clearQuickFilters() {
        for (String filterTitle : this.filterTitles) {
            JMList<String> list = this.accordionLists.get(filterTitle);
            list.clearSelection();
        }
        this.btnClearFilters.setEnabled(false);
    }

    protected void resetQuickFilters() {
        for (String filterTitle : this.filterTitles) {
            JMList<String> list = this.accordionLists.get(filterTitle);
            list.clearSelection();
            this.LOCK.writeLock().lock();
            try {
                JMListModel<String> listModel = this.accordionListModels.get(filterTitle);
                listModel.clear();
            }
            finally {
                this.LOCK.writeLock().unlock();
            }
        }
        this.updateFilterTitleCounts();
        this.btnClearFilters.setEnabled(false);
    }

    public void updateFilterTitleCounts() {
        logger.finer("(): Starting");
        for (String filterTitle : this.filterTitles) {
            this.updateFilterTitleCounts(filterTitle);
        }
        logger.finer("(): Done");
    }

    private void updateFilterTitleCounts(String filterTitle) {
        logger.finer(() -> LMG.log("(filterTitle=%s): Starting", () -> filterTitle));
        JMButton button = this.accordionControl.getCategoryButton(filterTitle);
        if (button == null) {
            logger.finer(() -> LMG.log("(filterTitle=%s): No category button.  How?  Deleted???", () -> filterTitle));
            return;
        }
        int listSize = 0;
        this.LOCK.readLock().lock();
        try {
            JMListModel<String> listModel = this.accordionListModels.get(filterTitle);
            listSize = listModel.getSize();
            logger.finer(() -> LMG.log("(filterTitle=%s): Updating list size of to %d", () -> filterTitle, () -> listModel.getSize()));
        }
        finally {
            this.LOCK.readLock().unlock();
        }
        String newButtonTitle = listSize == 0 ? filterTitle : (listSize == 1 ? String.format("%d %s", listSize, filterTitle) : String.format("%d %s", listSize, StringUtility.pluralize(filterTitle)));
        button.setText(newButtonTitle);
        logger.finer(() -> LMG.log("(filterTitle=%s): Done", () -> filterTitle));
    }

    protected void loadQuickFilters(LogEntryType logEntry) {
        HashMap<String, String> filterMap = this.mapQuickFilters();
        for (String filterTitle : this.filterTitles) {
            if (filterMap.containsKey(filterTitle)) {
                this.handleQuickFilterMatch(logEntry, filterTitle);
                continue;
            }
            String filterProperty = this.accordionFilterProperties.get(filterTitle);
            Object propertyValue = BeanService.getPropertyValue(logEntry, filterProperty);
            if (propertyValue == null) continue;
            String valueToAdd = String.valueOf(propertyValue);
            this.LOCK.writeLock().lock();
            try {
                JMListModel<String> listModel = this.accordionListModels.get(filterTitle);
                if (listModel.contains(valueToAdd)) continue;
                listModel.addElement(valueToAdd);
            }
            finally {
                this.LOCK.writeLock().unlock();
            }
        }
    }

    protected void updateQuickFiltersFor(String filterTitle) {
        logger.finer(() -> LMG.log("(filterTitle='%s'): Starting", () -> filterTitle));
        int rowCount = this.tableModel.getRowCount();
        if (rowCount == 0) {
            logger.finer(() -> LMG.log("(filterTitle='%s'): No rows in the table. Nothing to do.", () -> filterTitle));
            return;
        }
        logger.finer(() -> LMG.log("(filterTitle='%s'): %d rows in the table. Processing.", () -> filterTitle, () -> rowCount));
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        this.showProgressBar(rowCount);
        JMListModel<String> listModel = this.accordionListModels.get(filterTitle);
        listModel.clear();
        ArrayList<LogEntryType> logEntries = this.tableModel.getModelData();
        for (LogEntryType logEntry : logEntries) {
            this.progressBar.incrementValue();
            this.handleQuickFilterMatch(logEntry, filterTitle);
        }
        this.updateFilterTitleCounts(filterTitle);
        this.hideProgressBar();
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
        logger.finer(() -> LMG.log("(filterTitle='%s'): Done", () -> filterTitle));
    }

    protected void handleQuickFilterMatch(LogEntryType logEntry, String filterTitle) {
        logger.finer(() -> LMG.log("(LogEntryType logEntry, filterTitle='%s'):  Starting", () -> filterTitle));
        String regex = this.accordionFilterProperties.get(filterTitle);
        Pattern pattern = Pattern.compile(regex);
        String message = (String)BeanService.getPropertyValue(logEntry, "message");
        Matcher matcher = pattern.matcher(message);
        logger.finer(() -> LMG.log("(LogEntryType logEntry, filterTitle='%s'):  Matching against expression: '%s'", () -> filterTitle, () -> regex));
        while (matcher.find()) {
            logger.finer(() -> LMG.log("(LogEntryType logEntry, filterTitle='%s'):  Entry matches expression: '%s'.  Extracting groups.", () -> filterTitle, () -> regex));
            int groupCount = matcher.groupCount();
            StringBuilder sb = new StringBuilder();
            int i = 1;
            while (i <= groupCount) {
                String matchedGroup = matcher.group(i);
                if (i > 1) {
                    sb.append(" ");
                }
                sb.append(matchedGroup);
                ++i;
            }
            String valueToAdd = groupCount == 0 ? message : sb.toString();
            logger.finer(() -> LMG.log("(LogEntryType logEntry, filterTitle='%s'):  Match to display: '%s'.  Adding if not already there.", () -> filterTitle, () -> valueToAdd));
            this.LOCK.writeLock().lock();
            try {
                JMListModel<String> listModel = this.accordionListModels.get(filterTitle);
                if (listModel.contains(valueToAdd)) continue;
                listModel.addElement(valueToAdd);
                logger.finer(() -> LMG.log("(LogEntryType logEntry, filterTitle='%s'):  Match to display: '%s'.  Added.", () -> filterTitle, () -> valueToAdd));
            }
            finally {
                this.LOCK.writeLock().unlock();
            }
        }
        logger.finer(() -> LMG.log("(LogEntryType logEntry, filterTitle='%s'):  Done", () -> filterTitle));
    }

    public void addLogFilterEventListener(LogFilterEventListener<LogEntryType> logFilterEventListener) {
        if (logFilterEventListener == null) {
            return;
        }
        if (this.logFilterEventListeners == null) {
            this.logFilterEventListeners = new ArrayList();
        }
        this.logFilterEventListeners.add(logFilterEventListener);
    }

    @Reflected
    private void filterListItemChanged(String selectedFilterTitle) {
        if (this.filterListItemChanging) {
            return;
        }
        for (LogFilterEventListener<LogEntryType> listener : this.logFilterEventListeners) {
            listener.logFilterChanging();
        }
        this.filterListItemChanging = true;
        JMList<String> selectedList = this.accordionLists.get(selectedFilterTitle);
        selectedList.repaint();
        HashMap<String, String> filterMap = this.mapQuickFilters();
        PropertyValueRule propertyValueRule = new PropertyValueRule();
        for (String string : this.filterTitles) {
            JMList<String> list = this.accordionLists.get(string);
            List selectedItems = list.getSelectedValuesList();
            int selectedItemCount = selectedItems.size();
            JMButton button = this.accordionControl.getCategoryButton(string);
            button.setIcon(selectedItemCount == 0 ? null : KumbaCoreUIConstants.FILTER_ICON);
            new AsynchMethodInvoker((Object)button, "repaint", 50);
            if (selectedItemCount == 0) continue;
            if (filterMap.containsKey(string)) {
                StringBuilder sb = new StringBuilder(".*?(");
                int i = 0;
                for (String item : selectedItems) {
                    if (i > 0) {
                        sb.append("|");
                    }
                    sb.append(item);
                    ++i;
                }
                sb.append(").*");
                propertyValueRule.addPropertyValueMap("message", (Object)sb.toString(), 6);
                continue;
            }
            String filterProperty = this.accordionFilterProperties.get(string);
            List listToApply = selectedItems;
            if (filterProperty.equals("transactionID")) {
                ArrayList<Long> selectedNumbers = new ArrayList<Long>(selectedItems.size());
                for (String selectedItem : selectedItems) {
                    selectedNumbers.add(Long.parseLong(selectedItem));
                }
                listToApply = selectedNumbers;
            }
            if (selectedItemCount == 1) {
                propertyValueRule.addPropertyValueMap(filterProperty, listToApply.get(0));
                continue;
            }
            propertyValueRule.addPropertyValueMap(filterProperty, listToApply, 10);
        }
        this.btnClearFilters.setEnabled(propertyValueRule.getRuleCount() > 0);
        for (LogFilterEventListener logFilterEventListener : this.logFilterEventListeners) {
            logFilterEventListener.logFilterEvent(propertyValueRule);
        }
        this.filterListItemChanging = false;
    }
}

