/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.panel.logs;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.Application;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.dialog.DialogPanel;
import com.jmorgan.swing.dialog.GenericDialog;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreApplicationProperties;
import com.kumbasoft.core.ui.AbstractTablePanel;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.panel.logs.CustomQuickFilter;
import com.kumbasoft.core.util.FileUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JDialog;

public class CustomQuickFiltersPanel
extends AbstractTablePanel<CustomQuickFilter>
implements DialogPanel {
    private GenericDialog parentDialog;
    private ArrayList<CustomQuickFilter> quickFilters;
    private JMButton btnAdd;
    private JMButton btnDelete;
    private JMButton btnSave;
    private JMButton btnClose;

    public CustomQuickFiltersPanel(Class<CustomQuickFilter> elementType, Object ... arguments) {
        super(elementType, arguments);
        if (arguments[0] != null) {
            this.quickFilters = (ArrayList)arguments[0];
            if (this.quickFilters.size() > 0) {
                this.tableModel.addAll(this.quickFilters);
                this.displayTable.optimizeColumnWidths();
            } else {
                CustomQuickFilter sample = new CustomQuickFilter();
                sample.setTitle("My Custom Title");
                sample.setRegex("Super Filter Regular Expression");
                this.displayTable.optimizeColumnWidths(sample);
            }
        }
        this.add((Component)this.createTopControlsPanel(), "North");
    }

    private JMPanel createTopControlsPanel() {
        boolean hasRows = this.quickFilters.size() > 0;
        this.btnAdd = ComponentFactory.createButton(KumbaCoreUIConstants.ADD_ICON, null, "Add a new filter", true, this, "fileNew", new Object[0]);
        this.btnDelete = ComponentFactory.createButton(KumbaCoreUIConstants.DELETE_ICON, null, "Delete the selected filters", hasRows, this, "editDelete", new Object[0]);
        this.btnSave = ComponentFactory.createButton(KumbaCoreUIConstants.SAVE_ICON, null, "Save all changes", hasRows, this, "fileSave", new Object[0]);
        this.btnClose = ComponentFactory.createButton(KumbaCoreUIConstants.CANCEL_ICON, null, "Close the Dialog", true, this, "closeWindow", new Object[0]);
        JMPanel leftPanel = new JMPanel(new FlowLayout(0, 5, 1));
        leftPanel.addAll(this.btnAdd, this.btnDelete);
        JMPanel rightPanel = new JMPanel(new FlowLayout(2, 5, 1));
        rightPanel.addAll(this.btnSave, this.btnClose);
        JMPanel panel = new JMPanel(new BorderLayout(5, 1));
        panel.add((Component)leftPanel, "West");
        panel.add((Component)new JMLabel("Custom Quick Filters"), "Center");
        panel.add((Component)rightPanel, "East");
        return panel;
    }

    @Override
    public BeanTableModel<CustomQuickFilter> getTableModel() {
        BeanTableModel<CustomQuickFilter> model = super.getTableModel();
        model.setEditable();
        return model;
    }

    @Override
    protected BeanColumnModel<CustomQuickFilter> getColumnModel() {
        BeanColumnModel<CustomQuickFilter> columnModel = super.getColumnModel();
        columnModel.setColumnOrder("title", "regex");
        columnModel.setColumnTitle("title", "Filter Title");
        columnModel.setColumnTitle("regex", "Expression");
        return columnModel;
    }

    @Reflected
    private void fileNew() {
        if (this.displayTable.getRowCount() > 0) {
            this.displayTable.commitEdits();
        }
        CustomQuickFilter newRow = new CustomQuickFilter();
        this.quickFilters.add(newRow);
        this.addRow(newRow);
        this.btnDelete.setEnabled(true);
        this.btnSave.setEnabled(true);
        this.displayTable.setSelectedRow(this.displayTable.getRowCount() - 1);
    }

    @Reflected
    private void editDelete() {
        if (this.tableModel.getRowCount() == 0) {
            return;
        }
        ArrayList filters = this.getSelectedValues(true);
        boolean all = filters.size() == this.tableModel.getRowCount();
        String titleSection = all ? "all" : "all selected";
        String title = String.format("Delete %s Quick Filters", titleSection);
        String message = String.format("Do you want to delete %s custom quick filters?", titleSection);
        if (all) {
            this.displayTable.selectAll();
        }
        if (this.displayTable.deleteSelected(title, message)) {
            this.quickFilters.removeAll(filters);
            boolean hasRows = this.tableModel.getRowCount() > 0;
            this.displayTable.repaint();
            this.btnDelete.setEnabled(hasRows);
        }
    }

    @Reflected
    private boolean fileSave() {
        logger.finer("(): Starting");
        this.displayTable.commitEdits();
        KumbaCoreApplicationProperties props = (KumbaCoreApplicationProperties)Application.getApplication().getApplicationProperties();
        String customFileFiltersFileName = props.getLogFiltersFile();
        if (this.tableModel.getRowCount() > 0) {
            ArrayList data = this.tableModel.getModelData();
            for (CustomQuickFilter filter : this.quickFilters) {
                String title = filter.getTitle();
                String regex = filter.getRegex();
                try {
                    logger.finer(() -> LMG.log("(): Checking regex '%s' for '%s'.", () -> regex, () -> title));
                    Pattern.compile(regex);
                }
                catch (PatternSyntaxException e) {
                    String message = String.format("The expression '%s' for '%s' is invalid.", regex, title);
                    new JMMessageBox((JDialog)this.parentDialog, "Invalid Expression", message);
                    logger.info(() -> LMG.log("(): %s.  Returning false.", () -> message));
                    return false;
                }
            }
            logger.finer(() -> LMG.log("(): Writing filters to %s.", () -> customFileFiltersFileName));
            FileUtility.writeObject(customFileFiltersFileName, data, true);
        } else {
            File file = new File(customFileFiltersFileName);
            if (file.exists()) {
                logger.finer(() -> LMG.log("(): Deleting %s due to no more custom filters.", () -> customFileFiltersFileName));
                file.delete();
            }
        }
        logger.finer("(): Done.");
        return true;
    }

    @Reflected
    private void closeWindow() {
        this.parentDialog.closeDialog();
    }

    @Override
    public void setParentDialog(GenericDialog dialog) {
        this.parentDialog = dialog;
    }

    @Override
    public boolean parentDialogClosing() {
        return this.fileSave();
    }
}

