/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.panel.logs;

import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.AuditLogEntry;
import com.kumbasoft.core.beans.config.ConfigAuditLog;
import com.kumbasoft.core.beans.config.ConfigLogTarget;
import com.kumbasoft.core.tools.LogTargetProcessor;
import com.kumbasoft.core.ui.beans.DataPowerAuditLogSearchOptions;
import com.kumbasoft.core.ui.dialog.logSearchOptions.DataPowerAuditLogSearchOptionsPanel;
import com.kumbasoft.core.ui.panel.logs.AbstractLogDisplayPanel;
import com.kumbasoft.core.ui.panel.logs.AuditLogFiltersComponent;
import com.kumbasoft.core.ui.renderers.AuditLogBeanTableCellRenderer;
import java.util.ArrayList;

public class DisplayAuditLogPanel
extends AbstractLogDisplayPanel<ConfigAuditLog, AuditLogEntry, AuditLogFiltersComponent, DataPowerAuditLogSearchOptions, DataPowerAuditLogSearchOptionsPanel> {
    public DisplayAuditLogPanel() {
        super(AuditLogEntry.class);
    }

    @Override
    protected DataPowerAuditLogSearchOptions createSearchOptions() {
        return new DataPowerAuditLogSearchOptions();
    }

    @Override
    protected DataPowerAuditLogSearchOptionsPanel createSearchOptionsPanel(DataPowerAuditLogSearchOptions searchOptions) {
        return new DataPowerAuditLogSearchOptionsPanel(searchOptions);
    }

    @Override
    protected AuditLogFiltersComponent createQuickFiltersPanel() {
        return new AuditLogFiltersComponent();
    }

    @Override
    protected String getSearchOptionsPanelTitle() {
        return "Audit Log Search Options";
    }

    @Override
    protected int getEstimatedFileCount() {
        int estimatedFileCount = 0;
        for (ConfigAuditLog logTarget : this.selectedLogTargets) {
            int numberOfRotations = (int)logTarget.getRotate();
            estimatedFileCount += numberOfRotations;
        }
        return estimatedFileCount;
    }

    @Override
    protected LogTargetProcessor getLogTargetProcessor() {
        ArrayList<ConfigLogTarget> logTargets = new ArrayList<ConfigLogTarget>(this.selectedLogTargets.size());
        for (ConfigAuditLog auditLog : this.selectedLogTargets) {
            ConfigLogTarget logTarget = this.getProxyLogTarget(auditLog.getAppliance(), auditLog.getSourceDomain(), auditLog);
            logTargets.add(logTarget);
        }
        return new LogTargetProcessor(logTargets);
    }

    @Override
    protected BeanColumnModel<AuditLogEntry> getColumnModel() {
        logger.finer("(): Starting");
        BeanColumnModel<AuditLogEntry> columnModel = super.getColumnModel();
        AuditLogBeanTableCellRenderer cellRenderer = new AuditLogBeanTableCellRenderer(this.tableModel);
        this.columnModel.setRenderer(".*", cellRenderer);
        columnModel.hideColumns("domain", "logTargetName", "lineNumber");
        columnModel.setColumnOrder("appliance", "time", "logCategory", "authenticationType", "user", "userIP", "configStatus", "errorCode", "message");
        logger.finer("(): Done.  Returning model.");
        return columnModel;
    }

    @Override
    protected String[] getPreferredColumnOrder() {
        logger.finer("(): Returning column order");
        return new String[]{"appliance", "time", "logCategory", "authenticationType", "user", "userIP", "configStatus", "errorCode", "message"};
    }

    @Override
    protected boolean isMatching(AuditLogEntry logEntry) {
        boolean matches;
        String authenticationType;
        String errorCode;
        String logCategory;
        logger.finer("(AuditLogEntry): Starting");
        logger.finest("(AuditLogEntry): logEntry:\n\t" + logEntry.toString());
        String filterExpression = this.getMatchPattern();
        String message = logEntry.getMessage();
        if (message == null) {
            message = "";
        }
        if ((logCategory = logEntry.getLogCategory()) == null) {
            logCategory = "";
        }
        if ((errorCode = logEntry.getErrorCode()) == null) {
            errorCode = "";
        }
        if ((authenticationType = logEntry.getAuthenticationType()) == null) {
            authenticationType = "";
        }
        String user = logEntry.getUser();
        String userIP = logEntry.getUserIP();
        boolean bl = matches = message.matches(filterExpression) || errorCode.matches(filterExpression) || authenticationType.matches(filterExpression) || user.matches(filterExpression) || userIP.matches(filterExpression);
        if (matches) {
            logger.finer("(AuditLogEntry):  Log entry matches.  Adding its data to quick filters.");
            ((AuditLogFiltersComponent)this.logFiltersComponent).loadQuickFilters(logEntry);
            logger.finer("(AuditLogEntry):  Log entry matches.  Done adding its data to quick filters.");
        }
        logger.finer(() -> LMG.log("(AuditLogEntry): Done.  Returning %b", () -> matches));
        return matches;
    }
}

