/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.panels.users;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.rules.PropertyValueRule;
import com.jmorgan.swing.menu.JMPopupMenu;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.beans.config.ConfigUserGroup;
import com.kumbasoft.core.ui.AbstractCRUDPanel;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.panels.users.ManageUserGroupsPopupMenu;
import com.kumbasoft.core.util.RegexUtility;
import java.util.ArrayList;

public class UserGroupManagementPanel
extends AbstractCRUDPanel<ConfigUserGroup> {
    public UserGroupManagementPanel() {
        super(ConfigUserGroup.class);
    }

    @Override
    protected String getTFPatternLabel() {
        return "User Group:";
    }

    @Override
    protected int getMatchPatternLabelWidth() {
        return 90;
    }

    @Override
    protected JMPopupMenu getPopupMenu() {
        return new ManageUserGroupsPopupMenu(this, this.displayTable, this.displayTableScrollPane);
    }

    @Override
    protected boolean isPopupReady() {
        return ((ManageUserGroupsPopupMenu)this.popupMenu).isPopupReady();
    }

    @Override
    protected String getSearchSaveConfirmMessage() {
        return "The current list of groups is about to change,\nbut you made changes to the current list of groups.\n\nDo you want to save those changes first?";
    }

    @Override
    @Reflected
    protected void listObjects() {
        UniqueArrayList<Appliance> appliances = ApplianceDomainChangeMonitor.getInstance().getCurrentApplianceSelection();
        this.listGroupsByAppliance(appliances);
    }

    private void listGroupsByAppliance(ArrayList<Appliance> appliances) {
        AbstractPanel.logger.finer("(selectedAppliances): Starting");
        String matchPattern = RegexUtility.normalizeRegex(this.getMatchPattern(), this.useCaseSensitiveSearch);
        AbstractPanel.logger.fine(() -> LMG.log("(selectedAppliances): Searching for user groups with names matching '%s'", () -> matchPattern));
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<ConfigUserGroup> userGroups = configurationManager.getObjects(appliances, ConfigUserGroup.class, matchPattern);
        AbstractPanel.logger.fine(() -> LMG.log("(selectedAppliances): Found %d user groups with names matching '%s'", () -> userGroups.size(), () -> matchPattern));
        for (ConfigUserGroup userGroup : userGroups) {
            String groupName = userGroup.getName();
            if (!groupName.matches(matchPattern)) continue;
            this.tableModel.addRow(userGroup);
        }
        this.tableModel.setValueExpression("appliance", "name");
        this.displayTable.optimizeColumnWidths();
        this.resetUI();
        this.dirty = false;
        AbstractPanel.logger.finer("(selectedAppliances): Starting");
    }

    @Override
    protected ConfigUserGroup getNewInstance() {
        return new ConfigUserGroup();
    }

    @Override
    protected String getDeleteConfirmationMessage(ArrayList<ConfigUserGroup> selectedConfigs) {
        return "Delete all selected user groups?";
    }

    @Override
    protected void synchronizeChanges(ConfigUserGroup editedGroup, int row, ConfigUserGroup group, String columnName) {
        String editName = editedGroup.getName();
        String editedAdminState = editedGroup.getAdminState();
        String editedComments = editedGroup.getUserSummary();
        String editStatus = editedGroup.getStatus().getConfigState();
        String groupName = group.getName();
        if (groupName == null) {
            groupName = "";
        }
        if (editStatus.equals("new") && columnName.equals("name") && group.getStatus().getConfigState().equals("new") || groupName.equals(editName)) {
            group.setAdminState(editedAdminState);
            group.setName(editName);
            group.setUserSummary(editedComments);
            group.getStatus().setConfigState(editedGroup.getStatus().getConfigState());
        }
    }

    @Override
    public BeanTableModel<ConfigUserGroup> getTableModel() {
        AbstractPanel.logger.finer("(): Starting");
        BeanTableModel<ConfigUserGroup> tableModel = super.getTableModel();
        tableModel.setEditableColumns("adminState", "name", "userSummary");
        PropertyValueRule nameRule = new PropertyValueRule();
        nameRule.addPropertyValueMap("status.configState", (Object)"new", 1);
        tableModel.addCellEditabilityRule("name", nameRule);
        tableModel.addTableModelListener(this);
        AbstractPanel.logger.finer("(): Done");
        return tableModel;
    }

    @Override
    protected BeanColumnModel<ConfigUserGroup> getColumnModel() {
        BeanColumnModel<ConfigUserGroup> columnModel = super.getColumnModel();
        columnModel.setColumnOrder("appliance", "name", "adminState", "userSummary");
        columnModel.hideColumns("sourceDomain", "commandGroup", "accessPolicies", "isExternal", "isIntrinsic", "isLocal", "isReadOnly", "configObjectType", "quiesceState", "status", "fQON");
        return columnModel;
    }

    @Override
    public void commandSucceeded(ManagementCommandStatus commandStatus) {
        System.out.println("ManagementCommandSubscriber.commandSucceeded(): Need to modify or delete");
    }
}

