/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.util;

import com.jmorgan.io.FileInputStreamHelper;
import com.jmorgan.io.FileOutputStreamHelper;
import com.jmorgan.util.StringUtility;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CleanupXMLExport {
    private String inputFileName;
    private String outputFilename;

    public CleanupXMLExport(String inputFileName, String outputFileName) {
        this.setInputFileName(inputFileName);
        this.setOutputFilename(outputFileName);
        this.cleanupXMLFile();
    }

    public String getInputFileName() {
        return this.inputFileName;
    }

    public void setInputFileName(String fileName) {
        this.inputFileName = fileName;
    }

    public String getOutputFilename() {
        return this.outputFilename;
    }

    public void setOutputFilename(String outputFilename) {
        this.outputFilename = outputFilename;
    }

    private void cleanupXMLFile() {
        FileInputStreamHelper fin = new FileInputStreamHelper(this.inputFileName);
        InputStream in = fin.open();
        FileOutputStreamHelper fout = new FileOutputStreamHelper(this.outputFilename);
        OutputStream out = fout.open();
        try {
            try {
                while (true) {
                    String segment;
                    if ((segment = this.readUntil(in, 62)).contains("webgui:///")) {
                        segment = this.readUntil(in, 62);
                        continue;
                    }
                    if (StringUtility.isEmpty(segment)) {
                        break;
                    }
                    out.write(segment.getBytes());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                fin.close();
                fout.close();
            }
        }
        finally {
            fin.close();
            fout.close();
        }
    }

    private String readUntil(InputStream in, int lastChar) throws IOException {
        StringBuilder sb = new StringBuilder();
        int ch = in.read();
        while (ch != -1) {
            sb.append((char)ch);
            if (ch == lastChar) break;
            ch = in.read();
        }
        return sb.toString();
    }
}

