/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.util;

import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jmorgan.io.AnyDestinationOutputStream;
import com.jmorgan.io.AnySourceInputStream;
import com.jmorgan.lang.Application;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.util.DataPowerSSHOutputListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class DataPowerSSHClient {
    private static final Logger logger = Application.getApplication().getApplicationLogger();
    private Appliance appliance;
    private JSch jsch;
    private Session session;
    private ChannelShell channel;
    private boolean connected;
    private AnySourceInputStream outputToDataPower;
    private AnyDestinationOutputStream inputFromDataPower;
    private ArrayList<DataPowerSSHOutputListener> sshOutputListeners;

    public DataPowerSSHClient(Appliance appliance) {
        this.appliance = appliance;
    }

    public void addSSHOutputListener(DataPowerSSHOutputListener listener) {
        if (listener == null) {
            return;
        }
        if (this.sshOutputListeners == null) {
            this.sshOutputListeners = new ArrayList();
        }
        this.sshOutputListeners.add(listener);
    }

    public void removeSSHOutputListener(DataPowerSSHOutputListener listener) {
        if (this.sshOutputListeners == null) {
            return;
        }
        if (this.sshOutputListeners.contains(listener)) {
            this.sshOutputListeners.remove(listener);
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean connect() {
        logger.finer("(): Starting");
        this.connected = false;
        String applianceName = this.appliance.getName();
        int port = this.appliance.getSshPort();
        logger.finer(() -> LMG.log("(): Connecting to SSH on %s on port %d", () -> applianceName, () -> port));
        try {
            this.jsch = new JSch();
            String host = this.appliance.getSshManagementHost();
            logger.finer(() -> LMG.log("(): Getting session from host %s on port %d", () -> host, () -> port));
            String sshUserName = new String(this.appliance.getSshManagementUserName());
            this.session = this.jsch.getSession(sshUserName, host, port);
            logger.finer(() -> LMG.log("(): Got session for user '%s' from host %s on port %d", () -> sshUserName, () -> host, () -> port));
            this.session.setConfig("StrictHostKeyChecking", "no");
            logger.finer(() -> LMG.log("(): Connecting session for user '%s' from host %s on port %d with timeout of %d.", () -> sshUserName, () -> host, () -> port, () -> KumbaCoreConstants.CLI_CONNECTION_TIMEOUT));
            this.session.setPassword(new String(this.appliance.getSshManagementPassword()));
            this.session.connect(KumbaCoreConstants.CLI_CONNECTION_TIMEOUT);
            logger.finer(() -> LMG.log("(): Getting channel for user '%s' from session on host %s and port.", () -> sshUserName, () -> host, () -> port));
            this.channel = (ChannelShell)this.session.openChannel("shell");
            logger.finer(() -> LMG.log("(): Got channel for user '%s' from session on host %s and port.", () -> sshUserName, () -> host, () -> port));
            this.outputToDataPower = new AnySourceInputStream();
            this.inputFromDataPower = new AnyDestinationOutputStream(null);
            this.channel.setInputStream(this.outputToDataPower);
            this.channel.setOutputStream(this.inputFromDataPower);
            logger.finer(() -> LMG.log("(): Connecting channel for user '%s' %d with session on host %s and port.", () -> sshUserName, () -> this.channel.getId(), () -> host, () -> port));
            this.channel.connect(3000);
            logger.finer("(): Waiting for login or command prompt.");
            String prompt = this.waitFor("(login( as)?:|idg#)");
            if (prompt.contains("login")) {
                String userName = new String(this.appliance.getSshManagementUserName());
                this.sendToDataPower(userName + "\n");
                prompt = this.waitFor("(login|[Pp]assword):");
                if (prompt.contains("login:")) {
                    this.sendToDataPower(userName + "\n");
                    this.waitFor("[Pp]assword:");
                }
                String password = new String(this.appliance.getSshManagementPassword());
                this.sendToDataPower(password + "\n");
                String promptExpression = this.getPromptString();
                String promptWait = prompt = String.format("(%s|Domain .. for all.:)", promptExpression);
                logger.finer(() -> LMG.log("(): Prompt to wait for: %s", () -> promptWait));
                String promptReceived = prompt = this.waitFor(prompt);
                logger.finer(() -> LMG.log("(): Prompt received: %s", () -> promptReceived));
                if (prompt.equals("Domain (? for all):")) {
                    this.sendToDataPower("default\n");
                    this.waitForPrompt();
                }
            }
            this.connected = true;
            return true;
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
            this.jsch = null;
            logger.finer("(): Done.  Returning false.");
            return false;
        }
    }

    public void disconnect() {
        this.connected = false;
        if (this.channel != null) {
            this.channel.disconnect();
        }
        if (this.session != null) {
            this.session.disconnect();
        }
    }

    public void sendToDataPower(String cliCommand) throws IOException {
        String loggerPrefix = String.format("(cliCommand=%s): ", cliCommand);
        logger.finer(() -> LMG.log("%sStarting", () -> loggerPrefix));
        if (this.jsch == null) {
            logger.fine(() -> LMG.log("%sJSCH not connected.  Connecting.", () -> loggerPrefix));
            if (!this.connect()) {
                logger.severe(() -> LMG.log("%sJSCH failed to connect.  Returning.", () -> loggerPrefix));
                return;
            }
        }
        logger.finer(() -> LMG.log("%sSupplying command to DataPower.", () -> loggerPrefix));
        this.outputToDataPower.supply(cliCommand.getBytes());
        logger.finer(() -> LMG.log("%sWaiting for command to be consumed.", () -> loggerPrefix));
        while (this.outputToDataPower.available() > 0) {
            Thread.yield();
            ThreadUtility.sleep(25L);
        }
        logger.finer(() -> LMG.log("%sCommand consumed.", () -> loggerPrefix));
    }

    public String waitForPrompt() throws IOException {
        return this.waitFor(this.getPromptString());
    }

    public String getPromptString() {
        return ".*?(xg45|xi52|idg|xb62).*?#";
    }

    public String waitFor(String consoleOutputExpression) throws IOException {
        StringBuilder sb;
        String loggerPrefix;
        block8: {
            String consoleOutput;
            loggerPrefix = String.format("(consoleOutputExpression=%s): For appliance: %s:  ", consoleOutputExpression, this.appliance.getName());
            logger.finer(() -> LMG.log("%s:  Starting", () -> loggerPrefix));
            if (this.inputFromDataPower == null) {
                logger.warning(() -> LMG.log("%sStream doesn't exist, likely due to conneciton timeout.  No console output captured.  Returning.", () -> loggerPrefix));
                return null;
            }
            byte ch = 0;
            sb = new StringBuilder();
            while (true) {
                logger.finer(() -> LMG.log("%sReading input character from appliance.", () -> loggerPrefix));
                ch = this.inputFromDataPower.read();
                if (ch == 0) {
                    logger.fine(() -> LMG.log("%sStream appears to be closed.  Last console output = %s", () -> loggerPrefix, () -> sb.toString()));
                    return null;
                }
                if (ch == -1) {
                    logger.fine(() -> LMG.log("%sEnd of input from DataPower detected.  Last console output = %s", () -> loggerPrefix, () -> sb.toString()));
                    return null;
                }
                if (this.sshOutputListeners != null) {
                    for (DataPowerSSHOutputListener listener : this.sshOutputListeners) {
                        listener.receiveChar((char)ch);
                    }
                }
                if (ch == 10 || ch == 13) {
                    if (sb.length() <= 0) continue;
                    logger.fine(() -> LMG.log("%sBuffer resetting after [%s]", () -> loggerPrefix, () -> sb.toString()));
                    sb.setLength(0);
                    continue;
                }
                sb.append((char)ch);
                consoleOutput = sb.toString();
                logger.finest(() -> LMG.log("%sConsole output is:\n%s\n", () -> loggerPrefix, () -> consoleOutput));
                if (consoleOutput.matches("Goodbye.")) {
                    logger.finer(() -> LMG.log("%sReceived 'Goodbye.'  Closing the connection.", () -> loggerPrefix));
                    this.session.disconnect();
                    this.channel.disconnect();
                    this.session = null;
                    this.channel = null;
                    this.jsch = null;
                    break block8;
                }
                if (consoleOutput.matches(consoleOutputExpression)) break;
            }
            logger.finer(() -> LMG.log("%sConsole Output Matched=%s", () -> loggerPrefix, () -> consoleOutput));
        }
        logger.finer(() -> LMG.log("%s:  Done", () -> loggerPrefix));
        return sb.toString();
    }
}

