/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.util;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.util.Index;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public final class DataStructureUtility {
    private DataStructureUtility() {
    }

    public static final <ObjectType> Index<Appliance, ObjectType> mapByAppliance(Collection<ObjectType> objects) {
        Index<Appliance, ObjectType> applianceMap = new Index<Appliance, ObjectType>();
        for (ObjectType object : objects) {
            Appliance appliance = (Appliance)BeanService.getPropertyValue(object, "appliance");
            applianceMap.put(appliance, object);
        }
        return applianceMap;
    }

    public static final <ObjectType> HashMap<Appliance, Index<Domain, ObjectType>> mapByApplianceDomain(Collection<ObjectType> objectList) {
        HashMap<Appliance, Index<Domain, ObjectType>> map = new HashMap<Appliance, Index<Domain, ObjectType>>();
        ArrayList<ObjectType> looper = new ArrayList<ObjectType>(objectList);
        for (ObjectType object : looper) {
            if (object == null) continue;
            Appliance appliance = (Appliance)BeanService.getPropertyValue(object, "appliance");
            Index<Domain, Object> objectsInAppliance = map.get(appliance);
            if (objectsInAppliance == null) {
                objectsInAppliance = new Index();
                map.put(appliance, objectsInAppliance);
            }
            String domainPropertyName = BeanService.hasProperty(object, "sourceDomain") ? "sourceDomain" : "domain";
            Domain domain = (Domain)BeanService.getPropertyValue(object, domainPropertyName);
            objectsInAppliance.put(domain, object);
        }
        return map;
    }

    public static final HashMap<String, Index<String, StatusObjectStatus>> mapByTypeAndName(Collection<StatusObjectStatus> objectList) {
        HashMap<String, Index<String, StatusObjectStatus>> map = new HashMap<String, Index<String, StatusObjectStatus>>();
        for (StatusObjectStatus object : objectList) {
            String type = object.getDataPowerClass();
            Index<String, StatusObjectStatus> objectsByType = map.get(type);
            if (objectsByType == null) {
                objectsByType = new Index();
                map.put(type, objectsByType);
            }
            String name = object.getName();
            objectsByType.put(name, object);
        }
        return map;
    }
}

