/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.util;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.util.Date;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.Index;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.DataPowerStatusCache;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.status.StatusHSMKeyStatus;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.DataPowerStatusMonitor;
import com.kumbasoft.core.tools.ThreadManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

public class HSMFSUtil
extends AbstractTool {
    private static final String[] HSM_DIRECTORIES = new String[]{"hsm:/", "hsm://hsm3"};

    private HSMFSUtil() {
    }

    public static Collection<StatusHSMKeyStatus> getHSMKeys(Index<Appliance, Domain> domains) {
        logger.finer("(domains): Starting.");
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        DataPowerStatusCache hsmKeyStatus = new DataPowerStatusCache();
        Collection<Appliance> appliances = domains.getKeys();
        for (Appliance appliance : appliances) {
            Collection<Domain> selectedDomains = domains.get(appliance);
            for (Domain domain : selectedDomains) {
                logger.finer(() -> LMG.log("(domains): Getting HSM Key Status for the '%s' domain of appliance '%s'.", () -> domain.getName(), () -> appliance.getName()));
                DataPowerStatusMonitor statusMonitor = new DataPowerStatusMonitor(appliance, domain, "HSMKeyStatus", 0L);
                statusMonitor.addStatusListener(hsmKeyStatus);
                mtil.addThread(statusMonitor.getProcessThread());
            }
        }
        boolean completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        if (completedOnTime) {
            logger.finer("(domains): All threads for getting HSM keys complete.");
        } else {
            logger.warning("(domains): Not all threads for getting HSM keys completed on time.  Moving on, but results may not be complete.");
        }
        Collection<StatusHSMKeyStatus> keyCache = hsmKeyStatus.getStatusCache();
        boolean inTestingMode = (Boolean)BeanService.getPropertyValue(applicationParameters, "testingMode");
        if (inTestingMode && CollectionUtility.isEmpty(keyCache)) {
            logger.finer("(domains): Testing mode is on.  Faking it.");
            keyCache = HSMFSUtil.getFakeHSMKeyStatus(domains);
        }
        int keyCount = keyCache.size();
        logger.finer(() -> LMG.log("(domains): Returning %d keys.", () -> keyCount));
        return keyCache;
    }

    public static Collection<DataPowerFileInfo> getHSMDirectories(Index<Appliance, Domain> domains) {
        logger.finer("(domains): Starting");
        ArrayList<DataPowerFileInfo> hsmDirectories = new ArrayList<DataPowerFileInfo>();
        Date date = new Date();
        date.setFormat(Date.SQL_FORMAT);
        String[] stringArray = HSM_DIRECTORIES;
        int n = HSM_DIRECTORIES.length;
        int n2 = 0;
        while (n2 < n) {
            String hsmDirectory = stringArray[n2];
            for (Appliance appliance : domains.getKeys()) {
                for (Domain domain : domains.get(appliance)) {
                    DataPowerFileInfo hsmKeyFile = new DataPowerFileInfo(appliance, domain, null, 0L, hsmDirectory, "");
                    hsmKeyFile.setDeleteable(false);
                    hsmKeyFile.setAdminState(DPEnumerations.ADMIN_STATE[0]);
                    hsmKeyFile.setIsReadOnly(true);
                    hsmKeyFile.setIsExternal(false);
                    hsmKeyFile.setConfigObjectType("file");
                    hsmDirectories.add(hsmKeyFile);
                }
            }
            ++n2;
        }
        logger.finer("(domains): Done");
        return hsmDirectories;
    }

    public static Collection<DataPowerFileInfo> getHSMFiles(Index<Appliance, Domain> domains) {
        logger.finer("(domains): Starting.");
        Collection<StatusHSMKeyStatus> hsmKeys = HSMFSUtil.getHSMKeys(domains);
        int hsmKeyCount = hsmKeys.size();
        ArrayList<DataPowerFileInfo> hsmKeyFiles = new ArrayList<DataPowerFileInfo>(hsmKeys.size());
        for (StatusHSMKeyStatus hsmKey : hsmKeys) {
            String keyLabel = hsmKey.getKeyLabel();
            String keyType = hsmKey.getKeyType();
            boolean exportable = hsmKey.getExportable().equals("on");
            Date date = new Date();
            date.setFormat(Date.SQL_FORMAT);
            DataPowerFileInfo hsmKeyFile = new DataPowerFileInfo(hsmKey.getAppliance(), hsmKey.getSourceDomain(), date.toString(), 100L, keyLabel);
            hsmKeyFile.setDeleteable(true);
            hsmKeyFile.setAdminState(DPEnumerations.ADMIN_STATE[0]);
            hsmKeyFile.setIsReadOnly(keyType.equals("private"));
            hsmKeyFile.setIsExternal(false);
            hsmKeyFile.setConfigObjectType("file");
            StatusObjectStatus objectStatus = new StatusObjectStatus();
            objectStatus.setAdminState(DPEnumerations.ADMIN_STATE[0]);
            objectStatus.setAppliance(hsmKey.getAppliance());
            objectStatus.setSourceDomain(hsmKey.getSourceDomain());
            objectStatus.setDataPowerClass("DataPowerFileInfo");
            objectStatus.setOpState(DPEnumerations.OP_STATE[0]);
            objectStatus.setName(hsmKeyFile.getName());
            objectStatus.setEventCode("");
            objectStatus.setErrorCode("");
            objectStatus.setConfigState(DPEnumerations.CONFIG_STATE[1]);
            hsmKeyFile.setStatus(objectStatus);
            hsmKeyFiles.add(hsmKeyFile);
        }
        logger.finer(() -> LMG.log("(domains): Returning %d keys.", () -> hsmKeyCount));
        return hsmKeyFiles;
    }

    private static Collection<StatusHSMKeyStatus> getFakeHSMKeyStatus(Index<Appliance, Domain> domains) {
        logger.finer("(domains): Starting");
        Random r = new Random();
        int num = r.nextInt(1, 25);
        int keyPairs = num % 2 == 1 ? ++num : num;
        logger.finer(() -> LMG.log("(domains): Will create %d fake hsm key pairs: ", () -> keyPairs));
        ArrayList applianceList = (ArrayList)domains.getKeys();
        int applianceCount = applianceList.size();
        ArrayList<StatusHSMKeyStatus> fakeData = new ArrayList<StatusHSMKeyStatus>(num);
        int i = 0;
        while (i < keyPairs) {
            int randomAppliance = r.nextInt(0, applianceCount);
            Appliance appliance = (Appliance)applianceList.get(randomAppliance);
            ArrayList domainList = (ArrayList)domains.get(appliance);
            int domainCount = domainList.size();
            DateTime statusTime = new DateTime();
            int d = 0;
            while (d < domainCount) {
                Domain domain = (Domain)domainList.get(r.nextInt(0, domainCount));
                String keyHandle = String.format("%016x", i);
                String keyLabel = String.format("hsm://hsm3/fake.%d.com", i);
                logger.finer(() -> LMG.log("(domains): Created fake key '%s' with handle '%s' for the '%s' domain of appliance '%s': ", () -> keyLabel, () -> keyHandle, () -> domain.getName(), () -> appliance.getName()));
                StatusHSMKeyStatus cert = HSMFSUtil.createFakeHSMStatus(appliance, domain, keyHandle, keyLabel, "on", "public", statusTime);
                fakeData.add(cert);
                StatusHSMKeyStatus key = HSMFSUtil.createFakeHSMStatus(appliance, domain, keyHandle, keyLabel, "off", "private", statusTime);
                fakeData.add(key);
                ++d;
            }
            ++i;
        }
        logger.finer(() -> LMG.log("(domains): Done.  Returning %d fake HSM status instances", () -> fakeData.size()));
        return fakeData;
    }

    private static StatusHSMKeyStatus createFakeHSMStatus(Appliance appliance, Domain domain, String keyHandle, String keyLabel, String exportable, String type, DateTime statusTime) {
        StatusHSMKeyStatus key = new StatusHSMKeyStatus();
        key.setAppliance(appliance);
        key.setSourceDomain(domain);
        key.setBitLength(2048L);
        key.setExportable(exportable);
        key.setKeyHandle(keyHandle);
        key.setKeyType(type);
        key.setKeyLabel(keyLabel);
        key.setStatusTime(statusTime);
        return key;
    }
}

