/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.util.logging;

import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.util.ThreadUtility;
import com.kumbasoft.core.util.logging.SyslogRecord;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;

abstract class AbstractSocketSender {
    protected static final int FAILURE_TIMEOUT = 5000;
    protected final String hostName;
    protected final int port;
    private final BlockingQueue<SyslogRecord> blockingQueue;
    private boolean running;

    public AbstractSocketSender(String hostName, int port, BlockingQueue<SyslogRecord> blockingQueue) {
        this.hostName = hostName;
        this.port = port;
        this.blockingQueue = blockingQueue;
        this.initialize();
        this.running = true;
        new AsynchMethodInvoker((Object)this, "listenAndSend");
    }

    protected abstract boolean initialize();

    protected void listenAndSend() {
        while (this.running) {
            try {
                SyslogRecord record = this.blockingQueue.take();
                this.sendMessage(record);
            }
            catch (IOException e) {
                ThreadUtility.sleep(5000L);
                break;
            }
            catch (Throwable t) {
                ThreadUtility.sleep(5000L);
                break;
            }
        }
        this.cleanup();
    }

    protected abstract void sendMessage(SyslogRecord var1) throws IOException, Throwable;

    public void stop() {
        this.running = false;
    }

    protected abstract void cleanup();
}

