/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.util.logging;

import com.jmorgan.util.DateTime;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.util.logging.AuditLogRecord;
import java.text.SimpleDateFormat;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class AuditLogFormatter
extends Formatter {
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss.SSS");

    @Override
    public String format(LogRecord record) {
        long threadID = record.getLongThreadID();
        long sequenceNumber = record.getSequenceNumber();
        Level level = record.getLevel();
        long logTime = record.getMillis();
        DateTime dt = new DateTime(logTime);
        dt.setFormatter(DATE_FORMATTER);
        String sourceClassName = record.getSourceClassName();
        sourceClassName = sourceClassName.substring(sourceClassName.indexOf(46) + 1);
        String sourceMethodName = record.getSourceMethodName();
        String message = record.getMessage();
        Object[] parameters = record.getParameters();
        if (parameters != null) {
            int i = 0;
            while (i < parameters.length) {
                System.out.printf("StandardLogFormatter.format(): parameter %d: %s\n", i, parameters[i]);
                ++i;
            }
        }
        String logString = "-- ERROR LOGGING --";
        if (record instanceof AuditLogRecord) {
            AuditLogRecord auditLogRecord = (AuditLogRecord)record;
            String licensedUser = auditLogRecord.getLicensedUser();
            String applicationUser = auditLogRecord.getApplicationUser();
            Appliance appliance = auditLogRecord.getAppliance();
            Domain domain = auditLogRecord.getDomain();
            String applianceUser = auditLogRecord.getApplianceXMLManagementUser();
            logString = String.format("%s\t(tid: %d)\t(sn: %d)\t(%s)\t(user (L: %s): %s as %s)\t(appliance: %s)\t(domain: %s)\t%s\n", dt.toString(), threadID, sequenceNumber, level.toString(), licensedUser, applicationUser, applianceUser, appliance.getName(), domain.getName(), message);
        } else {
            logString = String.format("%s\t(tid: %d)\t(sn: %d)\t(%s)\t%s.%s\t%s\n", dt.toString(), threadID, sequenceNumber, level.toString(), sourceClassName, sourceMethodName, message);
        }
        return logString;
    }
}

