/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.util.security;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.io.ASCFileReader;
import com.jmorgan.io.ASCFileWriter;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.math.DateMath;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.Date;
import com.jmorgan.util.DateTime;
import com.kumbasoft.core.annotations.Entitlements;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerStatusCache;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.status.StatusDateTimeStatus;
import com.kumbasoft.core.tools.DataPowerStatusMonitor;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.util.security.LicenseInformation;
import com.kumbasoft.core.util.security.LicenseNotificationListener;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Random;

public class LicenseManager {
    public static LicenseNotificationListener licenseNotificationListener;
    public static final String NO_LICENSE_TEXT = "This software is protected under copyright law and is the sole property of KumbaSoft LLC.\n\nPlease contact KumbaSoft LLC sales for a software license.";
    public static final String NO_ENTITLEMENT_TEXT = "The application is not entitled by your license.\n\nThis software is protected under copyright law and is the sole property of KumbaSoft LLC.\n\nPlease contact KumbaSoft LLC sales for a software license.";
    public static final String FEATURE_NOT_ENTITLED_TEXT = "Your free preview of this feature has expired and is no longer\nsupported by your Community Edition license.\n\nPlease contact KumbaSoft LLC sales for an Enterprise license.";
    public static final long[] LICENSE_EXPIRATION_WARNING_DAYS;
    public static final String LICENSE_EXPIRATION_WARNING = "Your license will expire in %d days.\nPlease contact KumbaSoft LLC to update your license.\n\nClick 'OK' to continue to '%s'.";
    static final String LICENSE_EXPIRATION_TODAY_WARNING = "Your license expires today.\n\nPlease contact KumbaSoft LLC to update your license.";
    public static final String LICENSE_EXPIRED_TEXT = "Your license has expired.\n\nPlease update to a valid license at KumbaSoft.com.";
    public static final int NO_LICENSE_EXIT_CODE = -100;
    public static final int LICENSE_READ_ERROR_EXIT_CODE = -200;
    public static final int LICENSE_VERSION_MISMATCH_EXIT_CODE = -201;
    public static final int LICENSE_EXPIRED_EXIT_CODE = -202;
    public static final int LICENSE_CORRUPT_EXIT_CODE = -210;
    public static final int INVALID_ENTITLEMENT_EXIT_CODE = -300;
    public static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    public static String APPLICATION_NAME;
    public static Date LICENSE_START_DATE;
    public static Date LICENSE_END_DATE;
    public static X509Certificate LICENSE;

    static {
        long[] lArray = new long[12];
        lArray[0] = 90L;
        lArray[1] = 60L;
        lArray[2] = 45L;
        lArray[3] = 30L;
        lArray[4] = 15L;
        lArray[5] = 10L;
        lArray[6] = 5L;
        lArray[7] = 4L;
        lArray[8] = 3L;
        lArray[9] = 2L;
        lArray[10] = 1L;
        LICENSE_EXPIRATION_WARNING_DAYS = lArray;
    }

    public static final X509Certificate checkLicense(String applicationName, String fileName, boolean doValidityChecks) {
        APPLICATION_NAME = applicationName;
        File licenseFile = new File(fileName);
        if (!licenseFile.exists()) {
            if (licenseNotificationListener != null) {
                licenseNotificationListener.noLicenseAvailable(NO_LICENSE_TEXT);
            }
            System.exit(-100);
        }
        try {
            ASCFileReader fr = new ASCFileReader(licenseFile);
            String inputInterleave64 = fr.readAll();
            inputInterleave64 = inputInterleave64.substring(0, inputInterleave64.length() - 1);
            byte[] interleaveData = Base64.getDecoder().decode(inputInterleave64);
            ByteArrayInputStream bin = new ByteArrayInputStream(interleaveData);
            DataInputStream din = new DataInputStream(bin);
            double version = din.readDouble();
            DateTime versionTime = new DateTime((long)version);
            int year = versionTime.getDate().getYear();
            int month = versionTime.getDate().getMonth();
            int day = versionTime.getDate().getDay();
            long versionInMS = versionTime.getCalendar().getTimeInMillis();
            DateTime today = new DateTime();
            long todayInMS = today.getCalendar().getTimeInMillis();
            long timeDiff = todayInMS - versionInMS;
            if (timeDiff < 0L || year < 2000 || year > today.getDate().getYear() || month < 0 || month > 13 || day < 0 || day > 31) {
                System.err.printf("LicenseManager.checkLicense(): License Version MisMatch\n", new Object[0]);
                if (licenseNotificationListener != null) {
                    licenseNotificationListener.noLicenseAvailable(NO_LICENSE_TEXT);
                }
                System.err.println(NO_LICENSE_TEXT);
                System.exit(-201);
            }
            int privKeyLength = din.readInt();
            int certLength = din.readInt();
            int combinedLength = privKeyLength + certLength;
            byte[] combinedBytes = new byte[combinedLength];
            din.read(combinedBytes);
            byte[] xorCertBytes = new byte[certLength];
            byte[] privKeyBytes = new byte[privKeyLength];
            byte[] certBytes = new byte[certLength];
            int i = 0;
            int x = 0;
            int p = 0;
            while (i < combinedLength) {
                if (p < privKeyLength) {
                    privKeyBytes[p] = combinedBytes[i++];
                }
                if (x < certLength) {
                    xorCertBytes[x] = combinedBytes[i++];
                }
                ++x;
                ++p;
            }
            i = 0;
            int p2 = 0;
            int c = 0;
            while (i < certLength) {
                if (p2 == privKeyLength) {
                    p2 = 0;
                }
                certBytes[c] = (byte)(privKeyBytes[p2] ^ xorCertBytes[c]);
                ++i;
                ++p2;
                ++c;
            }
            String outputCertificate = LicenseManager.getFormattedCert(certBytes);
            ByteArrayInputStream certBin = new ByteArrayInputStream(outputCertificate.getBytes());
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate certificate = (X509Certificate)cf.generateCertificate(certBin);
            if (doValidityChecks) {
                certificate.checkValidity();
                Date licenseEndDate = new Date(certificate.getNotAfter());
                LicenseInformation licenseInformation = new LicenseInformation(certificate);
                String licenseType = licenseInformation.getEntitlementType();
                LicenseManager.countDownWarning(licenseType, licenseEndDate);
            }
            return certificate;
        }
        catch (IOException e) {
            System.err.printf("LicenseManager.checkLicense(): Error Reading License File: %s\n", licenseFile.getAbsolutePath());
            e.printStackTrace();
            if (licenseNotificationListener != null) {
                licenseNotificationListener.noLicenseAvailable(NO_LICENSE_TEXT);
            }
            System.err.println(NO_LICENSE_TEXT);
            System.exit(-200);
        }
        catch (CertificateExpiredException expired) {
            System.err.printf("LicenseManager.checkLicense(): License has expired\n", new Object[0]);
            if (licenseNotificationListener != null) {
                licenseNotificationListener.licenseExpirationWarning(LICENSE_EXPIRED_TEXT);
            }
            System.err.println(LICENSE_EXPIRED_TEXT);
            System.exit(-202);
        }
        catch (CertificateException e) {
            System.err.printf("LicenseManager.checkLicense(): License File Corruption Error\n", new Object[0]);
            e.printStackTrace();
            if (licenseNotificationListener != null) {
                licenseNotificationListener.noLicenseAvailable(NO_LICENSE_TEXT);
            }
            System.err.println(NO_LICENSE_TEXT);
            System.exit(-210);
        }
        return null;
    }

    public static final void countDownWarning(String licenseType, Date licenseEndDate) {
        Date today = new Date();
        long endDateDifference = DateMath.getDayDifference(today, licenseEndDate);
        if (endDateDifference < 0L) {
            if (licenseNotificationListener != null) {
                licenseNotificationListener.licenseExpirationWarning(LICENSE_EXPIRED_TEXT);
            }
            System.err.println(LICENSE_EXPIRED_TEXT);
            System.exit(-202);
        }
        if (Comparison.isIn(endDateDifference, LICENSE_EXPIRATION_WARNING_DAYS)) {
            String message;
            String string = message = endDateDifference == 0L ? LICENSE_EXPIRATION_TODAY_WARNING : String.format(LICENSE_EXPIRATION_WARNING, endDateDifference, APPLICATION_NAME);
            if (licenseNotificationListener != null) {
                licenseNotificationListener.licenseExpirationWarning(message);
            }
            return;
        }
        if (endDateDifference <= LICENSE_EXPIRATION_WARNING_DAYS[0]) {
            new AsynchMethodInvoker(LicenseManager.class, "countDownWarning", new Object[]{licenseType, licenseEndDate}, 86400);
        }
    }

    public static final String getFormattedCert(byte[] certificateBytes) {
        String certBase64 = Base64.getEncoder().encodeToString(certificateBytes);
        String formattedCert = LicenseManager.formatBase64(certBase64);
        String outputCert = String.format("%s\n%s%s\n", BEGIN_CERTIFICATE, formattedCert, END_CERTIFICATE);
        return outputCert;
    }

    public static final void lockLicenseFile() {
        File licenseFile = new File("./configs/License.txt");
        Random r = new Random(System.currentTimeMillis());
        int xChar = r.nextInt(65535);
        while (xChar == 0) {
            xChar = r.nextInt(65535);
        }
        try {
            ASCFileReader fr = new ASCFileReader(licenseFile);
            String licenseData = fr.readAll();
            char[] newLicenseData = new char[licenseData.length()];
            int i = 0;
            while (i < licenseData.length()) {
                newLicenseData[i] = (char)(licenseData.charAt(i) ^ xChar);
                xChar = newLicenseData[i];
                while (xChar == 0) {
                    xChar = r.nextInt(65535);
                }
                ++i;
            }
            new ASCFileWriter(licenseFile, new String(newLicenseData));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static final String formatBase64(String base64) {
        StringBuilder sb = new StringBuilder();
        int offset = 0;
        int base64Length = base64.length();
        while (offset + 64 < base64Length) {
            String segment = base64.substring(offset, offset + 64);
            sb.append(segment);
            sb.append("\n");
            offset += 64;
        }
        if (offset < base64Length) {
            sb.append(base64.substring(offset));
            sb.append("\n");
        }
        return sb.toString();
    }

    @Reflected
    public static void checkLicenseAgainstAppliances(ArrayList<Appliance> appliances) {
        LICENSE_START_DATE = new Date(LICENSE.getNotBefore());
        LICENSE_END_DATE = new Date(LICENSE.getNotAfter());
        DataPowerStatusCache statusCache = new DataPowerStatusCache();
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        for (Appliance appliance : appliances) {
            Domain defaultDomain;
            DataPowerStatusMonitor statusMonitor;
            AsynchMethodInvoker<Void> thread;
            if (!appliance.isActive() || !appliance.isConnected() || (thread = (statusMonitor = new DataPowerStatusMonitor(appliance, defaultDomain = appliance.getDomain("default"), "DateTimeStatus", 0L)).getProcessThread()) == null) continue;
            mtil.addThread(thread);
            statusMonitor.addStatusListener(statusCache);
        }
        ThreadManager.monitorAsynchThreadLifeCycle("LicenseManager.checkLicenseAgainstAppliances(...)", mtil, appliances.size() * KumbaCoreConstants.STARTUP_DELAY, 0);
        ArrayList applianceDTStamps = statusCache.getStatusCache();
        for (StatusDateTimeStatus timeStamp : applianceDTStamps) {
            String statusTime = timeStamp.getTime();
            DateTime statusDate = new DateTime(statusTime);
            long startDateDifference = DateMath.getDayDifference(statusDate.getDate(), LICENSE_START_DATE);
            long endDateDifference = DateMath.getDayDifference(statusDate.getDate(), LICENSE_END_DATE);
            if (startDateDifference <= 2L && endDateDifference >= -2L) continue;
            LicenseManager.lockLicenseFile();
            if (licenseNotificationListener != null) {
                licenseNotificationListener.noLicenseAvailable(LICENSE_EXPIRED_TEXT);
            }
            System.err.println(LICENSE_EXPIRED_TEXT);
            System.exit(-202);
        }
    }

    public static void checkLicenseEntitlement(Class<?> applicationType) {
        LicenseInformation licenseInformation = new LicenseInformation(LICENSE);
        if (licenseInformation.isEntitledTo(applicationType.getSimpleName())) {
            return;
        }
        if (licenseNotificationListener != null) {
            licenseNotificationListener.applicationNotEntitled(NO_ENTITLEMENT_TEXT);
        }
        System.err.println(NO_ENTITLEMENT_TEXT);
        System.exit(-300);
    }

    public static boolean isFeatureEntitlementAllowed(Class<?> type) {
        Entitlements entitlements = (Entitlements)BeanService.getClassAnnotation(type, Entitlements.class);
        if (entitlements == null) {
            return true;
        }
        LicenseInformation licenseInformation = new LicenseInformation(LICENSE);
        DateTime notBeforeDT = licenseInformation.getNotBefore();
        Date notBefore = notBeforeDT.getDate();
        int cevp = licenseInformation.getCommunityEditionValidityPeriod();
        notBefore.addMonths(cevp);
        Date today = new Date();
        return !today.isAfter(notBefore);
    }
}

