/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.util.security;

import com.jmorgan.lang.Application;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;

public class TLSTrustManager
implements X509TrustManager {
    public static boolean SHOW_CLIENT_CERTS = false;
    public static boolean SHOW_SERVER_CERTS = false;

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certs, String authType) {
        if (SHOW_CLIENT_CERTS) {
            Application.getApplication().getApplicationLogger().fine(String.format("SSLHelper.checkClientTrusted(X509Certificate[], authType=%s)\n\n", authType));
            TLSTrustManager.showCertificates(certs);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certs, String authType) {
        if (SHOW_SERVER_CERTS) {
            Application.getApplication().getApplicationLogger().fine(String.format("SSLHelper.checkServerTrusted(X509Certificate[], authType=%s)\n\n", authType));
            TLSTrustManager.showCertificates(certs);
        }
    }

    private static void showCertificates(X509Certificate[] certs) {
        X509Certificate[] x509CertificateArray = certs;
        int n = certs.length;
        int n2 = 0;
        while (n2 < n) {
            X509Certificate cert = x509CertificateArray[n2];
            Date notBefore = cert.getNotBefore();
            Date notAfter = cert.getNotAfter();
            X500Principal principal = cert.getSubjectX500Principal();
            Application.getApplication().getApplicationLogger().fine(String.format("\t%s\n\tNot Before: %s\n\tNot After: %s\n\n", principal.getName(), notBefore.toString(), notAfter.toString()));
            ++n2;
        }
    }
}

