/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.io.ASCFileReader;
import com.jmorgan.j2ee.xml.XMLFormatter;
import com.jmorgan.swing.JMDialog;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.event.ContainerEventInvoker;
import com.jmorgan.swing.splitpane.SplitPane;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanRowSorter;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.swing.table.DynamicBeanColumnModel;
import com.jmorgan.swing.table.DynamicBeanRowSorter;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.jmorgan.swing.util.ContainerService;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.swing.util.ScrollSynchronizer;
import com.jmorgan.util.Date;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.DynamicClassLoader;
import com.jmorgan.util.Pair;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.AbstractLogEntry;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.AuditLogEntry;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.DataPowerStatus;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.LogEntry;
import com.kumbasoft.core.parsers.errorreport.AbstractErrorReportParser;
import com.kumbasoft.core.parsers.errorreport.XMLErrorReportParser;
import com.kumbasoft.core.tools.DataPowerStatusParser;
import com.kumbasoft.core.tools.LogParser;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.renderers.AuditLogBeanTableCellRenderer;
import com.kumbasoft.core.ui.renderers.LogEntryBeanTableCellRenderer;
import com.kumbasoft.dpaa.ui.panels.files.FileEditorPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JViewport;
import javax.swing.table.TableColumn;

public class ErrorReportDialog
extends JMDialog {
    private HashMap<String, Pair<JMTable, BeanTableModel<DataPowerStatus>>> statusModels = new HashMap();
    private HashMap<Pair<Domain, String>, Pair<JMTable, BeanTableModel<AbstractLogEntry>>> logModels = new HashMap();
    private ArrayList<DataPowerFileInfo> files;
    private ArrayList<JMScrollPane> customElements;
    private LogParser logParser;
    private JMPanel displayPanel;

    public ErrorReportDialog(JFrame owner, Object ... arguments) {
        super(owner, "View Error Report Section", true, arguments);
    }

    @Override
    public void buildGUI(Object ... arguments) {
        this.displayPanel = KumbaCoreUIConstants.createGridLayoutPanel(1, 0);
        this.add(new JMScrollPane(this.displayPanel));
        this.setSize(800, 800);
        this.setPreferredSize(new Dimension(800, 800));
        this.setDefaultCloseOperation(2);
        new ContainerEventInvoker(this.displayPanel, 101, (Object)this, "resizePanels");
    }

    @Override
    protected boolean getInitialVisibility() {
        return false;
    }

    public void addStatus(Appliance appliance, Domain domain, String sectionName, File sectionFile) {
        BeanTableModel<DataPowerStatus> tableModel;
        Pair<JMTable, BeanTableModel<DataPowerStatus>> models = this.statusModels.get(sectionName);
        JMTable statusTable = models == null ? null : models.getFirst();
        BeanTableModel<DataPowerStatus> beanTableModel = tableModel = models == null ? null : models.getSecond();
        if (tableModel == null) {
            tableModel = ErrorReportDialog.createStatusTableModel(sectionName);
            statusTable = new JMTable(tableModel, ErrorReportDialog.createStatusColumnModel(tableModel));
            BeanRowSorter<DataPowerStatus> rowSorter = new BeanRowSorter<DataPowerStatus>(tableModel);
            statusTable.setRowSorter(rowSorter);
            this.statusModels.put(sectionName, new Pair<JMTable, BeanTableModel<DataPowerStatus>>(statusTable, tableModel));
            JMPanel titledPanel = KumbaCoreUIConstants.createBorderLayoutPanel();
            titledPanel.add((Component)new JMLabel(sectionName), "North");
            titledPanel.add(new JMScrollPane(statusTable));
            this.displayPanel.add(titledPanel);
        }
        String fileData = ErrorReportDialog.readFile(sectionFile);
        DataPowerStatusParser parser = new DataPowerStatusParser(appliance, domain, sectionName, new DateTime(sectionFile.lastModified()));
        Collection statusBeans = parser.processStatusData(fileData);
        tableModel.addAll(statusBeans);
        statusTable.optimizeColumnWidths();
    }

    private static BeanTableModel<DataPowerStatus> createStatusTableModel(String statusTypeName) {
        String statusFQCN = ErrorReportDialog.getStatusClassName(statusTypeName);
        try {
            Class<?> statusClass = DynamicClassLoader.loadClass(statusFQCN);
            BeanTableModel<DataPowerStatus> tableModel = new BeanTableModel<DataPowerStatus>(statusClass);
            tableModel.addComputedExpression("appliance", "appliance.name");
            tableModel.addComputedExpression("sourceDomain", "sourceDomain.name");
            return tableModel;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static BeanColumnModel<DataPowerStatus> createStatusColumnModel(BeanTableModel<DataPowerStatus> tableModel) {
        BeanColumnModel<DataPowerStatus> columnModel = new BeanColumnModel<DataPowerStatus>(tableModel);
        columnModel.hideColumn("fQON");
        ArrayList<String> columnNames = new ArrayList<String>(columnModel.getColumnCount());
        Enumeration<TableColumn> columns = columnModel.getColumns();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            String columnName = column.getIdentifier().toString();
            if (columnName.equals("appliance") || columnName.equals("sourceDomain") || columnName.equals("statusTime")) continue;
            columnNames.add(columnName);
        }
        Collections.sort(columnNames);
        columnNames.add(0, "appliance");
        columnNames.add(1, "sourceDomain");
        columnNames.add("statusTime");
        columnModel.setColumnOrder(columnNames);
        return columnModel;
    }

    public void addLog(Appliance appliance, Domain domain, String sectionName, File sectionFile) {
        BeanTableModel<AbstractLogEntry> logEntryTableModel;
        String baseFileName = sectionFile.getName();
        if (this.logParser == null) {
            this.logParser = new LogParser(appliance, domain, sectionName, baseFileName);
        } else {
            this.logParser.setAppliance(appliance);
            this.logParser.setDomain(domain);
            this.logParser.setBaseFileName(sectionFile.getName());
        }
        String fileData = ErrorReportDialog.readFile(sectionFile);
        ArrayList<AbstractLogEntry> logEntries = new ArrayList<AbstractLogEntry>();
        this.logParser.processLogEntry(fileData, logEntries);
        Pair<Domain, String> modelKey = new Pair<Domain, String>(domain, baseFileName);
        Pair<JMTable, BeanTableModel<AbstractLogEntry>> models = this.logModels.get(modelKey);
        JMTable logEntryTable = models == null ? null : models.getFirst();
        BeanTableModel<AbstractLogEntry> beanTableModel = logEntryTableModel = models == null ? null : models.getSecond();
        if (models == null) {
            logEntryTableModel = ErrorReportDialog.createLogTableModel(sectionName);
            logEntryTable = new JMTable(logEntryTableModel, ErrorReportDialog.createLogColumnModel(logEntryTableModel));
            BeanRowSorter<AbstractLogEntry> rowSorter = new BeanRowSorter<AbstractLogEntry>(logEntryTableModel);
            logEntryTable.setRowSorter(rowSorter);
            this.logModels.put(modelKey, new Pair<JMTable, BeanTableModel<AbstractLogEntry>>(logEntryTable, logEntryTableModel));
            JMPanel titledPanel = KumbaCoreUIConstants.createBorderLayoutPanel();
            titledPanel.add((Component)new JMLabel(sectionName), "North");
            titledPanel.add(new JMScrollPane(logEntryTable));
            this.displayPanel.add(titledPanel);
        }
        logEntryTableModel.addAll(logEntries);
        logEntryTable.optimizeColumnWidths();
    }

    private static BeanTableModel<AbstractLogEntry> createLogTableModel(String sectionName) {
        Class logTypeClass = null;
        logTypeClass = sectionName.startsWith("AuditLog") ? AuditLogEntry.class : LogEntry.class;
        BeanTableModel<AbstractLogEntry> tableModel = new BeanTableModel<AbstractLogEntry>(logTypeClass);
        tableModel.addComputedExpression("appliance", "appliance.name");
        tableModel.addComputedExpression("domain", "domain.name");
        return tableModel;
    }

    private static BeanColumnModel<? extends AbstractLogEntry> createLogColumnModel(BeanTableModel<? extends AbstractLogEntry> tableModel) {
        BeanColumnModel<? extends AbstractLogEntry> columnModel = new BeanColumnModel<AbstractLogEntry>(tableModel);
        ArrayList<String> columnNames = new ArrayList<String>(columnModel.getColumnCount());
        Enumeration<TableColumn> columns = columnModel.getColumns();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            String columnName = column.getIdentifier().toString();
            if (columnName.equals("appliance") || columnName.equals("domain") || columnName.equals("time")) continue;
            columnNames.add(columnName);
        }
        Collections.sort(columnNames);
        columnNames.add(0, "appliance");
        columnNames.add(1, "domain");
        columnNames.add(2, "time");
        columnModel.setColumnOrder(columnNames);
        Class<? extends AbstractLogEntry> elementType = tableModel.getModelElementType();
        if (elementType.equals(LogEntry.class)) {
            cellRenderer = new LogEntryBeanTableCellRenderer(tableModel);
            columnModel.setRenderer(".*", cellRenderer);
        } else {
            cellRenderer = new AuditLogBeanTableCellRenderer(tableModel);
            columnModel.setRenderer(".*", cellRenderer);
        }
        return columnModel;
    }

    public void addCustom(Appliance appliance, Domain domain, String sectionName, File sectionFile, AbstractErrorReportParser processor) {
        if (this.customElements == null) {
            this.customElements = new ArrayList();
        }
        processor.setFile(sectionFile);
        if (processor instanceof XMLErrorReportParser) {
            XMLErrorReportParser parser = (XMLErrorReportParser)processor;
            ArrayList data = (ArrayList)parser.parseErrorReportData(appliance, domain);
            DynamicBeanTableModel tableModel = ErrorReportDialog.createCustomTableModel(data);
            DynamicBeanColumnModel columnModel = ErrorReportDialog.createCustomColumnModel(tableModel);
            DynamicBeanRowSorter rowSorter = new DynamicBeanRowSorter(tableModel);
            JMTable table = new JMTable(tableModel, columnModel);
            table.setRowSorter(rowSorter);
            JMScrollPane scrollPane = new JMScrollPane(table);
            this.customElements.add(scrollPane);
        }
    }

    private static DynamicBeanTableModel createCustomTableModel(ArrayList<DynamicBean> data) {
        DynamicBeanTableModel model = new DynamicBeanTableModel();
        model.addAll(data);
        return model;
    }

    private static DynamicBeanColumnModel createCustomColumnModel(DynamicBeanTableModel tableModel) {
        DynamicBeanColumnModel model = new DynamicBeanColumnModel(tableModel);
        return model;
    }

    public void addFile(Appliance appliance, Domain domain, String sectionName, File sectionFile, String displayName) {
        Date lastModified = new Date(sectionFile.lastModified());
        String fileData = ErrorReportDialog.readFile(sectionFile);
        DataPowerFileInfo fileInfo = new DataPowerFileInfo(appliance, domain, lastModified.toString(), sectionFile.length(), "temporary:", displayName);
        fileInfo.setFileContent(fileData);
        if (this.files == null) {
            this.files = new ArrayList();
        }
        this.files.add(fileInfo);
    }

    @Override
    public void setVisible(boolean visibility) {
        ScrollSynchronizer scrollSynchronizer;
        Container container;
        if (!visibility) {
            super.setVisible(visibility);
            return;
        }
        if (this.files != null) {
            container = this.getContainer(this.files);
            scrollSynchronizer = new ScrollSynchronizer();
            for (DataPowerFileInfo fileInfo : this.files) {
                FileEditorPanel filePanel = new FileEditorPanel(fileInfo, false);
                JMScrollPane scrollPanel = filePanel.getScrollPane();
                scrollSynchronizer.addScrollPane(scrollPanel);
                JEditorPane fileEditor = filePanel.getFileDataEditor();
                String contentType = fileEditor.getContentType();
                if (contentType.contains("xml")) {
                    String editorText = fileEditor.getText();
                    editorText = XMLFormatter.format(editorText);
                    fileEditor.setText(editorText);
                }
                container.add(filePanel);
            }
        }
        if (this.customElements != null) {
            container = this.getContainer(this.customElements);
            scrollSynchronizer = new ScrollSynchronizer();
            for (JMScrollPane scrollPane : this.customElements) {
                container.add(scrollPane);
                scrollSynchronizer.addScrollPane(scrollPane);
                JViewport viewPort = (JViewport)scrollPane.getComponent(0);
                List<JMTable> tables = ContainerService.findComponentsByType(viewPort, JMTable.class);
                for (JMTable table : tables) {
                    table.optimizeColumnWidths();
                }
            }
        }
        super.setVisible(visibility);
    }

    private Container getContainer(ArrayList<?> elements) {
        int numberOfElements;
        JMPanel container = this.displayPanel;
        if (elements != null && (numberOfElements = elements.size()) > 1) {
            SplitPane splitPanel = new SplitPane(1, numberOfElements);
            this.displayPanel.add(splitPanel);
            container = splitPanel;
            new ContainerEventInvoker(container, 2, (Object)this, "forceRepaint");
        }
        return container;
    }

    @Reflected
    private void forceRepaint() {
        GUIServices.forciblyRevalidate(this);
    }

    private static String getStatusClassName(String statusTypeName) {
        String statusFQCN = String.format("com.kumbasoft.core.beans.status.Status%s", statusTypeName);
        return statusFQCN;
    }

    private static String readFile(File sectionFile) {
        long fileLength = sectionFile.length();
        if (fileLength > KumbaCoreConstants.MAX_FILE_READ_SIZE) {
            return "*** File Exceeds Maximum File Size ***";
        }
        try {
            ASCFileReader reader = new ASCFileReader(sectionFile);
            return reader.readAll();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Reflected
    private void resizePanels() {
        Dimension newSize = this.displayPanel.getSize();
        int newPanelHeight = newSize.height - 104;
        int numPanels = this.displayPanel.getComponentCount();
        int i = 0;
        while (i < numPanels) {
            Component fep = this.displayPanel.getComponent(i);
            Dimension fepSize = fep.getSize();
            fepSize.height = newPanelHeight;
            fep.setSize(fepSize);
            fep.setPreferredSize(fepSize);
            ++i;
        }
    }
}

