/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs;

import com.jmorgan.swing.JMDialog;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.Pair;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.comparator.BeanComparator;
import com.kumbasoft.core.beans.DataPowerStatus;
import com.kumbasoft.core.beans.StatusProviderInfo;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.dpaa.ui.dialogs.DataPowerStatusDiffPanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JFrame;

public class StatusFileDiffDialog
extends JMDialog {
    public StatusFileDiffDialog(JFrame owner, Object ... arguments) {
        super(owner, true, arguments);
    }

    @Override
    public void buildGUI(Object ... arguments) {
        StatusProviderInfo statusProviderInfo = (StatusProviderInfo)arguments[0];
        ArrayList currentData = (ArrayList)arguments[1];
        ArrayList compareData = (ArrayList)arguments[2];
        DateTime compareTime = (DateTime)arguments[3];
        ArrayList allProperties = (ArrayList)arguments[4];
        ArrayList compareProperties = (ArrayList)arguments[5];
        allProperties.remove("appliance");
        allProperties.remove("sourceDomain");
        allProperties.remove("statusTime");
        allProperties.remove("fQON");
        Collections.sort(allProperties);
        allProperties.add(0, "sourceDomain");
        allProperties.add(0, "appliance");
        allProperties.add("statusTime");
        BeanComparator sorter = new BeanComparator(allProperties);
        Collections.sort(currentData, sorter);
        Collections.sort(compareData, sorter);
        Collection diffData = CollectionUtility.getDiff(currentData, compareData, compareProperties);
        ArrayList<DataPowerStatus> leftData = new ArrayList<DataPowerStatus>();
        ArrayList<DataPowerStatus> rightData = new ArrayList<DataPowerStatus>();
        for (Pair diffElement : diffData) {
            leftData.add((DataPowerStatus)diffElement.first);
            rightData.add((DataPowerStatus)diffElement.second);
        }
        String title = String.format("Comparing current status for %s to the one taken at %s", statusProviderInfo.getDisplayName(), compareTime.toString());
        this.setTitle(title);
        DataPowerStatusDiffPanel leftPanel = new DataPowerStatusDiffPanel("Current Status", leftData, allProperties, null);
        DataPowerStatusDiffPanel rightPanel = new DataPowerStatusDiffPanel(compareTime.toString(), rightData, allProperties, leftPanel.getColumnModel());
        rightPanel.synchronizeScrolling(leftPanel.gethScrollBar(), leftPanel.getvScrollBar());
        rightPanel.syncronizeSelection(leftPanel.getSelectionModel());
        JMPanel panel = KumbaCoreUIConstants.createGridLayoutPanel(1, 2);
        panel.addAll(leftPanel, rightPanel);
        this.contentPane.add(panel);
        panel.setPreferredSize(1000, 800);
        this.setSize(1000, 800);
    }
}

