/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.advancedSearch;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.GUIApplication;
import com.jmorgan.swing.menu.PopupMenuController;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.StringOptionsTableCellEditor;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.AdvancedObjectSearchOptions;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.ObjectPropertyDefinition;
import com.kumbasoft.core.beans.SearchOptions;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.KumbaCoreGUIApplicationProperties;
import com.kumbasoft.core.ui.panel.AbstractSearchOptionsPanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AdvancedObjectSearchPanel
extends AbstractSearchOptionsPanel<AdvancedObjectSearchOptions>
implements PopupMenuController {
    public static ArrayList<AdvancedObjectSearchOptions> searchOptions;
    private List<String> selectedTypes;
    private Index<String, ObjectPropertyDefinition> propertyNameDefinitionMap;
    private static final List<String> EXEMPT_SEARCH_PROPERTIES;
    private static final String[] EXEMPT_STATUS_PROPERTIES;

    static {
        EXEMPT_SEARCH_PROPERTIES = CollectionUtility.createListFrom("appliance", "configObjectType", "fQON", "sourceDomain");
        EXEMPT_STATUS_PROPERTIES = new String[]{"appliance", "sourceDomain", "dataPowerClass", "adminState", "name", "fQON", "statusTime"};
    }

    public AdvancedObjectSearchPanel(List<String> selectedTypes, ArrayList<AdvancedObjectSearchOptions> searchOptions) {
        super(AdvancedObjectSearchOptions.class, selectedTypes, searchOptions);
        this.tableModel.addAll(AdvancedObjectSearchPanel.searchOptions);
        this.setButtonState(this.tableModel.getRowCount() > 0);
    }

    @Override
    protected String getSearchSettingsDirectoryName() {
        KumbaCoreGUIApplicationProperties kumbaCoreGUIApplicationProperties = (KumbaCoreGUIApplicationProperties)GUIApplication.getGUIApplication().getApplicationProperties();
        String searchSettingsDirectoryName = kumbaCoreGUIApplicationProperties.getObjectSearchDirectory();
        return searchSettingsDirectoryName;
    }

    @Override
    protected boolean updateSearchOptionsFromTable() {
        searchOptions = this.tableModel.getModelData();
        for (AdvancedObjectSearchOptions searchOption : searchOptions) {
            String displayName = searchOption.getPropertyDisplayName();
            Collection<ObjectPropertyDefinition> propertyDefinitions = this.propertyNameDefinitionMap.get(displayName);
            searchOption.setPropertyDefinitions(propertyDefinitions);
        }
        return true;
    }

    @Override
    protected AdvancedObjectSearchOptions createRowInstance() {
        return new AdvancedObjectSearchOptions();
    }

    @Override
    protected BeanColumnModel<AdvancedObjectSearchOptions> getColumnModel() {
        this.selectedTypes = (List)this.arguments[0];
        searchOptions = (ArrayList)this.arguments[1];
        this.propertyNameDefinitionMap = new Index();
        BeanColumnModel<AdvancedObjectSearchOptions> columnModel = super.getColumnModel();
        columnModel.hideColumn("propertyDefinitions");
        columnModel.setColumnOrder("propertyDisplayName", "matchingExpression", "logicalOperator");
        columnModel.setColumnTitle("propertyDisplayName", "Property Name");
        UniqueArrayList<String> allProperties = new UniqueArrayList<String>();
        for (String objectType : this.selectedTypes) {
            ArrayList<String> properties = this.getPropertyList(objectType);
            allProperties.addAll(properties);
        }
        allProperties.sort();
        if (CollectionUtility.isNotEmpty(searchOptions)) {
            ArrayList<AdvancedObjectSearchOptions> looper = new ArrayList<AdvancedObjectSearchOptions>(searchOptions);
            for (SearchOptions searchOptions : looper) {
                String propertyDisplayName = searchOptions.getPropertyDisplayName();
                if (allProperties.contains(propertyDisplayName)) continue;
                AdvancedObjectSearchPanel.searchOptions.remove(searchOptions);
            }
        }
        columnModel.setEditor("propertyDisplayName", new StringOptionsTableCellEditor(allProperties));
        columnModel.setEditor("logicalOperator", new StringOptionsTableCellEditor(new String[]{"AND", "OR"}));
        return columnModel;
    }

    private ArrayList<String> getPropertyList(String objectType) {
        AbstractPanel.logger.finer(() -> LMG.log("(objectType=%s): Starting", () -> objectType));
        Class<? extends DataPowerConfig> objectClass = ConfigurationManager.getConfigObjectClass(objectType);
        if (objectClass == null) {
            AbstractPanel.logger.severe(() -> LMG.log("(objectType=%s): Class doesn't exist for type %s.  WHY???", () -> objectType, () -> objectType));
            return new ArrayList<String>();
        }
        AbstractPanel.logger.finer(() -> LMG.log("(objectType=%s): Object class is '%s'.", () -> objectType, () -> objectClass));
        ArrayList<String> properties = BeanService.getPropertyNames(objectClass);
        properties.removeAll(EXEMPT_SEARCH_PROPERTIES);
        ArrayList<String> propertyList = new ArrayList<String>(properties.size());
        for (String propertyName : properties) {
            AbstractPanel.logger.finer(() -> LMG.log("(objectType=%s): Building definition for property '%s'.", () -> objectType, () -> propertyName));
            if (propertyName.equals("status")) {
                ArrayList<String> statusProperties = BeanService.getPropertyNames(StatusObjectStatus.class);
                for (String statusPropertyName : statusProperties) {
                    if (Comparison.isIn(statusPropertyName, EXEMPT_STATUS_PROPERTIES)) continue;
                    String fullPropertyName = String.format("status.%s", statusPropertyName);
                    AbstractPanel.logger.finer(() -> LMG.log("(objectType=%s): Building definition for property '%s'.", () -> objectType, () -> fullPropertyName));
                    ObjectPropertyDefinition propertyDefinition = new ObjectPropertyDefinition(objectClass, fullPropertyName, StringUtility.getDisplayableTitle(statusPropertyName));
                    this.propertyNameDefinitionMap.put(propertyDefinition.getDisplayName(), propertyDefinition);
                    propertyList.add(propertyDefinition.getDisplayName());
                }
                continue;
            }
            ObjectPropertyDefinition propertyDefinition = new ObjectPropertyDefinition(objectClass, propertyName);
            this.propertyNameDefinitionMap.put(propertyDefinition.getDisplayName(), propertyDefinition);
            propertyList.add(propertyDefinition.getDisplayName());
        }
        AbstractPanel.logger.finer(() -> LMG.log("(objectType=%s): Done.  Returning list of %d properties", () -> objectType, () -> propertyList.size()));
        return propertyList;
    }
}

