/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.advancedSearch;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.GUIApplication;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.swing.table.StringOptionsTableCellEditor;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.beans.DataPowerStatus;
import com.kumbasoft.core.beans.SearchOptions;
import com.kumbasoft.core.beans.StatusProviderInfo;
import com.kumbasoft.core.ui.KumbaCoreGUIApplicationProperties;
import com.kumbasoft.core.ui.panel.AbstractSearchOptionsPanel;
import java.util.ArrayList;
import java.util.Collections;

public class AdvancedStatusSearchPanel
extends AbstractSearchOptionsPanel<SearchOptions> {
    private static final String[] NON_SEARCHACBLE_PROPERTIES = new String[]{"appliance", "sourceDomain", "statusTime", "fQON"};
    public static String searchOptionsString;
    private StatusProviderInfo statusProviderInfo;

    public AdvancedStatusSearchPanel(String searchOptions, StatusProviderInfo statusProviderInfo) {
        super(SearchOptions.class, searchOptions, statusProviderInfo);
        searchOptionsString = searchOptions;
        this.tableModel.addAll(AdvancedStatusSearchPanel.buildSearchOptionsFromString());
        this.setButtonState(this.tableModel.getRowCount() > 0);
    }

    @Override
    protected int getTopControlsButtonSpacerWidth() {
        return 113;
    }

    private static ArrayList<SearchOptions> buildSearchOptionsFromString() {
        ArrayList<SearchOptions> searchOptions = new ArrayList<SearchOptions>();
        if (StringUtility.isNotEmpty(searchOptionsString)) {
            String[] searchSpecs = null;
            if (searchOptionsString.contains(",")) {
                searchSpecs = searchOptionsString.split(",");
                int i = 0;
                while (i < searchSpecs.length) {
                    searchSpecs[i] = searchSpecs[i].trim();
                    ++i;
                }
            } else {
                searchSpecs = new String[]{searchOptionsString.trim()};
            }
            String[] stringArray = searchSpecs;
            int n = searchSpecs.length;
            int n2 = 0;
            while (n2 < n) {
                String searchSpec = stringArray[n2];
                if (searchSpec.contains("=")) {
                    String[] nameValuePair = searchSpec.split("=");
                    SearchOptions searchOption = new SearchOptions(nameValuePair[0], nameValuePair[1]);
                    searchOptions.add(searchOption);
                }
                ++n2;
            }
        }
        return searchOptions;
    }

    @Override
    protected SearchOptions createRowInstance() {
        return new SearchOptions();
    }

    @Override
    protected String getSearchSettingsDirectoryName() {
        KumbaCoreGUIApplicationProperties kumbaCoreGUIApplicationProperties = (KumbaCoreGUIApplicationProperties)GUIApplication.getGUIApplication().getApplicationProperties();
        String searchSettingsDirectoryName = kumbaCoreGUIApplicationProperties.getStatusSearchDirectory();
        return searchSettingsDirectoryName;
    }

    @Override
    protected boolean updateSearchOptionsFromTable() {
        ArrayList searchOptions = this.tableModel.getModelData();
        StringBuilder sb = new StringBuilder();
        for (SearchOptions searchOption : searchOptions) {
            String propertyName = searchOption.getPropertyDisplayName();
            if (StringUtility.isEmpty(propertyName)) continue;
            String expression = searchOption.getMatchingExpression();
            if (StringUtility.isEmpty(expression)) {
                expression = ".*";
            }
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(propertyName);
            sb.append("=");
            sb.append(expression);
        }
        searchOptionsString = sb.toString();
        return true;
    }

    @Override
    public BeanTableModel<SearchOptions> getTableModel() {
        BeanTableModel<SearchOptions> tableModel = super.getTableModel();
        tableModel.setModelElementType(SearchOptions.class);
        return tableModel;
    }

    @Override
    protected BeanColumnModel<SearchOptions> getColumnModel() {
        this.statusProviderInfo = (StatusProviderInfo)this.arguments[1];
        BeanColumnModel<SearchOptions> columnModel = super.getColumnModel();
        columnModel.setColumnOrder("propertyDisplayName", "matchingExpression");
        columnModel.setColumnTitle("propertyDisplayName", "Property Name");
        columnModel.hideColumn("logicalOperator");
        Class<? extends DataPowerStatus> statusClass = this.statusProviderInfo.getStatusClass();
        ArrayList<String> allProperties = BeanService.getPropertyNames(statusClass);
        ArrayList<String> propertyNames = new ArrayList<String>(allProperties.size() - NON_SEARCHACBLE_PROPERTIES.length);
        for (String property : allProperties) {
            if (Comparison.isIn(property, NON_SEARCHACBLE_PROPERTIES)) continue;
            propertyNames.add(StringUtility.getDisplayableTitle(property));
        }
        Collections.sort(propertyNames);
        columnModel.setEditor("propertyDisplayName", new StringOptionsTableCellEditor(propertyNames));
        return columnModel;
    }

    @Override
    protected boolean isFileNameApplicable(String fileName) {
        return fileName.startsWith(this.getFileNamePrefix());
    }

    @Override
    protected String getFileNamePrefix() {
        return this.statusProviderInfo.getName() + "_";
    }
}

